/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class InlineProgressIndicator
extends ProgressIndicatorBase
implements Disposable {
    private final FixedHeightLabel myText = new FixedHeightLabel();
    private final FixedHeightLabel myText2 = new FixedHeightLabel();
    private MyProgressBar myProgress;
    private JPanel myComponent;
    private final InplaceButton myCancelButton;
    private final boolean myCompact;
    private TaskInfo myInfo;
    private final FixedHeightLabel myProcessName = new FixedHeightLabel();
    private boolean myDisposed;
    private long myLastTimeProgressWasAtZero;
    private boolean myLastTimeProgressWasZero;

    public InlineProgressIndicator(boolean compact, TaskInfo processInfo) {
        this.myCompact = compact;
        this.myInfo = processInfo;
        this.myCancelButton = new InplaceButton(new IconButton(processInfo.getCancelTooltipText(), IconLoader.getIcon((String)"/process/stop.png"), IconLoader.getIcon((String)"/process/stopHovered.png")){}, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineProgressIndicator.this.cancelRequest();
            }
        }).setFillBg(true);
        this.myCancelButton.setVisible(this.myInfo.isCancellable());
        this.myCancelButton.setOpaque(true);
        this.myCancelButton.setToolTipText(processInfo.getCancelTooltipText());
        this.myProgress = new MyProgressBar(0, compact);
        this.myComponent = new MyComponent(compact, this.myProcessName);
        if (this.myCompact) {
            this.myComponent.setOpaque(true);
            this.myComponent.setLayout(new BorderLayout(2, 0));
            JPanel textAndProgress = new JPanel(new BorderLayout());
            this.myText.setHorizontalAlignment(2);
            textAndProgress.add((Component)this.myText, "Center");
            NonOpaquePanel progressWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 2;
            progressWrapper.add((Component)this.myProgress, (Object)c);
            textAndProgress.add((Component)progressWrapper, "East");
            this.myComponent.add((Component)textAndProgress, "Center");
            this.myComponent.add((Component)this.myCancelButton, "East");
            this.myComponent.setToolTipText(processInfo.getTitle() + ". " + IdeBundle.message((String)"progress.text.clickToViewProgressWindow", (Object[])new Object[0]));
            this.myProgress.setActive(false);
        } else {
            this.myComponent.setLayout(new BorderLayout());
            this.myProcessName.setText(processInfo.getTitle());
            this.myComponent.add((Component)this.myProcessName, "North");
            Font font = this.myProcessName.getFont();
            boolean aqua = LafManager.getInstance().isUnderAquaLookAndFeel();
            int size = font.getSize() - (aqua ? 4 : 2);
            if (size < (aqua ? 8 : 10)) {
                size = aqua ? 8 : 10;
            }
            this.myProcessName.setFont(font.deriveFont(0, size));
            this.myProcessName.setForeground(UIManager.getColor("Panel.background").brighter().brighter());
            this.myProcessName.setBorder(new EmptyBorder(2, 2, 2, 2));
            NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout());
            content.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
            this.myComponent.add((Component)content, "Center");
            Wrapper cancelWrapper = new Wrapper((JComponent)this.myCancelButton);
            cancelWrapper.setOpaque(false);
            cancelWrapper.setBorder((Border)new EmptyBorder(0, 3, 0, 2));
            content.add((Component)cancelWrapper, (Object)"East");
            content.add((Component)this.myText, (Object)"North");
            content.add((Component)this.myProgress, (Object)"Center");
            content.add((Component)this.myText2, (Object)"South");
            this.myComponent.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.myProgress.setActive(false);
        }
        UIUtil.removeQuaquaVisualMarginsIn((Component)this.myComponent);
        if (!this.myCompact) {
            this.myText.recomputeSize();
            this.myText2.recomputeSize();
            this.myProcessName.recomputeSize();
        }
    }

    protected void cancelRequest() {
        this.cancel();
    }

    private void updateRunning() {
        this.queueRunningUpdate(EmptyRunnable.getInstance());
    }

    protected void updateProgress() {
        this.queueProgressUpdate(new Runnable(){

            @Override
            public void run() {
                if (InlineProgressIndicator.this.isDisposed()) {
                    return;
                }
                InlineProgressIndicator.this.updateProgressNow();
                InlineProgressIndicator.this.myComponent.repaint();
            }
        });
    }

    public void updateProgressNow() {
        boolean isStopping;
        if (this.myLastTimeProgressWasAtZero == 0L && this.getFraction() == 0.0) {
            this.myLastTimeProgressWasAtZero = System.currentTimeMillis();
        }
        long delta = System.currentTimeMillis() - this.myLastTimeProgressWasAtZero;
        boolean forcedIndeterminite = false;
        boolean indeterminate = this.isIndeterminate();
        if (!indeterminate && this.getFraction() == 0.0) {
            if (delta > 2000L && !this.myCompact) {
                indeterminate = true;
                forcedIndeterminite = true;
            } else {
                forcedIndeterminite = false;
            }
        }
        boolean visible = this.getFraction() > 0.0 || indeterminate || forcedIndeterminite;
        this.updateVisibility(this.myProgress, visible);
        if (indeterminate || forcedIndeterminite) {
            this.myProgress.setIndeterminate(true);
        } else {
            this.myProgress.setIndeterminate(false);
            this.myProgress.setMinimum(0);
            this.myProgress.setMaximum(100);
        }
        if (this.getFraction() > 0.0) {
            this.myProgress.setValue((int)(this.getFraction() * 99.0 + 1.0));
        }
        this.myText.setText(this.getText() != null ? this.getText() : "");
        this.myText2.setText(this.getText2() != null ? this.getText2() : "");
        if (this.myCompact && this.myText.getText().length() == 0) {
            this.myText.setText(this.myInfo.getTitle());
        }
        this.myCancelButton.setPainting(this.isCancelable());
        if (this.getFraction() == 0.0) {
            if (!this.myLastTimeProgressWasZero) {
                this.myLastTimeProgressWasAtZero = System.currentTimeMillis();
                this.myLastTimeProgressWasZero = true;
            }
        } else {
            this.myLastTimeProgressWasZero = false;
        }
        boolean bl = isStopping = this.wasStarted() && (this.isCanceled() || !this.isRunning()) && !this.isFinished();
        if (isStopping) {
            if (this.myCompact) {
                this.myText.setText("Stopping - " + this.myText.getText());
            } else {
                this.myProcessName.setText("Stopping - " + this.myInfo.getTitle());
            }
            this.myText.setEnabled(false);
            this.myText2.setEnabled(false);
            this.myProgress.setEnabled(false);
            this.myCancelButton.setPainting(false);
        } else {
            this.myText.setEnabled(true);
            this.myText2.setEnabled(true);
            this.myProgress.setEnabled(true);
            this.myCancelButton.setPainting(true);
        }
    }

    protected boolean isFinished() {
        return false;
    }

    protected void queueProgressUpdate(Runnable update) {
        update.run();
    }

    protected void queueRunningUpdate(Runnable update) {
        update.run();
    }

    private void updateVisibility(MyProgressBar bar, boolean holdsValue) {
        if (holdsValue && !bar.isActive()) {
            bar.setActive(true);
            bar.revalidate();
            bar.repaint();
            this.myComponent.revalidate();
            this.myComponent.repaint();
        } else if (!holdsValue && bar.isActive()) {
            bar.setActive(false);
            bar.revalidate();
            bar.repaint();
            this.myComponent.revalidate();
            this.myComponent.repaint();
        }
    }

    @Override
    protected void onProgressChange() {
        this.updateProgress();
    }

    @Override
    protected void onRunningChange() {
        this.updateRunning();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public TaskInfo getInfo() {
        return this.myInfo;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myComponent.removeAll();
        this.myComponent = null;
        if (this.myProgress != null) {
            UIUtil.disposeProgress((JProgressBar)this.myProgress);
        }
        this.myProgress = null;
        this.myInfo = null;
    }

    private boolean isDisposed() {
        return this.myDisposed;
    }

    private class MyComponent
    extends JPanel {
        private final boolean myCompact;
        private final FixedHeightLabel myProcessName;

        private MyComponent(boolean compact, FixedHeightLabel processName) {
            this.myCompact = compact;
            this.myProcessName = processName;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (UIUtil.isCloseClick((MouseEvent)e) && MyComponent.this.getBounds().contains(e.getX(), e.getY())) {
                        InlineProgressIndicator.this.cancelRequest();
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myCompact) {
                super.paintComponent(g);
                return;
            }
            GraphicsConfig c = new GraphicsConfig(g);
            c.setAntialiasing(true);
            int arc = 8;
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            Color bg = this.getBackground().darker().darker();
            bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 230);
            g.setColor(bg);
            Rectangle bounds = this.myProcessName.getBounds();
            Rectangle label = SwingUtilities.convertRectangle(this.myProcessName.getParent(), bounds, this);
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRoundRect(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2, arc, arc);
            g.fillRect(0, (int)label.getMaxY() + 1, this.getWidth() - 1, this.getHeight() / 2);
            g.setColor(bg);
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            c.restore();
        }
    }

    private static class MyProgressBar
    extends JProgressBar {
        private boolean myActive = true;
        private final boolean myCompact;

        public MyProgressBar(int orient, boolean compact) {
            super(orient);
            this.myCompact = compact;
            this.putClientProperty("JComponent.sizeVariant", "mini");
        }

        @Override
        public void paint(Graphics g) {
            if (!this.myActive) {
                return;
            }
            super.paint(g);
        }

        public boolean isActive() {
            return this.myActive;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.myActive && this.myCompact) {
                return new Dimension(0, 0);
            }
            return super.getPreferredSize();
        }

        public void setActive(boolean active) {
            this.myActive = active;
        }
    }

    private static class FixedHeightLabel
    extends JLabel {
        private Dimension myPrefSize;

        public void recomputeSize() {
            String old = this.getText();
            this.setText("XXX");
            this.myPrefSize = this.getPreferredSize();
            this.setText(old);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.myPrefSize != null) {
                size.height = this.myPrefSize.height;
            }
            return size;
        }
    }
}

