/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeEncodingUpdateGroup;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.wm.impl.status.StatusBarImpl;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.StatusBarTooltipper;
import com.intellij.openapi.wm.impl.status.TextPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.charset.Charset;
import javax.swing.JComponent;

public class EncodingPanel
extends TextPanel
implements StatusBarPatch {
    public EncodingPanel(final StatusBarImpl statusBar) {
        super(false, "windows-1251");
        StatusBarTooltipper.install(this, statusBar);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EncodingPanel.this.mouseClicked(statusBar);
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        boolean enabled;
        String text;
        if (selected != null) {
            VirtualFile file = EncodingPanel.getSelectedFile(selected);
            Pair<String, Boolean> result = ChangeEncodingUpdateGroup.update(file);
            text = (String)result.getFirst();
            enabled = (Boolean)result.getSecond();
            if (file != null) {
                Charset charset = ChooseFileEncodingAction.charsetFromContent(file);
                if (charset == null) {
                    charset = file.getCharset();
                }
                this.setText(charset.displayName());
            }
        } else {
            text = "";
            enabled = false;
            this.setText("");
        }
        this.setEnabled(enabled);
        return text;
    }

    private static VirtualFile getSelectedFile(Editor selected) {
        if (selected == null) {
            return null;
        }
        Document document = selected.getDocument();
        return FileDocumentManager.getInstance().getFile(document);
    }

    @Override
    public void clear() {
        this.setText("");
    }

    private Editor getEditor() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return EncodingPanel.getEditor(project);
    }

    private static Editor getEditor(Project project) {
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    private Project getProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
    }

    private void mouseClicked(StatusBarImpl statusBar) {
        VirtualFile virtualFile = EncodingPanel.getSelectedFile(this.getEditor());
        if (virtualFile == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        ChooseFileEncodingAction changeAction = new ChooseFileEncodingAction(virtualFile){

            @Override
            protected void chosen(VirtualFile virtualFile, Charset charset) {
                EncodingManager.getInstance().setEncoding(virtualFile, charset);
            }
        };
        DataContext context = DataManager.getInstance().getDataContext((Component)statusBar);
        DataContext dataContext = SimpleDataContext.getSimpleContext(PlatformDataKeys.VIRTUAL_FILE.getName(), virtualFile, SimpleDataContext.getSimpleContext(PlatformDataKeys.PROJECT.getName(), this.getProject(), context));
        Presentation presentation = changeAction.getTemplatePresentation();
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", presentation, ActionManager.getInstance(), 0);
        changeAction.update(event);
        DefaultActionGroup group = changeAction.createGroup(false);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 30);
        popup.showUnderneathOf((Component)this);
    }
}

