/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public final class TitlePanel
extends JPanel {
    private static final int DELAY = 5;
    private static final int TOTAL_FRAME_COUNT = 7;
    private int myCurrentFrame;
    public static final Color CNT_ENABLE_COLOR = new Color(105, 128, 180);
    public static final Color BND_ENABLE_COLOR = CNT_ENABLE_COLOR.brighter();
    private static final Color BND_DISABLE_COLOR = new Color(184, 184, 184);
    private static final Color CNT_DISABLE_COLOR = new Color(184, 184, 184);
    private float myBndStartRed;
    private float myBndStartGreen;
    private float myBndStartBlue;
    private float myBndEndRed;
    private float myBndEndGreen;
    private float myBndEndBlue;
    private Color myBndColor;
    private float myCntStartRed;
    private float myCntStartGreen;
    private float myCntStartBlue;
    private float myCntEndRed;
    private float myCntEndGreen;
    private float myCntEndBlue;
    private Color myCntColor;
    private final Alarm myFrameTicker;
    private final MyAnimator myAnimator;
    private boolean myActive = true;
    private JComponent mySideButtons;
    public static final Color BUTTON_SEPARATOR_COLOR = Color.white;
    private final Icon mySeparatorActive = IconLoader.getIcon((String)"/general/separator.png");
    private final Icon mySeparatorInactive = IconLoader.getIcon((String)"/general/inactiveSeparator.png");
    public static final Color ACTIVE_SIDE_BUTTON_BG = new Color(179, 197, 231);
    public static final Color INACTIVE_SIDE_BUTTON_BG = new Color(200, 200, 200);
    public static final int STRUT = 1;

    TitlePanel() {
        super(new BorderLayout());
        this.myFrameTicker = new Alarm();
        this.myAnimator = new MyAnimator();
        this.setLayout(new BorderLayout());
        this.setupColors(false);
        this.myCurrentFrame = 7;
        this.updateColor();
    }

    public void addTitle(JComponent component) {
        this.add((Component)component, "Center");
    }

    public final void setActive(boolean active, boolean animate) {
        if (active == this.myActive) {
            return;
        }
        this.myActive = active;
        this.myFrameTicker.cancelAllRequests();
        if (this.myCurrentFrame > 0) {
            this.myCurrentFrame = 7 - this.myCurrentFrame;
        }
        this.setupColors(active);
        if (animate) {
            this.myFrameTicker.addRequest((Runnable)this.myAnimator, 5);
        } else {
            this.myCurrentFrame = 7;
            this.updateColor();
        }
    }

    private void setupColors(boolean active) {
        if (active) {
            this.myBndStartRed = BND_DISABLE_COLOR.getRed();
            this.myBndStartGreen = BND_DISABLE_COLOR.getGreen();
            this.myBndStartBlue = BND_DISABLE_COLOR.getBlue();
            this.myBndEndRed = BND_ENABLE_COLOR.getRed();
            this.myBndEndGreen = BND_ENABLE_COLOR.getGreen();
            this.myBndEndBlue = BND_ENABLE_COLOR.getBlue();
            this.myCntStartRed = CNT_DISABLE_COLOR.getRed();
            this.myCntStartGreen = CNT_DISABLE_COLOR.getGreen();
            this.myCntStartBlue = CNT_DISABLE_COLOR.getBlue();
            this.myCntEndRed = CNT_ENABLE_COLOR.getRed();
            this.myCntEndGreen = CNT_ENABLE_COLOR.getGreen();
            this.myCntEndBlue = CNT_ENABLE_COLOR.getBlue();
        } else {
            this.myBndStartRed = BND_ENABLE_COLOR.getRed();
            this.myBndStartGreen = BND_ENABLE_COLOR.getGreen();
            this.myBndStartBlue = BND_ENABLE_COLOR.getBlue();
            this.myBndEndRed = BND_DISABLE_COLOR.getRed();
            this.myBndEndGreen = BND_DISABLE_COLOR.getGreen();
            this.myBndEndBlue = BND_DISABLE_COLOR.getBlue();
            this.myCntStartRed = CNT_ENABLE_COLOR.getRed();
            this.myCntStartGreen = CNT_ENABLE_COLOR.getGreen();
            this.myCntStartBlue = CNT_ENABLE_COLOR.getBlue();
            this.myCntEndRed = CNT_DISABLE_COLOR.getRed();
            this.myCntEndGreen = CNT_DISABLE_COLOR.getGreen();
            this.myCntEndBlue = CNT_DISABLE_COLOR.getBlue();
        }
    }

    private void updateColor() {
        int bndRed = (int)(this.myBndStartRed + (float)this.myCurrentFrame * (this.myBndEndRed - this.myBndStartRed) / 7.0f);
        int bndGreen = (int)(this.myBndStartGreen + (float)this.myCurrentFrame * (this.myBndEndGreen - this.myBndStartGreen) / 7.0f);
        int bndBlue = (int)(this.myBndStartBlue + (float)this.myCurrentFrame * (this.myBndEndBlue - this.myBndStartBlue) / 7.0f);
        this.myBndColor = new Color(Math.max(0, Math.min(bndRed, 255)), Math.max(0, Math.min(bndGreen, 255)), Math.max(0, Math.min(bndBlue, 255)));
        int cntRed = (int)(this.myCntStartRed + (float)this.myCurrentFrame * (this.myCntEndRed - this.myCntStartRed) / 7.0f);
        int cntGreen = (int)(this.myCntStartGreen + (float)this.myCurrentFrame * (this.myCntEndGreen - this.myCntStartGreen) / 7.0f);
        int cntBlue = (int)(this.myCntStartBlue + (float)this.myCurrentFrame * (this.myCntEndBlue - this.myCntStartBlue) / 7.0f);
        this.myCntColor = new Color(Math.max(0, Math.min(cntRed, 255)), Math.max(0, Math.min(cntGreen, 255)), Math.max(0, Math.min(cntBlue, 255)));
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        UIUtil.removeQuaquaVisualMarginsIn((Component)comp);
        super.addImpl(comp, constraints, index);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(new GradientPaint(0.0f, 1.0f, this.myBndColor, 0.0f, this.getHeight(), this.myCntColor));
        if (this.mySideButtons.isVisible()) {
            Rectangle sideRec = SwingUtilities.convertRectangle(this.mySideButtons.getParent(), this.mySideButtons.getBounds(), this);
            g2d.fillRect(0, 1, this.getWidth() - sideRec.width, this.getHeight());
            g2d.setColor(UIUtil.getBorderInactiveColor());
            Color buttonInnerColor = this.myActive ? ACTIVE_SIDE_BUTTON_BG : INACTIVE_SIDE_BUTTON_BG;
            g2d.setPaint(new GradientPaint(sideRec.x, sideRec.y, Color.white, sideRec.x, (int)sideRec.getMaxY() - 1, buttonInnerColor));
            g2d.fillRect(sideRec.x + 2, sideRec.y, sideRec.width - 2, sideRec.height);
            Icon separator = this.myActive ? this.mySeparatorActive : this.mySeparatorInactive;
            separator.paintIcon(this, g, sideRec.x, sideRec.y);
        } else {
            g2d.fillRect(0, 1, this.getWidth(), this.getHeight());
        }
    }

    public JComponent getSideButtonsComponent() {
        return this.mySideButtons;
    }

    public void addButtons(JComponent buttons, JComponent sideButtons) {
        this.mySideButtons = sideButtons;
        this.mySideButtons.setBorder(new EmptyBorder(0, 6, 0, 6));
        JPanel allButtons = new JPanel(new BorderLayout());
        allButtons.setOpaque(false);
        UIUtil.removeQuaquaVisualMarginsIn((Component)buttons);
        UIUtil.removeQuaquaVisualMarginsIn((Component)sideButtons);
        allButtons.add((Component)buttons, "Center");
        allButtons.add((Component)this.mySideButtons, "East");
        NonOpaquePanel wrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        wrapper.add(Box.createVerticalStrut(1), (Object)"North");
        wrapper.add((Component)allButtons, (Object)"Center");
        this.add((Component)wrapper, "East");
    }

    private final class MyAnimator
    implements Runnable {
        private MyAnimator() {
        }

        @Override
        public void run() {
            TitlePanel.this.updateColor();
            TitlePanel.this.paintImmediately(0, 0, TitlePanel.this.getWidth(), TitlePanel.this.getHeight());
            if (TitlePanel.this.myCurrentFrame <= 7) {
                TitlePanel.this.myCurrentFrame++;
                TitlePanel.this.myFrameTicker.addRequest((Runnable)this, 5);
            } else {
                TitlePanel.this.myFrameTicker.cancelAllRequests();
            }
        }
    }
}

