/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.KeyEventProcessor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private Application myApp;
    private FocusCommand myRequestFocusCmd;
    private final ArrayList<FocusCommand> myFocusRequests = new ArrayList();
    private final ArrayList<KeyEvent> myToDispatchOnDone = new ArrayList();
    private int myFlushingIdleRequestsEntryCount = 0;
    private WeakReference<FocusCommand> myLastForcedRequest = new WeakReference<Object>(null);
    private FocusCommand myFocusCommandOnAppActivation;
    private ActionCallback myCallbackOnActivation;
    private final IdeEventQueue myQueue;
    private final KeyProcessorConext myKeyProcessorContext = new KeyProcessorConext();
    private long myCmdTimestamp;
    private long myForcedCmdTimestamp;
    final EdtAlarm myFocusedComponentAlaram;
    private final EdtAlarm myForcedFocusRequestsAlarm;
    private final EdtAlarm myIdleAlarm;
    private final Set<Runnable> myIdleRequests = new HashSet();
    private final EdtRunnable myIdleRunnable = new EdtRunnable(){

        public void runEdt() {
            if (FocusManagerImpl.this.isFocusTransferReady() && !FocusManagerImpl.this.isIdleQueueEmpty()) {
                FocusManagerImpl.this.flushIdleRequests();
            } else {
                FocusManagerImpl.this.restartIdleAlarm();
            }
        }
    };
    private WindowManager myWindowManager;
    private Map<IdeFrame, Component> myLastFocused = new WeakHashMap();
    private Map<IdeFrame, Component> myLastFocusedAtDeactivation = new WeakHashMap();

    public FocusManagerImpl(WindowManager wm) {
        this.myApp = ApplicationManager.getApplication();
        this.myQueue = IdeEventQueue.getInstance();
        this.myWindowManager = wm;
        this.myFocusedComponentAlaram = new EdtAlarm(this);
        this.myForcedFocusRequestsAlarm = new EdtAlarm(this);
        this.myIdleAlarm = new EdtAlarm(this);
        AppListener myAppListener = new AppListener();
        this.myApp.addApplicationListener((ApplicationListener)myAppListener);
        IdeEventQueue.getInstance().addDispatcher(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent e) {
                if (e instanceof FocusEvent) {
                    FocusEvent fe = (FocusEvent)e;
                    Component c = fe.getComponent();
                    if (c instanceof Window || c == null) {
                        return false;
                    }
                    Component parent = UIUtil.findUltimateParent((Component)c);
                    if (parent instanceof IdeFrame) {
                        FocusManagerImpl.this.myLastFocused.put((IdeFrame)parent, c);
                    }
                }
                return false;
            }
        }, this);
    }

    public ActionCallback requestFocus(Component c, boolean forced) {
        return this.requestFocus((FocusCommand)new FocusCommand.ByComponent(c), forced);
    }

    public ActionCallback requestFocus(final FocusCommand command, final boolean forced) {
        final ActionCallback result = new ActionCallback();
        if (!forced) {
            if (!this.myFocusRequests.contains(command)) {
                this.myFocusRequests.add(command);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusManagerImpl.this.resetUnforcedCommand(command);
                    FocusManagerImpl.this._requestFocus(command, forced, result);
                }
            });
        } else {
            this._requestFocus(command, forced, result);
        }
        result.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                FocusManagerImpl.this.restartIdleAlarm();
            }
        });
        return result;
    }

    private void _requestFocus(final FocusCommand command, final boolean forced, final ActionCallback result) {
        if (this.checkForRejectOrByPass(command, forced, result)) {
            return;
        }
        this.setCommand(command);
        command.setCallback(result);
        if (forced) {
            this.myForcedFocusRequestsAlarm.cancelAllRequests();
            this.setLastEffectiveForcedRequest(command);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FocusManagerImpl.this.checkForRejectOrByPass(command, forced, result)) {
                    return;
                }
                if (FocusManagerImpl.this.myRequestFocusCmd == command) {
                    ActionCallback.TimedOut focusTimeout = new ActionCallback.TimedOut(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Focus command timed out, cmd=" + command, command.getAllocation(), true){

                        protected void onTimeout() {
                            FocusManagerImpl.this.forceFinishFocusSettledown(command, result);
                        }
                    };
                    FocusManagerImpl.this.myCmdTimestamp++;
                    if (forced) {
                        FocusManagerImpl.this.myForcedCmdTimestamp++;
                    }
                    command.run().doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    result.setDone();
                                }
                            });
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            result.setRejected();
                        }
                    }).doWhenProcessed(new Runnable(){

                        @Override
                        public void run() {
                            FocusManagerImpl.this.resetCommand(command, false);
                            if (forced) {
                                FocusManagerImpl.this.myForcedFocusRequestsAlarm.addRequest(new EdtRunnable(){

                                    public void runEdt() {
                                        FocusManagerImpl.this.setLastEffectiveForcedRequest(null);
                                    }
                                }, 250);
                            }
                        }
                    }).notify((ActionCallback)focusTimeout);
                } else {
                    FocusManagerImpl.this.rejectCommand(command, result);
                }
            }
        });
    }

    private boolean checkForRejectOrByPass(FocusCommand cmd, boolean forced, ActionCallback result) {
        boolean doNotExecuteBecauseAppIsInactive;
        if (cmd.isExpired()) {
            this.rejectCommand(cmd, result);
            return true;
        }
        FocusCommand lastRequest = this.getLastEffectiveForcedRequest();
        if (!forced && !this.isUnforcedRequestAllowed()) {
            if (cmd.equals((Object)lastRequest)) {
                this.resetCommand(cmd, false);
                result.setDone();
            } else {
                this.rejectCommand(cmd, result);
            }
            return true;
        }
        if (lastRequest != null && lastRequest.dominatesOver(cmd)) {
            this.rejectCommand(cmd, result);
            return true;
        }
        boolean bl = doNotExecuteBecauseAppIsInactive = !this.myApp.isActive() && !FocusManagerImpl.canExecuteOnInactiveApplication(cmd) && Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
        if (doNotExecuteBecauseAppIsInactive) {
            if (this.myCallbackOnActivation != null) {
                this.myCallbackOnActivation.setRejected();
                if (this.myFocusCommandOnAppActivation != null) {
                    this.resetCommand(this.myFocusCommandOnAppActivation, true);
                }
            }
            this.myFocusCommandOnAppActivation = cmd;
            this.myCallbackOnActivation = result;
            return true;
        }
        return false;
    }

    private void setCommand(FocusCommand command) {
        this.myRequestFocusCmd = command;
        if (!this.myFocusRequests.contains(command)) {
            this.myFocusRequests.add(command);
        }
    }

    private void resetCommand(FocusCommand cmd, boolean reject) {
        ActionCallback cb;
        KeyEventProcessor processor;
        if (cmd == this.myRequestFocusCmd) {
            this.myRequestFocusCmd = null;
        }
        if ((processor = cmd.getProcessor()) != null) {
            processor.finish((KeyEventProcessor.Context)this.myKeyProcessorContext);
        }
        this.myFocusRequests.remove(cmd);
        if (reject && (cb = cmd.getCallback()) != null && !cb.isProcessed()) {
            cmd.getCallback().setRejected();
        }
    }

    private void resetUnforcedCommand(FocusCommand cmd) {
        this.myFocusRequests.remove(cmd);
    }

    private static boolean canExecuteOnInactiveApplication(FocusCommand cmd) {
        return cmd.canExecuteOnInactiveApp();
    }

    private void setLastEffectiveForcedRequest(FocusCommand command) {
        this.myLastForcedRequest = new WeakReference<FocusCommand>(command);
    }

    @Nullable
    private FocusCommand getLastEffectiveForcedRequest() {
        if (this.myLastForcedRequest == null) {
            return null;
        }
        FocusCommand request = (FocusCommand)this.myLastForcedRequest.get();
        return request != null && !request.isExpired() ? request : null;
    }

    boolean isUnforcedRequestAllowed() {
        return this.getLastEffectiveForcedRequest() == null;
    }

    public static FocusManagerImpl getInstance() {
        return (FocusManagerImpl)((Object)ApplicationManager.getApplication().getComponent(IdeFocusManager.class));
    }

    public void dispose() {
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/FocusManagerImpl.doWhenFocusSettlesDown must not be null");
        }
        boolean needsRestart = this.isIdleQueueEmpty();
        this.myIdleRequests.add(runnable);
        if (needsRestart) {
            this.restartIdleAlarm();
        }
    }

    private void restartIdleAlarm() {
        this.myIdleAlarm.cancelAllRequests();
        this.myIdleAlarm.addRequest(this.myIdleRunnable, Registry.intValue((String)"actionSystem.focusIdleTimeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIdleRequests() {
        try {
            ++this.myFlushingIdleRequestsEntryCount;
            KeyEvent[] events = this.myToDispatchOnDone.toArray(new KeyEvent[this.myToDispatchOnDone.size()]);
            if (events.length > 0) {
                IdeEventQueue.getInstance().getKeyEventDispatcher().resetState();
            }
            boolean keyWasPressed = false;
            for (KeyEvent each : events) {
                Component owner;
                if (!this.isFocusTransferReady()) break;
                if (!keyWasPressed) {
                    if (each.getID() == 401) {
                        keyWasPressed = true;
                    } else {
                        this.myToDispatchOnDone.remove(each);
                        continue;
                    }
                }
                if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || SwingUtilities.getWindowAncestor(owner) == null) break;
                this.myToDispatchOnDone.remove(each);
                IdeEventQueue.getInstance().dispatchEvent(new KeyEvent(owner, each.getID(), each.getWhen(), each.getModifiersEx(), each.getKeyCode(), each.getKeyChar(), each.getKeyLocation()));
            }
            if (this.isPendingKeyEventsRedispatched()) {
                Runnable[] all = this.myIdleRequests.toArray(new Runnable[this.myIdleRequests.size()]);
                this.myIdleRequests.clear();
                for (Runnable each : all) {
                    each.run();
                }
            }
        }
        finally {
            --this.myFlushingIdleRequestsEntryCount;
            if (!this.isIdleQueueEmpty()) {
                this.restartIdleAlarm();
            }
        }
    }

    public boolean isFocusTransferReady() {
        this.invalidateFocusRequestsQueue();
        if (!this.myFocusRequests.isEmpty()) {
            return false;
        }
        if (this.myQueue == null) {
            return true;
        }
        return !this.myQueue.isSuspendMode() && !this.myQueue.hasFocusEventsPending();
    }

    private void invalidateFocusRequestsQueue() {
        if (this.myFocusRequests.size() == 0) {
            return;
        }
        FocusCommand[] requests = this.myFocusRequests.toArray(new FocusCommand[this.myFocusRequests.size()]);
        boolean wasChanged = false;
        for (FocusCommand each : requests) {
            if (!each.isExpired()) continue;
            this.resetCommand(each, true);
            wasChanged = true;
        }
        if (wasChanged && this.myFocusRequests.size() == 0) {
            this.restartIdleAlarm();
        }
    }

    private boolean isIdleQueueEmpty() {
        return this.isPendingKeyEventsRedispatched() && this.myIdleRequests.isEmpty();
    }

    private boolean isPendingKeyEventsRedispatched() {
        return this.myToDispatchOnDone.isEmpty();
    }

    public boolean dispatch(KeyEvent e) {
        if (!Registry.is((String)"actionSystem.fixLostTyping")) {
            return false;
        }
        if (this.myFlushingIdleRequestsEntryCount > 0) {
            return false;
        }
        if (!this.isFocusTransferReady() || !this.isPendingKeyEventsRedispatched()) {
            for (FocusCommand each : this.myFocusRequests) {
                Boolean result;
                KeyEventProcessor processor = each.getProcessor();
                if (processor == null || (result = processor.dispatch(e, (KeyEventProcessor.Context)this.myKeyProcessorContext)) == null) continue;
                return result;
            }
            this.myToDispatchOnDone.add(e);
            this.restartIdleAlarm();
            return true;
        }
        return false;
    }

    public void suspendKeyProcessingUntil(final ActionCallback done) {
        this.requestFocus(new FocusCommand(done){

            public ActionCallback run() {
                return done;
            }
        }.saveAllocation(), true);
    }

    public Expirable getTimestamp(final boolean trackOnlyForcedCommands) {
        return new Expirable(){
            long myOwnStamp;
            {
                this.myOwnStamp = trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp;
            }

            public boolean isExpired() {
                return this.myOwnStamp < (trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp);
            }
        };
    }

    private void forceFinishFocusSettledown(FocusCommand cmd, ActionCallback cmdCallback) {
        this.rejectCommand(cmd, cmdCallback);
    }

    private void rejectCommand(FocusCommand cmd, ActionCallback callback) {
        this.resetCommand(cmd, true);
        this.resetUnforcedCommand(cmd);
        callback.setRejected();
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/FocusManagerImpl.getFocusTargetFor must not be null");
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public Component getFocusedDescendantFor(Component comp) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = FocusTrackback.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    public boolean isFocusBeingTransferred() {
        return !this.isFocusTransferReady();
    }

    public ActionCallback requestDefaultFocus(boolean forced) {
        return new ActionCallback.Done();
    }

    private class AppListener
    extends ApplicationAdapter {
        private AppListener() {
        }

        public void applicationDeactivated(IdeFrame ideFrame) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component parent = UIUtil.findUltimateParent((Component)owner);
            if (parent == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }

        public void applicationActivated(final IdeFrame ideFrame) {
            FocusCommand cmd = FocusManagerImpl.this.myFocusCommandOnAppActivation;
            ActionCallback callback = FocusManagerImpl.this.myCallbackOnActivation;
            FocusManagerImpl.this.myFocusCommandOnAppActivation = null;
            FocusManagerImpl.this.myCallbackOnActivation = null;
            if (cmd != null) {
                FocusManagerImpl.this.requestFocus(cmd, true).notify(callback).doWhenRejected(new Runnable(){

                    @Override
                    public void run() {
                        AppListener.this.focusLastFocusedComponent(ideFrame);
                    }
                });
            } else {
                this.focusLastFocusedComponent(ideFrame);
            }
        }

        private void focusLastFocusedComponent(IdeFrame ideFrame) {
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (mgr.getFocusOwner() == null) {
                Component c = (Component)FocusManagerImpl.this.myLastFocusedAtDeactivation.get(ideFrame);
                if (c == null || !c.isShowing()) {
                    c = (Component)FocusManagerImpl.this.myLastFocused.get(ideFrame);
                }
                if (c != null && c.isShowing()) {
                    FocusManagerImpl.this.requestFocus(c, false);
                }
            }
            FocusManagerImpl.this.myLastFocusedAtDeactivation.remove(ideFrame);
        }
    }

    static class EdtAlarm {
        private final Alarm myAlarm;

        private EdtAlarm(Disposable parent) {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, parent);
        }

        public void cancelAllRequests() {
            this.myAlarm.cancelAllRequests();
        }

        public void addRequest(EdtRunnable runnable, int delay) {
            this.myAlarm.addRequest((Runnable)runnable, delay);
        }
    }

    private class KeyProcessorConext
    implements KeyEventProcessor.Context {
        private KeyProcessorConext() {
        }

        public List<KeyEvent> getQueue() {
            return FocusManagerImpl.this.myToDispatchOnDone;
        }

        public void dispatch(final List<KeyEvent> events) {
            FocusManagerImpl.this.doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    FocusManagerImpl.this.myToDispatchOnDone.addAll(events);
                    FocusManagerImpl.this.restartIdleAlarm();
                }
            });
        }
    }
}

