/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem
implements ApplicationComponent {
    private final Set<String> myNoCopyJarPaths = new ConcurrentHashSet();
    @NonNls
    private static final String IDEA_JARS_NOCOPY = "idea.jars.nocopy";
    private File myNoCopyJarDir;
    private final Map<String, JarHandler> myHandlers = new HashMap<String, JarHandler>();
    private static final Object LOCK = new JarFileSystemImplLock();

    public JarFileSystemImpl(MessageBus bus) {
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(List<? extends VFileEvent> events) {
                final ArrayList<VirtualFile> rootsToRefresh = new ArrayList<VirtualFile>();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
                    String path = vFileEvent.getPath();
                    ArrayList jarPaths = new ArrayList();
                    Object object = LOCK;
                    synchronized (object) {
                        jarPaths.addAll(JarFileSystemImpl.this.myHandlers.keySet());
                    }
                    for (String jarPath : jarPaths) {
                        VirtualFile jarRootToRefresh;
                        if (!FileUtil.startsWith((String)jarPath.substring(0, jarPath.length() - "!/".length()), (String)path, (boolean)SystemInfo.isFileSystemCaseSensitive) || (jarRootToRefresh = JarFileSystemImpl.this.markDirty(jarPath)) == null) continue;
                        rootsToRefresh.add(jarRootToRefresh);
                    }
                }
                if (!rootsToRefresh.isEmpty()) {
                    final Application app = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (app.isDisposed()) {
                                return;
                            }
                            for (VirtualFile root : rootsToRefresh) {
                                if (!root.isValid()) continue;
                                ((NewVirtualFile)root).markDirtyRecursively();
                            }
                            VirtualFile[] roots = VfsUtil.toVirtualFileArray((Collection)rootsToRefresh);
                            RefreshQueue.getInstance().refresh(false, true, null, roots);
                        }
                    };
                    if (app.isUnitTestMode()) {
                        runnable.run();
                    } else {
                        app.invokeLater(runnable, ModalityState.NON_MODAL);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFile markDirty(String path) {
        JarHandler handler;
        Object object = LOCK;
        synchronized (object) {
            handler = this.myHandlers.remove(path);
        }
        if (handler != null) {
            return handler.markDirty();
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("JarFileSystem" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.getComponentName must not return null");
        }
        return "JarFileSystem";
    }

    public void initComponent() {
        boolean isRunningFromDist = new File(PathManager.getLibPath() + File.separatorChar + "openapi.jar").exists();
        if (isRunningFromDist) {
            this.myNoCopyJarDir = new File(new File(PathManager.getLibPath()).getParent());
        }
    }

    public void disposeComponent() {
    }

    public void setNoCopyJarForPath(String pathInJar) {
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = pathInJar.substring(0, index);
        path = path.replace('/', File.separatorChar);
        if (!SystemInfo.isFileSystemCaseSensitive) {
            path = path.toLowerCase();
        }
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public VirtualFile getVirtualFileForJar(VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return LocalFileSystem.getInstance().findFileByPath(localPath);
    }

    public ZipFile getJarFile(VirtualFile entryVFile) throws IOException {
        JarHandler handler = this.getHandler(entryVFile);
        return handler.getZip();
    }

    @Nullable
    public File getMirroredFile(VirtualFile vFile) {
        VirtualFile jar = this.getJarRootForLocalFile(vFile);
        JarHandler handler = jar != null ? this.getHandler(jar) : null;
        return handler != null ? handler.getMirrorFile(new File(vFile.getPath())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarHandler getHandler(VirtualFile entryVFile) {
        JarHandler freshHanlder;
        JarHandler handler;
        String jarRootPath = this.extractRootPath(entryVFile.getPath());
        Object object = LOCK;
        synchronized (object) {
            handler = this.myHandlers.get(jarRootPath);
            if (handler == null) {
                freshHanlder = handler = new JarHandler(this, jarRootPath.substring(0, jarRootPath.length() - "!/".length()));
                this.myHandlers.put(jarRootPath, handler);
            } else {
                freshHanlder = null;
            }
        }
        if (freshHanlder != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    freshHanlder.refreshLocalFileForJar();
                }
            }, ModalityState.defaultModalityState());
        }
        return handler;
    }

    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.getProtocol must not return null");
        }
        return "jar";
    }

    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.extractPresentableUrl must not be null");
        }
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        path = super.extractPresentableUrl(path);
        return path;
    }

    public String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.extractRootPath must not be null");
        }
        int jarSeparatorIndex = path.indexOf("!/");
        assert (jarSeparatorIndex >= 0) : "Path passed to JarFileSystem must have jar separator '!/': " + path;
        return path.substring(0, jarSeparatorIndex + "!/".length());
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        return this.getHandler(fileOrDirectory).exists(fileOrDirectory);
    }

    @NotNull
    public InputStream getInputStream(VirtualFile file) throws IOException {
        InputStream inputStream = this.getHandler(file).getInputStream(file);
        if (inputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.getInputStream must not return null");
        }
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        byte[] byArray = this.getHandler(file).contentsToByteArray(file);
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.contentsToByteArray must not return null");
        }
        return byArray;
    }

    public long getLength(VirtualFile file) {
        return this.getHandler(file).getLength(file);
    }

    @NotNull
    public OutputStream getOutputStream(VirtualFile file, Object requestor, long modStamp, long timeStamp) throws IOException {
        OutputStream outputStream = this.getHandler(file).getOutputStream(file, requestor, modStamp, timeStamp);
        if (outputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.getOutputStream must not return null");
        }
        return outputStream;
    }

    public boolean isMakeCopyOfJar(File originalJar) {
        String property = System.getProperty(IDEA_JARS_NOCOPY);
        if (Boolean.TRUE.toString().equalsIgnoreCase(property)) {
            return false;
        }
        String path = originalJar.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive) {
            path = path.toLowerCase();
        }
        if (this.myNoCopyJarPaths.contains(path)) {
            return false;
        }
        try {
            if (this.myNoCopyJarDir != null && FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false)) {
                return false;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public long getTimeStamp(VirtualFile file) {
        return this.getHandler(file).getTimeStamp(file);
    }

    public boolean isDirectory(VirtualFile file) {
        return this.getHandler(file).isDirectory(file);
    }

    public boolean isWritable(VirtualFile file) {
        return false;
    }

    public String[] list(VirtualFile file) {
        return this.getHandler(file).list(file);
    }

    public void setTimeStamp(VirtualFile file, long modstamp) throws IOException {
        this.getHandler(file).setTimeStamp(file, modstamp);
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        this.getHandler(file).setWritable(file, writableFlag);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.createChildDirectory must not be null");
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vDir.getUrl()}));
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.createChildFile must not be null");
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vDir.getUrl()}));
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.deleteFile must not be null");
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.moveFile must not be null");
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.copyFile must not be null");
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl.renameFile must not be null");
        }
        throw new IOException(VfsBundle.message((String)"jar.modification.not.supported.error", (Object[])new Object[]{vFile.getUrl()}));
    }

    public int getRank() {
        return 2;
    }

    private static final class JarFileSystemImplLock {
        private JarFileSystemImplLock() {
        }
    }
}

