/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class UpdateInfo
implements JDOMExternalizable {
    private final Project myProject;
    private UpdatedFiles myUpdatedFiles;
    private String myDate;
    private ActionInfo myActionInfo;
    private static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    @NonNls
    private static final String DATE_ATTR = "date";
    @NonNls
    private static final String FILE_INFO_ELEMENTS = "UpdatedFiles";
    @NonNls
    private static final String ACTION_INFO_ATTRIBUTE_NAME = "ActionInfo";

    public UpdateInfo(Project project, UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myProject = project;
        this.myActionInfo = actionInfo;
        this.myUpdatedFiles = updatedFiles;
        this.myDate = DATE_FORMAT.format(new Date());
    }

    public UpdateInfo(Project project) {
        this.myProject = project;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myUpdatedFiles == null) {
            return;
        }
        element.setAttribute(DATE_ATTR, this.myDate);
        element.setAttribute(ACTION_INFO_ATTRIBUTE_NAME, this.myActionInfo.getActionName());
        Element filesElement = new Element(FILE_INFO_ELEMENTS);
        this.myUpdatedFiles.writeExternal(filesElement);
        element.addContent(filesElement);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myDate = element.getAttributeValue(DATE_ATTR);
        Element fileInfoElement = element.getChild(FILE_INFO_ELEMENTS);
        if (fileInfoElement == null) {
            return;
        }
        String actionInfoName = element.getAttributeValue(ACTION_INFO_ATTRIBUTE_NAME);
        this.myActionInfo = this.getActionInfoByName(actionInfoName);
        if (this.myActionInfo == null) {
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        updatedFiles.readExternal(fileInfoElement);
        this.myUpdatedFiles = updatedFiles;
    }

    private ActionInfo getActionInfoByName(String actionInfoName) {
        if (ActionInfo.UPDATE.getActionName().equals(actionInfoName)) {
            return ActionInfo.UPDATE;
        }
        if (ActionInfo.STATUS.getActionName().equals(actionInfoName)) {
            return ActionInfo.STATUS;
        }
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public Project getPoject() {
        return this.myProject;
    }

    public UpdatedFiles getFileInformation() {
        return this.myUpdatedFiles;
    }

    public String getCaption() {
        return VcsBundle.message((String)"toolwindow.title.update.project", (Object[])new Object[]{this.myDate});
    }

    public boolean isEmpty() {
        if (this.myUpdatedFiles != null) {
            return this.myUpdatedFiles.isEmpty();
        }
        return true;
    }

    public ActionInfo getActionInfo() {
        return this.myActionInfo;
    }
}

