/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private final ModuleManager myModuleManager;

    public ModuleDefaultVcsRootPolicy(Project project) {
        this.myProject = project;
        this.myBaseDir = project.getBaseDir();
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    @Override
    public void addDefaultVcsRoots(NewMappings mappingList, AbstractVcs vcs, List<VirtualFile> result) {
        Module[] modules;
        VirtualFile ideaDir;
        StorageScheme storageScheme;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.myBaseDir != null && vcs.getName().equals(mappingList.getVcsFor(this.myBaseDir)) && vcs.equals(vcsManager.getVcsFor(this.myBaseDir))) {
            result.add(this.myBaseDir);
        }
        if (StorageScheme.DIRECTORY_BASED.equals((Object)(storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme())) && (ideaDir = this.myBaseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory() && vcs.equals(vcsManager.getVcsFor(ideaDir))) {
            result.add(ideaDir);
        }
        for (Module module : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleDefaultVcsRootPolicy.this.myModuleManager.getModules();
            }
        })) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String mappingVcs;
                VcsDirectoryMapping mapping = mappingList.getMappingFor(file, module);
                String string = mappingVcs = mapping != null ? mapping.getVcs() : null;
                if (!vcs.getName().equals(mappingVcs)) continue;
                result.add(file);
            }
        }
    }

    @Override
    public boolean matchesDefaultMapping(VirtualFile file, Object matchContext) {
        if (matchContext != null) {
            return true;
        }
        if (this.myBaseDir != null && VfsUtil.isAncestor((VirtualFile)this.myBaseDir, (VirtualFile)file, (boolean)false)) {
            return !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isIgnored(file);
        }
        return false;
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file) {
        return ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject);
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(VirtualFile file) {
        VirtualFile ideaDir;
        if (this.myBaseDir != null && ExcludedFileIndex.getInstance((Project)this.myProject).isValidAncestor(this.myBaseDir, file)) {
            return this.myBaseDir;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(file);
        if (contentRoot != null) {
            return contentRoot;
        }
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && (ideaDir = this.myBaseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory() && VfsUtil.isAncestor((VirtualFile)ideaDir, (VirtualFile)file, (boolean)false)) {
            return ideaDir;
        }
        return null;
    }

    @Override
    public void markDefaultRootsDirty(DirtBuilder builder, VcsGuess vcsGuess) {
        VcsRoot[] vcsRoots;
        AbstractVcs vcs;
        boolean haveDefaultMapping;
        FilePathImpl fp;
        AbstractVcs vcs2;
        Module[] modules = this.myModuleManager.getModules();
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && (vcs2 = vcsGuess.getVcsForDirty(fp = new FilePathImpl(this.myBaseDir, ".idea", true))) != null) {
            builder.addDirtyDirRecursively(new FilePathUnderVcs(fp, vcs2));
        }
        for (Module module : modules) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                AbstractVcs vcs3 = vcsGuess.getVcsForDirty(file);
                if (vcs3 == null) continue;
                builder.addDirtyDirRecursively(new VcsRoot(vcs3, file));
            }
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        String defaultMapping = ((ProjectLevelVcsManagerEx)plVcsManager).haveDefaultMapping();
        boolean bl = haveDefaultMapping = defaultMapping != null && defaultMapping.length() > 0;
        if (haveDefaultMapping && (vcs = vcsGuess.getVcsForDirty(this.myBaseDir)) != null) {
            builder.addDirtyFile(new VcsRoot(vcs, this.myBaseDir));
        }
        for (VcsRoot root : vcsRoots = plVcsManager.getAllVcsRoots()) {
            builder.addDirtyDirRecursively(root);
        }
    }
}

