/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements ProjectComponent {
    private final ChangesViewContentManager myContentManager;
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    private final Tree myTree = new ShelfTree();
    private Content myContent = null;
    private final ShelvedChangeDeleteProvider myDeleteProvider = new ShelvedChangeDeleteProvider();
    private boolean myUpdatePending = false;
    private Runnable myPostUpdateRunnable = null;
    public static DataKey<ShelvedChangeList[]> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static DataKey<ShelvedChangeList[]> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");
    private static final Object ROOT_NODE_VALUE = new Object();
    private DefaultMutableTreeNode myRoot;
    private final Map<Pair<String, String>, String> myMoveRenameInfo;

    public static ShelvedChangesViewManager getInstance(Project project) {
        return (ShelvedChangesViewManager)project.getComponent(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(Project project, ChangesViewContentManager contentManager, ShelveChangesManager shelveChangesManager, MessageBus bus) {
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myShelveChangesManager = shelveChangesManager;
        bus.connect().subscribe(ShelveChangesManager.SHELF_TOPIC, (Object)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShelvedChangesViewManager.this.myUpdatePending = true;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShelvedChangesViewManager.this.updateChangesContent();
                    }
                }, ModalityState.NON_MODAL);
            }
        });
        this.myMoveRenameInfo = new HashMap<Pair<String, String>, String>();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ShelfTreeCellRenderer(project, this.myMoveRenameInfo)));
        new TreeLinkMouseListener(new ShelfTreeCellRenderer(project, this.myMoveRenameInfo)).install((JComponent)this.myTree);
        AnAction showDiffAction = ActionManager.getInstance().getAction("ShelvedChanges.Diff");
        showDiffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"ShelvedChangesPopupMenu", (String)"unknown");
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                DiffShelvedChangesAction.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)ShelvedChangesViewManager.this.myTree));
            }
        });
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object lastComponent;
                Object lc = o.getLastPathComponent();
                Object object = lastComponent = lc == null ? null : ((DefaultMutableTreeNode)lc).getUserObject();
                if (lastComponent instanceof ShelvedChangeList) {
                    return ((ShelvedChangeList)lastComponent).DESCRIPTION;
                }
                if (lastComponent instanceof ShelvedChange) {
                    ShelvedChange shelvedChange = (ShelvedChange)lastComponent;
                    return shelvedChange.getBeforeFileName() == null ? shelvedChange.getAfterFileName() : shelvedChange.getBeforeFileName();
                }
                if (lastComponent instanceof ShelvedBinaryFile) {
                    ShelvedBinaryFile sbf = (ShelvedBinaryFile)lastComponent;
                    String value = sbf.BEFORE_PATH == null ? sbf.AFTER_PATH : sbf.BEFORE_PATH;
                    int idx = value.lastIndexOf("/");
                    idx = idx == -1 ? value.lastIndexOf("\\") : idx;
                    return idx > 0 ? value.substring(idx + 1) : value;
                }
                return null;
            }
        }, true);
    }

    public void projectOpened() {
        this.updateChangesContent();
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelvedChangesViewManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager.getComponentName must not return null");
        }
        return "ShelvedChangesViewManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void updateChangesContent() {
        this.myUpdatePending = false;
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        changeLists.addAll(this.myShelveChangesManager.getRecycledShelvedChangeLists());
        if (changeLists.size() == 0) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent);
                this.myContentManager.selectContent("Local");
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
                scrollPane.setBorder(null);
                this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)scrollPane, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setCloseable(false);
                this.myContentManager.addContent(this.myContent);
            }
            TreeState state = TreeState.createOn((JTree)this.myTree);
            this.myTree.setModel(this.buildChangesModel());
            state.applyTo((JTree)this.myTree);
            if (this.myPostUpdateRunnable != null) {
                this.myPostUpdateRunnable.run();
            }
        }
        this.myPostUpdateRunnable = null;
    }

    private TreeModel buildChangesModel() {
        this.myRoot = new DefaultMutableTreeNode(ROOT_NODE_VALUE);
        DefaultTreeModel model = new DefaultTreeModel(this.myRoot);
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        if (this.myShelveChangesManager.isShowRecycled()) {
            changeLists.addAll(this.myShelveChangesManager.getRecycledShelvedChangeLists());
        }
        this.myMoveRenameInfo.clear();
        for (ShelvedChangeList changeList : changeLists) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(changeList);
            model.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
            ArrayList<Object> shelvedFilesNodes = new ArrayList<Object>();
            List<ShelvedChange> changes = changeList.getChanges();
            for (ShelvedChange change : changes) {
                this.putMovedMessage(change.getBeforePath(), change.getAfterPath());
                shelvedFilesNodes.add(change);
            }
            List<ShelvedBinaryFile> binaryFiles = changeList.getBinaryFiles();
            for (ShelvedBinaryFile file : binaryFiles) {
                this.putMovedMessage(file.BEFORE_PATH, file.AFTER_PATH);
                shelvedFilesNodes.add(file);
            }
            Collections.sort(shelvedFilesNodes, ShelvedFilePatchComparator.getInstance());
            for (int i = 0; i < shelvedFilesNodes.size(); ++i) {
                Object filesNode = shelvedFilesNodes.get(i);
                DefaultMutableTreeNode pathNode = new DefaultMutableTreeNode(filesNode);
                model.insertNodeInto(pathNode, node, i);
            }
        }
        return model;
    }

    private void putMovedMessage(String beforeName, String afterName) {
        String movedMessage = RelativePathCalculator.getMovedString(beforeName, afterName);
        if (movedMessage != null) {
            this.myMoveRenameInfo.put((Pair<String, String>)new Pair((Object)beforeName, (Object)afterName), movedMessage);
        }
    }

    public void activateView(final ShelvedChangeList list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (list != null) {
                    TreeUtil.selectNode((JTree)ShelvedChangesViewManager.this.myTree, (TreeNode)TreeUtil.findNodeWithObject((DefaultMutableTreeNode)ShelvedChangesViewManager.this.myRoot, (Object)list));
                }
                ShelvedChangesViewManager.this.myContentManager.setSelectedContent(ShelvedChangesViewManager.this.myContent);
                ToolWindow window = ToolWindowManager.getInstance((Project)ShelvedChangesViewManager.this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                if (!window.isVisible()) {
                    window.activate(null);
                }
            }
        };
        if (this.myUpdatePending) {
            this.myPostUpdateRunnable = runnable;
        } else {
            runnable.run();
        }
    }

    private class ShelvedChangeDeleteProvider
    implements DeleteProvider {
        private final List<DeleteProvider> myProviders;

        private ShelvedChangeDeleteProvider() {
            this.myProviders = Arrays.asList(new MyChangesDeleteProvider(), new MyChangeListDeleteProvider());
        }

        @Nullable
        private DeleteProvider selectDelegate(DataContext dataContext) {
            for (DeleteProvider provider : this.myProviders) {
                if (!provider.canDeleteElement(dataContext)) continue;
                return provider;
            }
            return null;
        }

        public void deleteElement(DataContext dataContext) {
            DeleteProvider delegate = this.selectDelegate(dataContext);
            if (delegate != null) {
                delegate.deleteElement(dataContext);
            }
        }

        public boolean canDeleteElement(DataContext dataContext) {
            return this.selectDelegate(dataContext) != null;
        }
    }

    private class MyChangesDeleteProvider
    implements DeleteProvider {
        private MyChangesDeleteProvider() {
        }

        public void deleteElement(DataContext dataContext) {
            ShelvedChangeList[] shelved = (ShelvedChangeList[])SHELVED_CHANGELIST_KEY.getData(dataContext);
            if (shelved == null || shelved.length != 1) {
                return;
            }
            List changes = (List)SHELVED_CHANGE_KEY.getData(dataContext);
            List binaryFiles = (List)SHELVED_BINARY_FILE_KEY.getData(dataContext);
            ShelvedChangeList list = shelved[0];
            String message = VcsBundle.message((String)"shelve.changes.delete.files.from.list", (Object[])new Object[]{(changes == null ? 0 : changes.size()) + (binaryFiles == null ? 0 : binaryFiles.size())});
            int rc = Messages.showOkCancelDialog((Project)ShelvedChangesViewManager.this.myProject, (String)message, (String)VcsBundle.message((String)"shelve.changes.delete.files.from.list.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (rc != 0) {
                return;
            }
            ArrayList<ShelvedBinaryFile> oldBinaries = new ArrayList<ShelvedBinaryFile>(list.getBinaryFiles());
            ArrayList<ShelvedChange> oldChanges = new ArrayList<ShelvedChange>(list.getChanges());
            oldBinaries.removeAll(binaryFiles);
            oldChanges.removeAll(changes);
            ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (ShelvedChange change : oldChanges) {
                try {
                    patches.add((FilePatch)change.loadFilePatch());
                }
                catch (IOException e) {
                    exceptions.add(new VcsException((Throwable)e));
                }
                catch (PatchSyntaxException e) {
                    exceptions.add(new VcsException((Throwable)e));
                }
            }
            ShelvedChangesViewManager.this.myShelveChangesManager.saveRemainingPatches(list, patches, oldBinaries);
            if (!exceptions.isEmpty()) {
                String title = list.DESCRIPTION == null ? "" : list.DESCRIPTION;
                title = title.substring(0, Math.min(10, list.DESCRIPTION.length()));
                AbstractVcsHelper.getInstance((Project)ShelvedChangesViewManager.this.myProject).showErrors(exceptions, "Deleting files from '" + title + "'");
            }
        }

        public boolean canDeleteElement(DataContext dataContext) {
            ShelvedChangeList[] shelved = (ShelvedChangeList[])SHELVED_CHANGELIST_KEY.getData(dataContext);
            if (shelved == null || shelved.length != 1) {
                return false;
            }
            List changes = (List)SHELVED_CHANGE_KEY.getData(dataContext);
            if (changes != null && !changes.isEmpty()) {
                return true;
            }
            List binaryFiles = (List)SHELVED_BINARY_FILE_KEY.getData(dataContext);
            return binaryFiles != null && !binaryFiles.isEmpty();
        }
    }

    private class MyChangeListDeleteProvider
    implements DeleteProvider {
        private MyChangeListDeleteProvider() {
        }

        public void deleteElement(DataContext dataContext) {
            List<ShelvedChangeList> shelvedChangeLists = this.getLists(dataContext);
            if (shelvedChangeLists.isEmpty()) {
                return;
            }
            String message = shelvedChangeLists.size() == 1 ? VcsBundle.message((String)"shelve.changes.delete.confirm", (Object[])new Object[]{shelvedChangeLists.get((int)0).DESCRIPTION}) : VcsBundle.message((String)"shelve.changes.delete.multiple.confirm", (Object[])new Object[]{shelvedChangeLists.size()});
            int rc = Messages.showOkCancelDialog((Project)ShelvedChangesViewManager.this.myProject, (String)message, (String)VcsBundle.message((String)"shelvedChanges.delete.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (rc != 0) {
                return;
            }
            for (ShelvedChangeList changeList : shelvedChangeLists) {
                ShelveChangesManager.getInstance(ShelvedChangesViewManager.this.myProject).deleteChangeList(changeList);
            }
        }

        public boolean canDeleteElement(DataContext dataContext) {
            return !this.getLists(dataContext).isEmpty();
        }

        private List<ShelvedChangeList> getLists(DataContext dataContext) {
            List<Object> shelvedChangeLists;
            ShelvedChangeList[] shelved = (ShelvedChangeList[])SHELVED_CHANGELIST_KEY.getData(dataContext);
            ShelvedChangeList[] recycled = (ShelvedChangeList[])SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext);
            List<Object> list = shelvedChangeLists = shelved == null && recycled == null ? Collections.emptyList() : new ArrayList();
            if (shelved != null) {
                shelvedChangeLists.addAll(Arrays.asList(shelved));
            }
            if (recycled != null) {
                shelvedChangeLists.addAll(Arrays.asList(recycled));
            }
            return shelvedChangeLists;
        }
    }

    private static class ShelfTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final IssueLinkRenderer myIssueLinkRenderer;
        private final Map<Pair<String, String>, String> myMoveRenameInfo;

        public ShelfTreeCellRenderer(Project project, Map<Pair<String, String>, String> moveRenameInfo) {
            this.myMoveRenameInfo = moveRenameInfo;
            this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue instanceof ShelvedChangeList) {
                ShelvedChangeList changeListData = (ShelvedChangeList)nodeValue;
                if (changeListData.isRecycled()) {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                } else {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION);
                }
                int count = node.getChildCount();
                String numFilesText = " (" + count + (count == 1 ? " file) " : " files) ");
                this.append(numFilesText, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                String date = SimpleDateFormat.getDateTimeInstance(3, 3).format(changeListData.DATE);
                this.append(" (" + date + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.setIcon(StdFileTypes.PATCH.getIcon());
            } else if (nodeValue instanceof ShelvedChange) {
                ShelvedChange change = (ShelvedChange)nodeValue;
                String movedMessage = this.myMoveRenameInfo.get(new Pair((Object)change.getBeforePath(), (Object)change.getAfterPath()));
                this.renderFileName(change.getBeforePath(), change.getFileStatus(), movedMessage);
            } else if (nodeValue instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)nodeValue;
                String path = binaryFile.BEFORE_PATH;
                if (path == null) {
                    path = binaryFile.AFTER_PATH;
                }
                String movedMessage = this.myMoveRenameInfo.get(new Pair((Object)binaryFile.BEFORE_PATH, (Object)binaryFile.AFTER_PATH));
                this.renderFileName(path, binaryFile.getFileStatus(), movedMessage);
            }
        }

        private void renderFileName(String path, FileStatus fileStatus, String movedMessage) {
            String fileName;
            String directory;
            int pos = (path = path.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                directory = path.substring(0, pos).replace(File.separatorChar, File.separatorChar);
                fileName = path.substring(pos + 1);
            } else {
                directory = "<project root>";
                fileName = path;
            }
            this.append(fileName, new SimpleTextAttributes(0, fileStatus.getColor()));
            if (movedMessage != null) {
                this.append(movedMessage, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.append(" (" + directory + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }
    }

    private static final class ShelvedFilePatchComparator
    implements Comparator<Object> {
        private static final ShelvedFilePatchComparator ourInstance = new ShelvedFilePatchComparator();

        private ShelvedFilePatchComparator() {
        }

        public static ShelvedFilePatchComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String path1 = ShelvedFilePatchComparator.getPath(o1);
            String path2 = ShelvedFilePatchComparator.getPath(o2);
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            return path1.compareToIgnoreCase(path2);
        }

        private static String getPath(Object patch) {
            String path = null;
            if (patch instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)patch;
                path = binaryFile.BEFORE_PATH;
                path = path == null ? binaryFile.AFTER_PATH : path;
            } else if (patch instanceof ShelvedChange) {
                ShelvedChange shelvedChange = (ShelvedChange)patch;
                path = shelvedChange.getBeforePath().replace('/', File.separatorChar);
            }
            if (path == null) {
                return null;
            }
            int pos = path.lastIndexOf(File.separatorChar);
            return pos >= 0 ? path.substring(pos + 1) : path;
        }
    }

    private class ShelfTree
    extends Tree
    implements TypeSafeDataProvider {
        private ShelfTree() {
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == SHELVED_CHANGELIST_KEY) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(false);
                if (changeLists.size() > 0) {
                    sink.put(SHELVED_CHANGELIST_KEY, (Object)changeLists.toArray(new ShelvedChangeList[changeLists.size()]));
                }
            } else if (key == SHELVED_RECYCLED_CHANGELIST_KEY) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(true);
                if (changeLists.size() > 0) {
                    sink.put(SHELVED_RECYCLED_CHANGELIST_KEY, (Object)changeLists.toArray(new ShelvedChangeList[changeLists.size()]));
                }
            } else if (key == SHELVED_CHANGE_KEY) {
                sink.put(SHELVED_CHANGE_KEY, (Object)TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class));
            } else if (key == SHELVED_BINARY_FILE_KEY) {
                sink.put(SHELVED_BINARY_FILE_KEY, (Object)TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedBinaryFile.class));
            } else if (key == VcsDataKeys.CHANGES) {
                List<ShelvedChange> shelvedChanges = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class);
                if (shelvedChanges.size() > 0) {
                    Change[] changes = new Change[shelvedChanges.size()];
                    for (int i = 0; i < shelvedChanges.size(); ++i) {
                        changes[i] = ((ShelvedChange)shelvedChanges.get(i)).getChange(ShelvedChangesViewManager.this.myProject);
                    }
                    sink.put(VcsDataKeys.CHANGES, (Object)changes);
                } else {
                    List changeLists = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChangeList.class);
                    if (changeLists.size() > 0) {
                        ArrayList<Change> changes = new ArrayList<Change>();
                        for (ShelvedChangeList changeList : changeLists) {
                            shelvedChanges = changeList.getChanges();
                            for (ShelvedChange shelvedChange : shelvedChanges) {
                                changes.add(shelvedChange.getChange(ShelvedChangesViewManager.this.myProject));
                            }
                        }
                        sink.put(VcsDataKeys.CHANGES, (Object)changes.toArray(new Change[changes.size()]));
                    }
                }
            } else if (key == PlatformDataKeys.DELETE_ELEMENT_PROVIDER) {
                sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)ShelvedChangesViewManager.this.myDeleteProvider);
            }
        }

        private Set<ShelvedChangeList> getSelectedLists(boolean recycled) {
            TreePath[] selections = this.getSelectionPaths();
            HashSet<ShelvedChangeList> changeLists = new HashSet<ShelvedChangeList>();
            if (selections != null) {
                for (TreePath path : selections) {
                    DefaultMutableTreeNode node;
                    if (path.getPathCount() < 2 || !((node = (DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject() instanceof ShelvedChangeList)) continue;
                    ShelvedChangeList list = (ShelvedChangeList)node.getUserObject();
                    if ((recycled || list.isRecycled()) && (!recycled || !list.isRecycled())) continue;
                    changeLists.add(list);
                }
            }
            return changeLists;
        }
    }
}

