/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcesor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public class ShelfManagerConfigurationMerger
implements XmlConfigurationMerger {
    private final String myConfigPath;
    private final CompoundShelfFileProcesor myFileProcessor;

    public ShelfManagerConfigurationMerger() {
        this.myConfigPath = PathManager.getConfigPath() + "/shelf";
        this.myFileProcessor = new CompoundShelfFileProcesor("shelf");
    }

    public ShelfManagerConfigurationMerger(String configPath, StreamProvider[] streamProviders) {
        this.myConfigPath = configPath;
        this.myFileProcessor = new CompoundShelfFileProcesor(streamProviders, configPath);
    }

    public Element merge(Element serverElement, Element localElement) {
        LinkedHashMap<Date, ShelvedChangeList> result = new LinkedHashMap<Date, ShelvedChangeList>();
        Map<String, ShelvedChangeList> serverFileToChangeList = this.collectChanges(serverElement);
        Map<String, ShelvedChangeList> localFileToChangeList = this.collectChanges(localElement);
        List<String> serverFileNames = this.myFileProcessor.getServerFiles();
        List<String> localFileNames = this.myFileProcessor.getLocalFiles();
        HashSet<String> serverChangeListFiles = new HashSet<String>();
        for (String serverFileName : serverFileToChangeList.keySet()) {
            ShelvedChangeList localChangeList;
            ShelvedChangeList changeList = serverFileToChangeList.get(serverFileName);
            String newFileName = !localFileNames.contains(serverFileName) ? this.myFileProcessor.copyFileFromServer(serverFileName, localFileNames) : ((localChangeList = localFileToChangeList.get(serverFileName)) != null && localChangeList.DATE.equals(changeList.DATE) ? this.myFileProcessor.copyFileFromServer(serverFileName, localFileNames) : this.myFileProcessor.renameFileOnServer(serverFileName, serverFileNames, localFileNames));
            changeList.PATH = new File(this.myFileProcessor.getBaseIODir(), newFileName).getAbsolutePath();
            serverChangeListFiles.add(newFileName);
            result.put(changeList.DATE, changeList);
        }
        for (ShelvedChangeList changeList : localFileToChangeList.values()) {
            result.put(changeList.DATE, changeList);
            serverChangeListFiles.remove(new File(changeList.PATH).getName());
        }
        Collection<ShelvedChangeList> resultChanges = result.values();
        for (ShelvedChangeList resultChange : resultChanges) {
            String patchFileName = new File(resultChange.PATH).getName();
            resultChange.PATH = this.myConfigPath + "/" + patchFileName;
            if (!serverChangeListFiles.contains(patchFileName)) continue;
            for (ShelvedBinaryFile binaryFile : resultChange.getBinaryFiles()) {
                String binFileName = new File(binaryFile.SHELVED_PATH).getName();
                String newBinFileName = localFileNames.contains(binFileName) ? this.myFileProcessor.renameFileOnServer(binFileName, serverFileNames, localFileNames) : this.myFileProcessor.copyFileFromServer(binFileName, localFileNames);
                binaryFile.SHELVED_PATH = new File(this.myFileProcessor.getBaseIODir(), newBinFileName).getAbsolutePath();
            }
        }
        Collection<ShelvedChangeList> changes = this.extractChanges(resultChanges, false);
        Collection<ShelvedChangeList> recycled = this.extractChanges(resultChanges, true);
        try {
            Element resultElement = new Element(localElement.getName());
            for (Object attrObject : localElement.getAttributes()) {
                Attribute attr = (Attribute)attrObject;
                resultElement.setAttribute(attr.getName(), attr.getValue());
            }
            ShelvedChangeList.writeChanges(changes, recycled, resultElement);
            return resultElement;
        }
        catch (WriteExternalException e) {
            return serverElement;
        }
    }

    private Collection<ShelvedChangeList> extractChanges(Collection<ShelvedChangeList> changes, boolean recycled) {
        ArrayList<ShelvedChangeList> result = new ArrayList<ShelvedChangeList>();
        for (ShelvedChangeList change : changes) {
            if (change.isRecycled() != recycled) continue;
            result.add(change);
        }
        return result;
    }

    private Map<String, ShelvedChangeList> collectChanges(Element original) {
        HashMap<String, ShelvedChangeList> result = new HashMap<String, ShelvedChangeList>();
        try {
            for (ShelvedChangeList shelvedChangeList : ShelvedChangeList.readChanges(original, true, false)) {
                result.put(new File(shelvedChangeList.PATH).getName(), shelvedChangeList);
            }
            for (ShelvedChangeList shelvedChangeList : ShelvedChangeList.readChanges(original, false, false)) {
                result.put(new File(shelvedChangeList.PATH).getName(), shelvedChangeList);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return result;
    }

    public String getComponentName() {
        return "ShelveChangesManager";
    }
}

