/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.MergedDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.patch.PatchMergeRequestFactory;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DiffShelvedChangesAction.showShelvedChangesDiff(e.getDataContext());
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY.getData(dc);
        if (changeLists == null) {
            changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY.getData(dc);
        }
        List shelvedChanges = (List)ShelvedChangesViewManager.SHELVED_CHANGE_KEY.getData(dc);
        if (changeLists == null) {
            return;
        }
        List<ShelvedChange> changesFromFirstList = changeLists[0].getChanges();
        Collections.sort(changesFromFirstList, new MyComparator(project));
        int toSelectIdx = 0;
        ArrayList<DiffRequestPresentable> diffRequestPresentables = new ArrayList<DiffRequestPresentable>();
        final ApplyPatchContext context = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        final PatchesPreloader preloader = new PatchesPreloader();
        LinkedList<String> missing = new LinkedList<String>();
        for (final ShelvedChange shelvedChange : changesFromFirstList) {
            final Change change = shelvedChange.getChange(project);
            String beforePath = shelvedChange.getBeforePath();
            try {
                final VirtualFile f = ApplyTextFilePatch.findPatchTarget(context, beforePath, shelvedChange.getAfterPath(), FileStatus.ADDED.equals(shelvedChange.getFileStatus()));
                if (f == null || !f.exists()) {
                    if (beforePath == null) continue;
                    missing.add(beforePath);
                    continue;
                }
                diffRequestPresentables.add(new DiffRequestPresentableProxy(){

                    @Override
                    protected DiffRequestPresentable init() {
                        if (DiffShelvedChangesAction.isConflictingChange(change)) {
                            TextFilePatch patch = preloader.getPatch(shelvedChange);
                            if (patch == null) {
                                return null;
                            }
                            FilePath pathBeforeRename = context.getPathBeforeRename(f);
                            ApplyPatchForBaseRevisionTexts threeTexts = ApplyPatchForBaseRevisionTexts.create(project, f, pathBeforeRename, patch);
                            if (threeTexts == null || threeTexts.getStatus() == null || ApplyPatchStatus.FAILURE.equals((Object)threeTexts.getStatus())) {
                                return null;
                            }
                            return new MergedDiffRequestPresentable(project, threeTexts, f, "Shelved Version");
                        }
                        return new ChangeDiffRequestPresentable(project, change);
                    }
                });
            }
            catch (IOException e) {
                continue;
            }
            if (shelvedChanges == null || !shelvedChanges.contains(shelvedChange)) continue;
            toSelectIdx = diffRequestPresentables.size() - 1;
        }
        if (!missing.isEmpty()) {
            ChangesViewBalloonProblemNotifier.showMe(project, "Show Diff: Cannot find base for: " + StringUtil.join(missing, (String)",\n"), MessageType.WARNING);
        }
        ShowDiffAction.showDiffImpl(project, diffRequestPresentables, toSelectIdx, ShowDiffAction.DiffExtendUIFactory.NONE, false);
    }

    private static boolean isConflictingChange(Change change) {
        block3: {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) {
                return false;
            }
            try {
                afterRevision.getContent();
            }
            catch (VcsException e) {
                if (!(e.getCause() instanceof ApplyPatchException)) break block3;
                return true;
            }
        }
        return false;
    }

    public void update(AnActionEvent e) {
        ActionManager.getInstance().getAction("ChangesView.Diff").update(e);
    }

    private static class ShelvedChangeDiffRequestFactory
    implements PatchMergeRequestFactory {
        public static final ShelvedChangeDiffRequestFactory INSTANCE = new ShelvedChangeDiffRequestFactory();

        private ShelvedChangeDiffRequestFactory() {
        }

        @Override
        public MergeRequest createMergeRequest(String leftText, String rightText, String originalContent, @NotNull VirtualFile file, Project project) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$ShelvedChangeDiffRequestFactory.createMergeRequest must not be null");
            }
            MergeRequest request = DiffRequestFactory.getInstance().create3WayDiffRequest(leftText, rightText, originalContent, project, null);
            request.setVersionTitles(new String[]{"Current Version", "Base Version", "Shelved Version"});
            request.setWindowTitle("Shelved Change Conflict for" + file.getPresentableUrl());
            return request;
        }
    }

    private static final class MyComparator
    implements Comparator<ShelvedChange> {
        private final Project myProject;

        public MyComparator(Project project) {
            this.myProject = project;
        }

        @Override
        public int compare(ShelvedChange o1, ShelvedChange o2) {
            return ChangesComparator.getInstance().compare(o1.getChange(this.myProject), o2.getChange(this.myProject));
        }
    }

    private static class PatchesPreloader {
        private final Map<String, List<TextFilePatch>> myFilePatchesMap = new HashMap<String, List<TextFilePatch>>();

        private PatchesPreloader() {
        }

        @Nullable
        public TextFilePatch getPatch(ShelvedChange shelvedChange) {
            List<TextFilePatch> textFilePatches = this.myFilePatchesMap.get(shelvedChange.getPatchPath());
            if (textFilePatches == null) {
                try {
                    textFilePatches = ShelveChangesManager.loadPatches(shelvedChange.getPatchPath());
                }
                catch (IOException e) {
                    return null;
                }
                catch (PatchSyntaxException e) {
                    return null;
                }
                this.myFilePatchesMap.put(shelvedChange.getPatchPath(), textFilePatches);
            }
            for (TextFilePatch textFilePatch : textFilePatches) {
                if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                return textFilePatch;
            }
            return null;
        }
    }
}

