/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import java.util.List;

public class IgnoreUnversionedAction
extends AnAction {
    public IgnoreUnversionedAction() {
        super("Ignore...");
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        List files = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        if (files == null) {
            return;
        }
        IgnoreUnversionedDialog.ignoreSelectedFiles(project, files);
    }

    public void update(AnActionEvent e) {
        List files = (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }
}

