/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeVfsListener
extends VirtualFileAdapter
implements ApplicationComponent {
    private final ProjectLocator myProjectLocator = ProjectLocator.getInstance();

    @NotNull
    public String getComponentName() {
        String string = VcsDirtyScopeVfsListener.class.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this, (Disposable)ApplicationManager.getApplication());
    }

    public void disposeComponent() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
    }

    @Nullable
    VcsDirtyScopeManager getManager(VirtualFileEvent event) {
        Project project = this.myProjectLocator.guessProjectForFile(event.getFile());
        if (project == null) {
            return null;
        }
        return VcsDirtyScopeManager.getInstance((Project)project);
    }

    public void contentsChanged(VirtualFileEvent event) {
        VcsDirtyScopeManager manager = this.getManager(event);
        if (manager != null) {
            manager.fileDirty(event.getFile());
        }
    }

    public void propertyChanged(VirtualFilePropertyEvent event) {
        VcsDirtyScopeManager manager = this.getManager((VirtualFileEvent)event);
        if (manager != null) {
            if (event.getPropertyName().equals("name")) {
                VirtualFile renamed = event.getFile();
                if (renamed.getParent() != null) {
                    renamed = renamed.getParent();
                }
                VcsDirtyScopeVfsListener.dirtyFileOrDir(manager, renamed);
            } else {
                manager.fileDirty(event.getFile());
            }
        }
    }

    private static void dirtyFileOrDir(@NotNull VcsDirtyScopeManager manager, VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener.dirtyFileOrDir must not be null");
        }
        if (file.isDirectory()) {
            manager.dirDirtyRecursively(file);
        } else {
            manager.fileDirty(file);
        }
    }

    public void fileCreated(VirtualFileEvent event) {
        VcsDirtyScopeManager manager = this.getManager(event);
        if (manager != null) {
            manager.fileDirty(event.getFile());
        }
    }

    public void beforePropertyChange(VirtualFilePropertyEvent event) {
        VcsDirtyScopeManager manager = this.getManager((VirtualFileEvent)event);
        if (manager != null) {
            manager.fileDirty(event.getFile());
        }
    }

    public void beforeFileDeletion(VirtualFileEvent event) {
        if (!event.getFile().isInLocalFileSystem()) {
            return;
        }
        VcsDirtyScopeManager manager = this.getManager(event);
        if (manager != null) {
            boolean directory = event.getFile().isDirectory();
            FilePathImpl path = new FilePathImpl(new File(event.getFile().getPath()), directory);
            if (directory) {
                manager.dirDirtyRecursively((FilePath)path);
            } else {
                manager.fileDirty((FilePath)path);
            }
        }
    }

    public void beforeFileMovement(VirtualFileMoveEvent event) {
        VcsDirtyScopeManager manager = this.getManager((VirtualFileEvent)event);
        if (manager != null) {
            manager.fileDirty((FilePath)new FilePathImpl(new File(event.getFile().getPath()), event.getFile().isDirectory()));
        }
    }

    public void fileMoved(VirtualFileMoveEvent event) {
        VcsDirtyScopeManager manager = this.getManager((VirtualFileEvent)event);
        if (manager != null) {
            VcsDirtyScopeVfsListener.dirtyFileOrDir(manager, event.getFile());
        }
    }
}

