/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;

public class LogicallyLockedHolder
implements FileHolder {
    private final Map<VirtualFile, LogicalLock> myMap;
    private final Project myProject;

    public LogicallyLockedHolder(Project project) {
        this.myProject = project;
        this.myMap = new HashMap<VirtualFile, LogicalLock>();
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    public void add(VirtualFile file, LogicalLock lock) {
        this.myMap.put(file, lock);
    }

    @Override
    public void cleanScope(VcsDirtyScope scope) {
        VirtualFileHolder.cleanScope(this.myProject, this.myMap.keySet(), scope);
    }

    @Override
    public FileHolder copy() {
        LogicallyLockedHolder result = new LogicallyLockedHolder(this.myProject);
        result.myMap.putAll(this.myMap);
        return result;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.LOGICALLY_LOCKED;
    }

    public Map<VirtualFile, LogicalLock> getMap() {
        return this.myMap;
    }
}

