/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Alarm;
import com.intellij.util.Icons;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangesViewManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    public static final int UNVERSIONED_MAX_SIZE = 50;
    private boolean SHOW_FLATTEN_MODE = true;
    private boolean SHOW_IGNORED_MODE = false;
    private final ChangesListView myView;
    private JLabel myProgressLabel;
    private final Alarm myRepaintAlarm;
    private boolean myDisposed = false;
    private final ChangeListListener myListener = new MyChangeListListener();
    private final ChangesViewContentManager myContentManager;
    @NonNls
    private static final String ATT_FLATTENED_VIEW = "flattened_view";
    @NonNls
    private static final String ATT_SHOW_IGNORED = "show_ignored";

    public static ChangesViewManager getInstance(Project project) {
        return (ChangesViewManager)((Object)project.getComponent(ChangesViewManager.class));
    }

    public static ChangesViewManager getInstanceChecked(final Project project) {
        return (ChangesViewManager)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ChangesViewManager>(){

            public ChangesViewManager compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (ChangesViewManager)((Object)project.getComponent(ChangesViewManager.class));
            }
        }));
    }

    public ChangesViewManager(Project project, ChangesViewContentManager contentManager) {
        super(project);
        this.myContentManager = contentManager;
        this.myView = new ChangesListView(project);
        Disposer.register((Disposable)project, (Disposable)this.myView);
        this.myRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
    }

    public void projectOpened() {
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener(this.myListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                ChangeListManager.getInstance((Project)ChangesViewManager.this.myProject).removeChangeListListener(ChangesViewManager.this.myListener);
            }
        });
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(this.createChangeViewComponent(), "Local", false);
        content.setCloseable(false);
        this.myContentManager.addContent(content);
        this.scheduleRefresh();
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, (Object)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesViewManager.this.refreshView();
                    }
                }, ModalityState.NON_MODAL, ChangesViewManager.this.myProject.getDisposed());
            }
        });
    }

    public void projectClosed() {
        this.myDisposed = true;
        this.myRepaintAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangesViewManager.getComponentName must not return null");
        }
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewToolbar");
        ActionManager.getInstance().getAction("ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.Move").registerCustomShortcutSet(CommonShortcuts.getMove(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.Rename").registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)panel);
        CustomShortcutSet diffShortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(68, SystemInfo.isMac ? 256 : 128));
        ActionManager.getInstance().getAction("ChangesView.Diff").registerCustomShortcutSet((ShortcutSet)diffShortcut, (JComponent)panel);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)ChangesViewManager.createToolbarComponent(group), "West");
        DefaultActionGroup visualActionsGroup = new DefaultActionGroup();
        Expander expander = new Expander();
        visualActionsGroup.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)expander, (JComponent)panel));
        visualActionsGroup.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)expander, (JComponent)panel));
        ToggleShowFlattenAction showFlattenAction = new ToggleShowFlattenAction();
        showFlattenAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 256 : 128)), (JComponent)panel);
        visualActionsGroup.add((AnAction)showFlattenAction);
        visualActionsGroup.add(ActionManager.getInstance().getAction("$Copy"));
        visualActionsGroup.add((AnAction)new ToggleShowIgnoredAction());
        visualActionsGroup.add((AnAction)new IgnoredSettingsAction());
        visualActionsGroup.add((AnAction)new ContextHelpAction("ideaInterface.changes"));
        toolbarPanel.add((Component)ChangesViewManager.createToolbarComponent(visualActionsGroup), "Center");
        DefaultActionGroup menuGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu");
        this.myView.setMenuActions((ActionGroup)menuGroup);
        this.myView.setShowFlatten(this.SHOW_FLATTEN_MODE);
        this.myProgressLabel = new JLabel();
        panel.setToolbar((JComponent)toolbarPanel);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JScrollPane((Component)((Object)this.myView)), "Center");
        content.add((Component)this.myProgressLabel, "South");
        panel.setContent((JComponent)content);
        this.myView.installDndSupport(ChangeListManagerImpl.getInstanceImpl(this.myProject));
        return panel;
    }

    private static JComponent createToolbarComponent(DefaultActionGroup group) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        return actionToolbar.getComponent();
    }

    void updateProgressText(final String text, final boolean isError) {
        if (this.myProgressLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangesViewManager.this.myProgressLabel.setText(text);
                    ChangesViewManager.this.myProgressLabel.setForeground(isError ? Color.red : UIUtil.getLabelForeground());
                }
            });
        }
    }

    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myRepaintAlarm.cancelAllRequests();
        this.myRepaintAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ChangesViewManager.this.refreshView();
            }
        }, 100, ModalityState.NON_MODAL);
    }

    void refreshView() {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        Pair<Integer, Integer> unv = changeListManager.getUnversionedFilesSize();
        boolean manyUnversioned = (Integer)unv.getFirst() > 50;
        Trinity unversionedPair = new Trinity(manyUnversioned ? Collections.emptyList() : changeListManager.getUnversionedFiles(), unv.getFirst(), unv.getSecond());
        this.myView.updateModel(changeListManager.getChangeListsCopy(), (Trinity<List<VirtualFile>, Integer, Integer>)unversionedPair, changeListManager.getDeletedFiles(), changeListManager.getModifiedWithoutEditing(), changeListManager.getSwitchedFilesMap(), changeListManager.getSwitchedRoots(), this.SHOW_IGNORED_MODE ? changeListManager.getIgnoredFiles() : null, changeListManager.getLockedFolders(), changeListManager.getLogicallyLockedFolders());
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.SHOW_FLATTEN_MODE = Boolean.valueOf(element.getAttributeValue(ATT_FLATTENED_VIEW));
        this.SHOW_IGNORED_MODE = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IGNORED));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATT_FLATTENED_VIEW, String.valueOf(this.SHOW_FLATTEN_MODE));
        element.setAttribute(ATT_SHOW_IGNORED, String.valueOf(this.SHOW_IGNORED_MODE));
    }

    public void selectFile(VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    public void refreshChangesViewNodeAsync(final VirtualFile file) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChangesViewManager.this.myProject.isDisposed()) {
                    return;
                }
                ChangesViewManager.this.refreshChangesViewNode(file);
            }
        });
    }

    private void refreshChangesViewNode(VirtualFile file) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Object userObject = changeListManager.isUnversioned(file) ? file : changeListManager.getChange(file);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    public class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/showHiddens.png"));
        }

        public boolean isSelected(AnActionEvent e) {
            return ChangesViewManager.this.SHOW_IGNORED_MODE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.SHOW_IGNORED_MODE = state;
            ChangesViewManager.this.refreshView();
        }
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), Icons.DIRECTORY_CLOSED_ICON);
        }

        public boolean isSelected(AnActionEvent e) {
            return !ChangesViewManager.this.SHOW_FLATTEN_MODE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.SHOW_FLATTEN_MODE = !state;
            ChangesViewManager.this.myView.setShowFlatten(ChangesViewManager.this.SHOW_FLATTEN_MODE);
            ChangesViewManager.this.refreshView();
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)ChangesViewManager.this.myView));
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRemoved(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            if (updateException == null) {
                ChangesViewManager.this.updateProgressText("", false);
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }
}

