/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private final Map<String, FileStatus> myFileToStatus;
    private final Map<String, VcsKey> myFileToVcs;

    ChangeListsIndexes() {
        this.myFileToStatus = new HashMap<String, FileStatus>();
        this.myFileToVcs = new HashMap<String, VcsKey>();
    }

    ChangeListsIndexes(ChangeListsIndexes idx) {
        this.myFileToStatus = new HashMap<String, FileStatus>(idx.myFileToStatus);
        this.myFileToVcs = new HashMap<String, VcsKey>(idx.myFileToVcs);
    }

    void add(FilePath file, FileStatus status, VcsKey key) {
        String fileKey = file.getIOFile().getAbsolutePath();
        this.myFileToStatus.put(fileKey, status);
        this.myFileToVcs.put(fileKey, key);
    }

    void remove(FilePath file) {
        String fileKey = file.getIOFile().getAbsolutePath();
        this.myFileToStatus.remove(fileKey);
        this.myFileToVcs.remove(fileKey);
    }

    public FileStatus getStatus(VirtualFile file) {
        return this.myFileToStatus.get(new File(file.getPath()).getAbsolutePath());
    }

    public void changeAdded(Change change, VcsKey key) {
        this.addChangeToIdx(change, key);
    }

    public void changeRemoved(Change change) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    public VcsKey getVcsFor(Change change) {
        VcsKey key = this.getVcsForRevision(change.getAfterRevision());
        if (key != null) {
            return key;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private VcsKey getVcsForRevision(ContentRevision revision) {
        if (revision != null) {
            String fileKey = revision.getFile().getIOFile().getAbsolutePath();
            return this.myFileToVcs.get(fileKey);
        }
        return null;
    }

    private void addChangeToIdx(Change change, VcsKey key) {
        ContentRevision beforeRevision;
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key);
        }
        if ((beforeRevision = change.getBeforeRevision()) != null) {
            if (afterRevision != null) {
                if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                    this.add(beforeRevision.getFile(), FileStatus.DELETED, key);
                }
            } else {
                this.add(beforeRevision.getFile(), change.getFileStatus(), key);
            }
        }
    }

    public List<Pair<String, VcsKey>> getAffectedFilesUnderVcs() {
        ArrayList<Pair<String, VcsKey>> result = new ArrayList<Pair<String, VcsKey>>();
        for (Map.Entry<String, VcsKey> entry : this.myFileToVcs.entrySet()) {
            result.add((Pair<String, VcsKey>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return result;
    }

    public List<File> getAffectedPaths() {
        ArrayList<File> result = new ArrayList<File>(this.myFileToStatus.size());
        for (String path : this.myFileToStatus.keySet()) {
            result.add(new File(path));
        }
        return result;
    }
}

