/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.vcs.annotate.AnnotationListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.util.List;

public class VFSForAnnotationListener
extends VirtualFileAdapter {
    private final VirtualFile myFile;
    private final List<AnnotationListener> myListeners;

    public VFSForAnnotationListener(VirtualFile file, List<AnnotationListener> listeners) {
        this.myListeners = listeners;
        this.myFile = file;
    }

    public void propertyChanged(VirtualFilePropertyEvent event) {
        if (this.myFile != event.getFile()) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if (event.getPropertyName().equals("writable") && ((Boolean)event.getOldValue()).booleanValue()) {
            this.fireAnnotationChanged();
        }
    }

    public void contentsChanged(VirtualFileEvent event) {
        if (this.myFile != event.getFile()) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if (!this.myFile.isWritable()) {
            this.fireAnnotationChanged();
        }
    }

    private void fireAnnotationChanged() {
        AnnotationListener[] listeners;
        for (AnnotationListener listener : listeners = this.myListeners.toArray(new AnnotationListener[this.myListeners.size()])) {
            listener.onAnnotationChanged();
        }
    }
}

