/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.ui.playback.commands.AssertFocused;
import com.intellij.openapi.ui.playback.commands.DelayCommand;
import com.intellij.openapi.ui.playback.commands.EmptyCommand;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.ui.playback.commands.KeyShortcutCommand;
import com.intellij.openapi.ui.playback.commands.StopCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.text.StringTokenizer;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PlaybackRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.PlaybackRunner");
    private Robot myRobot;
    private String myScript;
    private StatusCallback myCallback;
    private ArrayList<PlaybackCommand> myCommands = new ArrayList();
    private ActionCallback myActionCallback;
    private boolean myStopRequested;
    private boolean myUseDirectActionCall;

    public PlaybackRunner(String script, StatusCallback callback, boolean useDirectActionCall) {
        this.myScript = script;
        this.myCallback = callback;
        this.myUseDirectActionCall = useDirectActionCall;
    }

    public ActionCallback run() {
        this.myStopRequested = false;
        try {
            this.myActionCallback = new ActionCallback();
            this.myRobot = new Robot();
            this.parse();
            new Thread(){

                @Override
                public void run() {
                    if (PlaybackRunner.this.myUseDirectActionCall) {
                        PlaybackRunner.this.executeFrom(0);
                    } else {
                        IdeEventQueue.getInstance().doWhenReady(new Runnable(){

                            @Override
                            public void run() {
                                PlaybackRunner.this.executeFrom(0);
                            }
                        });
                    }
                }
            }.start();
        }
        catch (AWTException e) {
            LOG.error((Throwable)e);
        }
        return this.myActionCallback;
    }

    private void executeFrom(final int cmdIndex) {
        if (cmdIndex < this.myCommands.size()) {
            final PlaybackCommand cmd = this.myCommands.get(cmdIndex);
            if (this.myStopRequested) {
                this.myCallback.message("Stopped", cmdIndex);
                this.myActionCallback.setRejected();
                return;
            }
            cmd.execute(this.myCallback, this.myRobot, this.myUseDirectActionCall).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    if (cmd.canGoFurther()) {
                        PlaybackRunner.this.executeFrom(cmdIndex + 1);
                    } else {
                        PlaybackRunner.this.myActionCallback.setDone();
                    }
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    PlaybackRunner.this.myActionCallback.setRejected();
                }
            });
        } else {
            this.myCallback.message("Finished", this.myCommands.size() - 1);
            this.myActionCallback.setDone();
        }
    }

    private void parse() {
        StringTokenizer tokens = new StringTokenizer(this.myScript, "\n");
        int line = 0;
        while (tokens.hasMoreTokens()) {
            String eachLine = tokens.nextToken();
            PlaybackCommand cmd = this.createCommand(eachLine, line++);
            this.myCommands.add(cmd);
        }
    }

    private PlaybackCommand createCommand(String string, int line) {
        String actualString = string.toLowerCase();
        if (actualString.startsWith(AbstractCommand.CMD_PREFIX + AbstractCommand.CMD_PREFIX)) {
            return new EmptyCommand(line);
        }
        if (actualString.startsWith(KeyCodeTypeCommand.PREFIX)) {
            return new KeyCodeTypeCommand(string, line);
        }
        if (actualString.startsWith(DelayCommand.PREFIX)) {
            return new DelayCommand(string, line);
        }
        if (actualString.startsWith(KeyShortcutCommand.PREFIX)) {
            return new KeyShortcutCommand(string, line);
        }
        if (actualString.startsWith(ActionCommand.PREFIX)) {
            return new ActionCommand(string, line);
        }
        if (actualString.startsWith(StopCommand.PREFIX)) {
            return new StopCommand(string, line);
        }
        if (actualString.startsWith(AssertFocused.PREFIX)) {
            return new AssertFocused(string, line);
        }
        return new AlphaNumericTypeCommand(string, line);
    }

    private void setDone() {
        this.myActionCallback.setDone();
    }

    public void stop() {
        this.myStopRequested = true;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        frame.getContentPane().add((Component)content, "Center");
        final JTextArea textArea = new JTextArea();
        content.add((Component)textArea, "Center");
        frame.setBounds(300, 300, 300, 300);
        frame.show();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textArea.requestFocus();
                PlaybackRunner.start();
            }
        });
    }

    private static void start() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                switch (e.getID()) {
                    case 401: {
                        break;
                    }
                    case 402: {
                        break;
                    }
                }
                return false;
            }
        });
        new PlaybackRunner("%type", new StatusCallback(){

            @Override
            public void error(String text, int currentLine) {
                System.out.println("Error: " + currentLine + " " + text);
            }

            @Override
            public void message(String text, int currentLine) {
                System.out.println(currentLine + " " + text);
            }
        }, false).run();
    }

    public static interface StatusCallback {
        public void error(String var1, int var2);

        public void message(String var1, int var2);

        public static abstract class Edt
        implements StatusCallback {
            @Override
            public final void error(final String text, final int currentLine) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.errorEdt(text, currentLine);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Edt.this.errorEdt(text, currentLine);
                        }
                    });
                }
            }

            public abstract void errorEdt(String var1, int var2);

            @Override
            public final void message(final String text, final int currentLine) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.messageEdt(text, currentLine);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Edt.this.messageEdt(text, currentLine);
                        }
                    });
                }
            }

            public abstract void messageEdt(String var1, int var2);
        }
    }
}

