/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.KeyEventProcessor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.popup.StackingPopupDispatcherImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogWrapperPeerImpl
extends DialogWrapperPeer
implements FocusTrackbackProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    private DialogWrapper myWrapper;
    private MyDialog myDialog;
    private boolean myCanBeParent;
    private WindowManagerEx myWindowManager;
    private final List<Runnable> myDisposeActions;
    private Project myProject;
    private ActionCallback myWindowFocusedCallback;
    private ActionCallback myTypeAheadDone;

    protected DialogWrapperPeerImpl(DialogWrapper wrapper, Project project, boolean canBeParent) {
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        Window window = null;
        if (this.myWindowManager != null) {
            Window focusedWindow;
            if (project == null) {
                project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            this.myProject = project;
            window = this.myWindowManager.suggestParentWindow(project);
            if (window == null && (focusedWindow = this.myWindowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
        }
        Window owner = window != null ? window : JOptionPane.getRootFrame();
        this.createDialog(owner, canBeParent);
    }

    protected DialogWrapperPeerImpl(DialogWrapper wrapper, boolean canBeParent) {
        this(wrapper, (Project)null, canBeParent);
    }

    protected DialogWrapperPeerImpl(DialogWrapper wrapper, @NotNull Component parent, boolean canBeParent) {
        Window owner;
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/ui/impl/DialogWrapperPeerImpl.<init> must not be null");
        }
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        if (!parent.isShowing() && parent != JOptionPane.getRootFrame()) {
            throw new IllegalArgumentException("parent must be showing: " + parent);
        }
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        Window window = owner = parent instanceof Window ? (Window)parent : (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
        if (!(owner instanceof Dialog) && !(owner instanceof Frame)) {
            owner = JOptionPane.getRootFrame();
        }
        this.createDialog(owner, canBeParent);
    }

    public DialogWrapperPeerImpl(DialogWrapper wrapper, boolean canBeParent, boolean tryToolkitModal) {
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        if (UIUtil.hasJdk6Dialogs()) {
            this.createDialog(null, canBeParent);
            if (tryToolkitModal) {
                UIUtil.setToolkitModal((JDialog)this.myDialog);
            }
        } else {
            this.createDialog(JOptionPane.getRootFrame(), canBeParent);
        }
    }

    public void setUndecorated(boolean undecorated) {
        this.myDialog.setUndecorated(undecorated);
    }

    public void addMouseListener(MouseListener listener) {
        this.myDialog.addMouseListener(listener);
    }

    public void addMouseListener(MouseMotionListener listener) {
        this.myDialog.addMouseMotionListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.myDialog.addKeyListener(listener);
    }

    private void createDialog(Window owner, boolean canBeParent) {
        this.myDialog = owner instanceof Frame ? new MyDialog((Frame)owner, this.myWrapper, this.myProject, this.myWindowFocusedCallback, this.myTypeAheadDone) : new MyDialog((Dialog)owner, this.myWrapper, this.myProject, this.myWindowFocusedCallback, this.myTypeAheadDone);
        this.myDialog.setModal(true);
        this.myCanBeParent = canBeParent;
    }

    public void toFront() {
        this.myDialog.toFront();
    }

    public void toBack() {
        this.myDialog.toBack();
    }

    protected void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        for (Runnable runnable : this.myDisposeActions) {
            runnable.run();
        }
        this.myDisposeActions.clear();
        final JRootPane root = this.myDialog.getRootPane();
        Runnable disposer = new Runnable(){

            @Override
            public void run() {
                DialogWrapperPeerImpl.this.myDialog.dispose();
                DialogWrapperPeerImpl.this.myProject = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DialogWrapperPeerImpl.this.myDialog != null && root != null) {
                            DialogWrapperPeerImpl.this.myDialog.remove(root);
                        }
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            disposer.run();
        } else {
            SwingUtilities.invokeLater(disposer);
        }
    }

    private boolean isProgressDialog() {
        return this.myWrapper.isModalProgress();
    }

    @Nullable
    public Container getContentPane() {
        return this.getRootPane() != null ? this.myDialog.getContentPane() : null;
    }

    public void validate() {
        this.myDialog.validate();
    }

    public void repaint() {
        this.myDialog.repaint();
    }

    public Window getOwner() {
        return this.myDialog.getOwner();
    }

    public Window getWindow() {
        return this.myDialog;
    }

    public JRootPane getRootPane() {
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return this.myDialog.getTitle();
    }

    public void pack() {
        this.myDialog.pack();
    }

    public void setIconImages(List<Image> image) {
        UIUtil.updateDialogIcon((JDialog)this.myDialog, image);
    }

    public void setAppIcons() {
        this.setIconImages(AppUIUtil.getAppIconImages());
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        this.myDialog.setModal(modal);
    }

    public boolean isVisible() {
        return this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title) {
        this.myDialog.setTitle(title);
    }

    public void isResizable() {
        this.myDialog.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myDialog.setResizable(resizable);
    }

    public Point getLocation() {
        return this.myDialog.getLocation();
    }

    public void setLocation(Point p) {
        this.myDialog.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myDialog.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionCallback show() {
        boolean appStarted;
        ActionCallback result = new ActionCallback();
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        final AnCancelAction anCancelAction = new AnCancelAction();
        final JRootPane rootPane = this.getRootPane();
        anCancelAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(27, 0)), rootPane);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                anCancelAction.unregisterCustomShortcutSet(rootPane);
            }
        });
        if (!this.myCanBeParent && this.myWindowManager != null) {
            this.myWindowManager.doNotSuggestAsParent(this.myDialog);
        }
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted = commandProcessor != null;
        if (this.myDialog.isModal() && !this.isProgressDialog() && appStarted) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myDialog);
        }
        if (appStarted) {
            this.hidePopupsIfNeeded();
        }
        try {
            this.myDialog.show();
        }
        catch (Throwable throwable) {
            if (this.myDialog.isModal() && !this.isProgressDialog() && appStarted) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myDialog);
            }
            this.myDialog.getFocusManager().doWhenFocusSettlesDown(new Runnable(result){
                final /* synthetic */ ActionCallback val$result;
                {
                    this.val$result = actionCallback;
                }

                @Override
                public void run() {
                    this.val$result.setDone();
                }
            });
            throw throwable;
        }
        if (this.myDialog.isModal() && !this.isProgressDialog() && appStarted) {
            commandProcessor.leaveModal();
            LaterInvocator.leaveModal(this.myDialog);
        }
        this.myDialog.getFocusManager().doWhenFocusSettlesDown(new /* invalid duplicate definition of identical inner class */);
        return result;
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        StackingPopupDispatcherImpl.getInstance().hidePersistentPopups();
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                StackingPopupDispatcherImpl.getInstance().restorePersistentPopups();
            }
        });
    }

    @Override
    public FocusTrackback getFocusTrackback() {
        return this.myDialog.getFocusTrackback();
    }

    private static void setupSelectionOnPreferredComponent(JComponent component) {
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            String text = field.getText();
            if (text != null && field.getClientProperty(HAVE_INITIAL_SELECTION) == null) {
                field.setSelectionStart(0);
                field.setSelectionEnd(text.length());
            }
        } else if (component instanceof JComboBox) {
            JComboBox combobox = (JComboBox)component;
            combobox.getEditor().selectAll();
        }
    }

    public void setContentPane(JComponent content) {
        this.myDialog.setContentPane(content);
    }

    public void centerInParent() {
        this.myDialog.centerInParent();
    }

    private static class MyDialog
    extends JDialog
    implements DialogWrapperDialog,
    DataProvider,
    FocusTrackback.Provider,
    Queryable {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private Dimension myInitialSize;
        private String myDimensionServiceKey;
        private boolean myOpened = false;
        private FocusTrackback myFocusTrackback;
        private MyWindowListener myWindowListener;
        private MyComponentListener myComponentListener;
        private final WeakReference<Project> myProject;
        private ActionCallback myFocusedCallback;
        private ActionCallback myTypeAheadDone;

        public MyDialog(Dialog owner, DialogWrapper dialogWrapper, Project project, ActionCallback focused, ActionCallback typeAheadDone) {
            super(owner);
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper);
            this.myProject = project != null ? new WeakReference<Project>(project) : null;
            this.initDialog(focused, typeAheadDone);
        }

        public MyDialog(Frame owner, DialogWrapper dialogWrapper, Project project, ActionCallback focused, ActionCallback typeAheadDone) {
            super(owner);
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper);
            this.myProject = project != null ? new WeakReference<Project>(project) : null;
            this.initDialog(focused, typeAheadDone);
        }

        private void initDialog(ActionCallback focused, ActionCallback typeAheadDone) {
            this.myFocusedCallback = focused;
            this.myTypeAheadDone = typeAheadDone;
            long typeAhead = this.getDialogWrapper().getTypeAheadTimeoutMs();
            if (typeAhead <= 0L) {
                this.myTypeAheadDone.setDone();
            }
            this.setDefaultCloseOperation(0);
            this.myWindowListener = new MyWindowListener();
            this.addWindowListener(this.myWindowListener);
            this.myComponentListener = new MyComponentListener();
            this.addComponentListener(this.myComponentListener);
        }

        public void putInfo(Map<String, String> info) {
            info.put("dialog", this.getTitle());
        }

        @Override
        public FocusTrackback getFocusTrackback() {
            return this.myFocusTrackback;
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        public void centerInParent() {
            this.setLocationRelativeTo(this.getOwner());
        }

        public Object getData(String dataId) {
            DialogWrapper wrapper = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper instanceof DataProvider) {
                return ((DataProvider)wrapper).getData(dataId);
            }
            if (wrapper instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)wrapper);
                return adapter.getData(dataId);
            }
            return null;
        }

        @Override
        public void setSize(int width, int height) {
            Point location = this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            if (location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle rect = new Rectangle(x, y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            super.setBounds(rect.x, rect.y, rect.width, rect.height);
        }

        @Override
        public void setBounds(Rectangle r) {
            ScreenUtil.fitToScreen((Rectangle)r);
            super.setBounds(r);
        }

        @Override
        protected JRootPane createRootPane() {
            return new DialogRootPane();
        }

        @Override
        public void show() {
            this.myFocusTrackback = new FocusTrackback(this.myDialogWrapper, this, true);
            DialogWrapper dialogWrapper = this.getDialogWrapper();
            this.pack();
            this.setSize((int)((float)this.getWidth() * dialogWrapper.getHorizontalStretch()), (int)((float)this.getHeight() * dialogWrapper.getVerticalStretch()));
            this.myDimensionServiceKey = dialogWrapper.getDimensionKey();
            Point location = null;
            if (this.myDimensionServiceKey != null) {
                Project projectGuess = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
                location = DimensionService.getInstance().getLocation(this.myDimensionServiceKey, projectGuess);
                Dimension size = DimensionService.getInstance().getSize(this.myDimensionServiceKey, projectGuess);
                if (size != null) {
                    this.myInitialSize = (Dimension)size.clone();
                    this.setSize(this.myInitialSize);
                }
            }
            if (this.myInitialSize == null) {
                this.myInitialSize = this.getSize();
            }
            if (location == null) {
                location = dialogWrapper.getInitialLocation();
            }
            if (location != null) {
                this.setLocation(location);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
            Rectangle bounds = this.getBounds();
            ScreenUtil.fitToScreen((Rectangle)bounds);
            this.setBounds(bounds);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    final DialogWrapper wrapper = MyDialog.this.getDialogWrapper();
                    if (wrapper != null && MyDialog.this.myFocusTrackback != null) {
                        MyDialog.this.myFocusTrackback.registerFocusComponent(new FocusTrackback.ComponentQuery(){

                            @Override
                            public Component getComponent() {
                                return wrapper.getPreferredFocusedComponent();
                            }
                        });
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (!MyDialog.this.isModal()) {
                        final Ref focusManager = new Ref(null);
                        if (MyDialog.this.myProject != null && MyDialog.this.myProject.get() != null && !((Project)MyDialog.this.myProject.get()).isDisposed()) {
                            focusManager.set((Object)MyDialog.this.getFocusManager());
                            ((IdeFocusManager)focusManager.get()).doWhenFocusSettlesDown(new Runnable(){

                                @Override
                                public void run() {
                                    MyDialog.this.disposeFocusTrackbackIfNoChildWindowFocused((IdeFocusManager)focusManager.get());
                                }
                            });
                        } else {
                            MyDialog.this.disposeFocusTrackbackIfNoChildWindowFocused((IdeFocusManager)focusManager.get());
                        }
                    }
                }
            });
            if (Registry.is((String)"actionSystem.fixLostTyping")) {
                Project project;
                IdeEventQueue queue = IdeEventQueue.getInstance();
                if (queue != null) {
                    queue.getKeyEventDispatcher().resetState();
                }
                if (this.myProject != null && (project = (Project)this.myProject.get()) != null && !project.isDisposed() && project.isInitialized()) {
                    IdeFocusManager.findInstanceByComponent((Component)this).requestFocus((FocusCommand)new MyFocusCommand(dialogWrapper), true);
                }
            }
            super.show();
        }

        private IdeFocusManager getFocusManager() {
            if (this.myProject != null && this.myProject.get() != null && !((Project)this.myProject.get()).isDisposed()) {
                return IdeFocusManager.getInstance((Project)((Project)this.myProject.get()));
            }
            return IdeFocusManager.findInstance();
        }

        private void disposeFocusTrackbackIfNoChildWindowFocused(@Nullable IdeFocusManager focusManager) {
            if (this.myFocusTrackback == null) {
                return;
            }
            DialogWrapper wrapper = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper == null || !wrapper.isShowing()) {
                this.myFocusTrackback.dispose();
                return;
            }
            if (focusManager != null) {
                Component c = focusManager.getFocusedDescendantFor((Component)wrapper.getContentPane());
                if (c == null) {
                    this.myFocusTrackback.dispose();
                }
            } else {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner == null || !SwingUtilities.isDescendingFrom(owner, wrapper.getContentPane())) {
                    this.myFocusTrackback.dispose();
                }
            }
        }

        @Override
        @Deprecated
        public void hide() {
            super.hide();
            if (this.myFocusTrackback != null && !this.myFocusTrackback.isSheduledForRestore() && !this.myFocusTrackback.isWillBeSheduledForRestore()) {
                this.myFocusTrackback.setWillBeSheduledForRestore();
                IdeFocusManager mgr = this.getFocusManager();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        MyDialog.this.myFocusTrackback.restoreFocus();
                        MyDialog.this.myFocusTrackback = null;
                    }
                };
                mgr.doWhenFocusSettlesDown(r);
            }
        }

        @Override
        public void dispose() {
            Field field;
            BufferStrategy strategy;
            if (this.isShowing()) {
                this.hide();
            }
            if (this.myWindowListener != null) {
                this.myWindowListener.saveSize();
                this.removeWindowListener(this.myWindowListener);
                this.myWindowListener = null;
            }
            if (this.myComponentListener != null) {
                this.removeComponentListener(this.myComponentListener);
                this.myComponentListener = null;
            }
            if (this.myFocusTrackback != null && !this.myFocusTrackback.isSheduledForRestore() && !this.myFocusTrackback.isWillBeSheduledForRestore()) {
                this.myFocusTrackback.dispose();
                this.myFocusTrackback = null;
            }
            if ((strategy = this.getBufferStrategy()) != null) {
                try {
                    Method method = strategy.getClass().getMethod("dispose", new Class[0]);
                    method.invoke((Object)strategy, new Object[0]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            super.dispose();
            if (this.rootPane != null) {
                try {
                    field = this.rootPane.getClass().getDeclaredField("glassPane");
                    field.setAccessible(true);
                    field.set(this.rootPane, null);
                    field = this.rootPane.getClass().getDeclaredField("contentPane");
                    field.setAccessible(true);
                    field.set(this.rootPane, null);
                    this.rootPane = null;
                    field = Window.class.getDeclaredField("windowListener");
                    field.setAccessible(true);
                    field.set(this, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                field = Dialog.class.getDeclaredField("modalDialogs");
                field.setAccessible(true);
                List list = (List)field.get(null);
                list.remove(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Component getMostRecentFocusOwner() {
            JComponent toFocus;
            DialogWrapper wrapper;
            if (!this.myOpened && (wrapper = this.getDialogWrapper()) != null && (toFocus = wrapper.getPreferredFocusedComponent()) != null) {
                return toFocus;
            }
            return super.getMostRecentFocusOwner();
        }

        @Override
        public void paint(Graphics g) {
            UIUtil.applyRenderingHints((Graphics)g);
            super.paint(g);
        }

        private class MyFocusCommand
        extends FocusCommand
        implements KeyEventProcessor {
            private KeyEventProcessor.Context myContextOnFinish;
            private ArrayList<KeyEvent> myEvents = new ArrayList();
            private DialogWrapper myWrapper;

            private MyFocusCommand(DialogWrapper wrapper) {
                this.myWrapper = MyDialog.this.getDialogWrapper();
                Disposer.register((Disposable)wrapper.getDisposable(), (Disposable)new Disposable(){

                    public void dispose() {
                        if (!MyDialog.this.myTypeAheadDone.isProcessed()) {
                            MyDialog.this.myTypeAheadDone.setDone();
                        }
                        MyFocusCommand.this.flushEvents();
                    }
                });
            }

            public ActionCallback run() {
                return MyDialog.this.myTypeAheadDone;
            }

            public KeyEventProcessor getProcessor() {
                return this;
            }

            public Boolean dispatch(KeyEvent e, KeyEventProcessor.Context context) {
                if (this.myWrapper == null || MyDialog.this.myTypeAheadDone.isProcessed()) {
                    return null;
                }
                this.myEvents.addAll(context.getQueue());
                context.getQueue().clear();
                if (this.isToDipatchToDialogNow(e)) {
                    return false;
                }
                this.myEvents.add(e);
                return true;
            }

            private boolean isToDipatchToDialogNow(KeyEvent e) {
                return e.getKeyCode() == 10 || e.getKeyCode() == 27 || e.getKeyCode() == 9;
            }

            public void finish(KeyEventProcessor.Context context) {
                this.myContextOnFinish = context;
            }

            private void flushEvents() {
                if (this.myWrapper.isToDispatchTypeAhead() && this.myContextOnFinish != null) {
                    this.myContextOnFinish.dispatch(this.myEvents);
                }
            }
        }

        private class DialogRootPane
        extends JRootPane
        implements DataProvider {
            private final boolean myGlassPaneIsSet;

            private DialogRootPane() {
                this.setGlassPane(new IdeGlassPaneImpl(this));
                this.myGlassPaneIsSet = true;
            }

            @Override
            public void setGlassPane(Component glass) {
                if (this.myGlassPaneIsSet) {
                    LOG.warn("Setting of glass pane for DialogWrapper is prohibited", (Throwable)new Exception());
                    return;
                }
                super.setGlassPane(glass);
            }

            public Object getData(@NonNls String dataId) {
                DialogWrapper wrapper = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                return PlatformDataKeys.UI_DISPOSABLE.is(dataId) ? wrapper.getDisposable() : null;
            }
        }

        private class MyComponentListener
        extends ComponentAdapter {
            private MyComponentListener() {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JRootPane pane = MyDialog.this.getRootPane();
                if (pane == null) {
                    return;
                }
                Dimension minSize = pane.getMinimumSize();
                Dimension size = pane.getSize();
                final Dimension winSize = MyDialog.this.getSize();
                if (minSize.width > size.width) {
                    winSize.width += minSize.width - size.width;
                }
                if (minSize.height > size.height) {
                    winSize.height += minSize.height - size.height;
                }
                if (!winSize.equals(MyDialog.this.getSize())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (MyDialog.this.isShowing()) {
                                MyDialog.this.setSize(winSize);
                            }
                        }
                    });
                }
            }
        }

        private class MyWindowListener
        extends WindowAdapter {
            private MyWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DialogWrapper dialogWrapper = MyDialog.this.getDialogWrapper();
                if (dialogWrapper.shouldCloseOnCross()) {
                    dialogWrapper.doCancelAction((AWTEvent)e);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.saveSize();
            }

            public void saveSize() {
                if (MyDialog.this.myDimensionServiceKey != null && MyDialog.this.myInitialSize != null && MyDialog.this.myOpened) {
                    Project projectGuess = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)MyDialog.this));
                    Point location = MyDialog.this.getLocation();
                    DimensionService.getInstance().setLocation(MyDialog.this.myDimensionServiceKey, location, projectGuess);
                    Dimension size = MyDialog.this.getSize();
                    if (!MyDialog.this.myInitialSize.equals(size)) {
                        DimensionService.getInstance().setSize(MyDialog.this.myDimensionServiceKey, size, projectGuess);
                    }
                    MyDialog.this.myOpened = false;
                }
            }

            @Override
            public void windowOpened(final WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyDialog.this.myOpened = true;
                        final DialogWrapper activeWrapper = MyWindowListener.this.getActiveWrapper();
                        if (activeWrapper == null) {
                            MyDialog.this.myFocusedCallback.setRejected();
                            MyDialog.this.myTypeAheadDone.setRejected();
                            return;
                        }
                        JComponent toFocus = activeWrapper.getPreferredFocusedComponent();
                        if (toFocus == null) {
                            toFocus = MyDialog.this.getRootPane().getDefaultButton();
                        }
                        MyWindowListener.this.moveMousePointerOnButton(MyDialog.this.getRootPane().getDefaultButton());
                        DialogWrapperPeerImpl.setupSelectionOnPreferredComponent(toFocus);
                        if (toFocus != null) {
                            final JComponent toRequest = toFocus;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IdeFocusManager.findInstanceByComponent((Component)e.getWindow()).requestFocus((Component)toRequest, true);
                                    MyWindowListener.this.notifyFocused(activeWrapper);
                                }
                            });
                        } else {
                            MyWindowListener.this.notifyFocused(activeWrapper);
                        }
                    }
                });
            }

            private void notifyFocused(DialogWrapper wrapper) {
                MyDialog.this.myFocusedCallback.setDone();
                long timeout = wrapper.getTypeAheadTimeoutMs();
                if (timeout > 0L) {
                    SimpleTimer.getInstance().setUp((Runnable)new EdtRunnable(){

                        public void runEdt() {
                            MyDialog.this.myTypeAheadDone.setDone();
                        }
                    }, timeout);
                }
            }

            private DialogWrapper getActiveWrapper() {
                DialogWrapper activeWrapper = MyDialog.this.getDialogWrapper();
                if (activeWrapper == null || !activeWrapper.isShowing()) {
                    return null;
                }
                return activeWrapper;
            }

            private void moveMousePointerOnButton(JButton button) {
                Application application = ApplicationManager.getApplication();
                if (application != null && application.hasComponent(UISettings.class) && button != null && UISettings.getInstance().MOVE_MOUSE_ON_DEFAULT_BUTTON) {
                    Point p = button.getLocationOnScreen();
                    Rectangle r = button.getBounds();
                    try {
                        Robot robot = new Robot();
                        robot.mouseMove(p.x + r.width / 2, p.y + r.height / 2);
                    }
                    catch (AWTException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
    }

    private class AnCancelAction
    extends AnAction
    implements DumbAware {
        private AnCancelAction() {
        }

        public void update(AnActionEvent e) {
            JTable table;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            e.getPresentation().setEnabled(false);
            if (focusOwner instanceof JComponent && SpeedSearchBase.hasActiveSpeedSearch((JComponent)focusOwner)) {
                return;
            }
            if (StackingPopupDispatcher.getInstance().isPopupFocused()) {
                return;
            }
            if (focusOwner instanceof JTree) {
                JTree tree = (JTree)focusOwner;
                if (!tree.isEditing()) {
                    e.getPresentation().setEnabled(true);
                }
            } else if (focusOwner instanceof JTable && !(table = (JTable)focusOwner).isEditing()) {
                e.getPresentation().setEnabled(true);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            DialogWrapperPeerImpl.this.myWrapper.doCancelAction((AWTEvent)e.getInputEvent());
        }
    }
}

