/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureProblemsHolderImpl
implements ProjectStructureProblemsHolder {
    private List<ProjectStructureProblemDescription> myProblemDescriptions;

    @Override
    public void registerError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemsHolderImpl.registerError must not be null");
        }
        this.registerProblem(new ProjectStructureProblemDescription(message, ProjectStructureProblemDescription.Severity.ERROR));
    }

    @Override
    public void registerWarning(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemsHolderImpl.registerWarning must not be null");
        }
        this.registerProblem(new ProjectStructureProblemDescription(message, ProjectStructureProblemDescription.Severity.WARNING));
    }

    @Override
    public void registerProblem(@NotNull ProjectStructureProblemDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemsHolderImpl.registerProblem must not be null");
        }
        if (this.myProblemDescriptions == null) {
            this.myProblemDescriptions = new SmartList();
        }
        this.myProblemDescriptions.add(description);
    }

    @Nullable
    public ProjectStructureProblemDescription.Severity getSeverity() {
        if (this.myProblemDescriptions == null || this.myProblemDescriptions.isEmpty()) {
            return null;
        }
        for (ProjectStructureProblemDescription description : this.myProblemDescriptions) {
            if (description.getSeverity() != ProjectStructureProblemDescription.Severity.ERROR) continue;
            return ProjectStructureProblemDescription.Severity.ERROR;
        }
        return ProjectStructureProblemDescription.Severity.WARNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String composeTooltipMessage() {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append("<html><body>");
            if (this.myProblemDescriptions != null) {
                int problems = 0;
                for (ProjectStructureProblemDescription problemDescription : this.myProblemDescriptions) {
                    buf.append(problemDescription.getMessage()).append("<br>");
                    if (++problems < 10 || this.myProblemDescriptions.size() <= 12) continue;
                    buf.append(this.myProblemDescriptions.size() - problems).append(" more problems...<br>");
                    break;
                }
            }
            buf.append("</body></html>");
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Nullable
    public List<ProjectStructureProblemDescription> getProblemDescriptions() {
        return this.myProblemDescriptions;
    }
}

