/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.NamedConfigurable;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FacetConfigurable
extends NamedConfigurable<Facet> {
    private final Facet myFacet;
    private final ModulesConfigurator myModulesConfigurator;
    private String myFacetName;

    public FacetConfigurable(Facet facet, ModulesConfigurator modulesConfigurator, Runnable updateTree) {
        super(!facet.getType().isOnlyOneFacetAllowed(), updateTree);
        this.myFacet = facet;
        this.myModulesConfigurator = modulesConfigurator;
        this.myFacetName = this.myFacet.getName();
    }

    public void setDisplayName(String name) {
        if (!(name = name.trim()).equals(this.myFacetName)) {
            this.getFacetsConfigurator().getOrCreateModifiableModel(this.myFacet.getModule()).rename(this.myFacet, name);
            this.myFacetName = name;
        }
    }

    private ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myModulesConfigurator.getFacetsConfigurator();
    }

    public Facet getEditableObject() {
        return this.myFacet;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"facet.banner.text", (Object[])new Object[]{this.myFacetName});
    }

    public JComponent createOptionsPanel() {
        return this.getEditor().getComponent();
    }

    public FacetEditorImpl getEditor() {
        return this.getFacetsConfigurator().getOrCreateEditor(this.myFacet);
    }

    @Nls
    public String getDisplayName() {
        return this.myFacetName;
    }

    @Nullable
    public Icon getIcon() {
        return this.myFacet.getType().getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        FacetEditorImpl facetEditor = this.getFacetsConfigurator().getEditor(this.myFacet);
        return facetEditor != null ? facetEditor.getHelpTopic() : null;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }
}

