/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.IconUtilEx;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.PathUIUtils;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.AnnotationElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ClassesElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElementDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElementDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeBuilder;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeRenderer;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.SourcesElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.UrlComparator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTableEditor
implements Disposable,
LibraryEditorListener {
    static final UrlComparator ourUrlComparator = new UrlComparator();
    private JPanel myPanel;
    private JButton myAddLibraryButton;
    private JButton myRemoveButton;
    private JButton myRenameLibraryButton;
    private JButton myAttachClassesButton;
    private JButton myAttachJarDirectoriesButton;
    private JButton myAttachSourcesButton;
    private JButton myAttachJavadocsButton;
    private JButton myAttachUrlJavadocsButton;
    private JPanel myTreePanel;
    private JButton myAttachAnnotationsButton;
    private Tree myTree;
    private final Map<Library, LibraryEditor> myLibraryToEditorMap;
    private LibraryTableModifiableModelProvider myLibraryTableProvider;
    private final boolean myEditingModuleLibraries;
    private LibraryTableTreeBuilder myTreeBuilder;
    private LibraryTable.ModifiableModel myTableModifiableModel;
    private static final Icon INVALID_ITEM_ICON = IconLoader.getIcon((String)"/nodes/ppInvalid.png");
    private static final Icon JAR_DIRECTORY_ICON = IconLoader.getIcon((String)"/nodes/jarDirectory.png");
    private final Collection<Runnable> myListeners;
    private final List<LibraryEditorListener> myLibraryEditorListeners;
    @Nullable
    private final Project myProject;
    private final Map<DataKey, Object> myFileChooserUserData;

    private LibraryTableEditor(LibraryTableModifiableModelProvider provider, Project project) {
        this.$$$setupUI$$$();
        this.myLibraryToEditorMap = new HashMap<Library, LibraryEditor>();
        this.myListeners = new ArrayList<Runnable>();
        this.myLibraryEditorListeners = new ArrayList<LibraryEditorListener>();
        this.myFileChooserUserData = new HashMap<DataKey, Object>();
        this.myProject = project;
        this.myLibraryTableProvider = provider;
        this.myTableModifiableModel = this.myLibraryTableProvider.getModifiableModel();
        String tableLevel = provider.getTableLevel();
        this.myEditingModuleLibraries = "module".equals(tableLevel);
        if (!provider.isLibraryTableEditable()) {
            this.myAddLibraryButton.setVisible(false);
            this.myRenameLibraryButton.setVisible(false);
        }
    }

    public static LibraryTableEditor editLibraryTable(LibraryTableModifiableModelProvider provider, Project project) {
        LibraryTableEditor result = new LibraryTableEditor(provider, project);
        result.init(new LibraryTableTreeStructure(result));
        return result;
    }

    public static LibraryTableEditor editLibrary(LibraryTableModifiableModelProvider provider, Library library, Project project) {
        LibraryTableEditor tableEditor = new LibraryTableEditor(provider, project);
        tableEditor.init(new LibraryTreeStructure(tableEditor, library));
        Disposer.register((Disposable)project, (Disposable)tableEditor);
        return tableEditor;
    }

    public static LibraryTableEditor editLibrary(LibraryTableModifiableModelProvider provider, Library library) {
        LibraryTableEditor result = new LibraryTableEditor(provider, null);
        result.init(new LibraryTreeStructure(result, library));
        return result;
    }

    private static boolean libraryAlreadyExists(LibraryTable.ModifiableModel table, String libraryName) {
        Iterator it = table.getLibraryIterator();
        while (it.hasNext()) {
            if (!libraryName.equals(((Library)it.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel table) {
        String name = "Unnamed";
        String candidataName = "Unnamed";
        int idx = 1;
        while (LibraryTableEditor.libraryAlreadyExists(table, candidataName)) {
            candidataName = "Unnamed" + idx++;
        }
        return candidataName;
    }

    private void init(AbstractTreeStructure treeStructure) {
        this.myTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        new MyTreeSpeedSearch(this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new LibraryTreeRenderer()));
        MyTreeSelectionListener treeSelectionListener = new MyTreeSelectionListener();
        this.myTree.getSelectionModel().addTreeSelectionListener(treeSelectionListener);
        this.myTreeBuilder = new LibraryTableTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), treeStructure);
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTree), "Center");
        this.myAddLibraryButton.setText(this.myEditingModuleLibraries ? ProjectBundle.message((String)"library.add.jar.directory.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.create.library.action", (Object[])new Object[0]));
        this.myAddLibraryButton.addActionListener(new AddLibraryAction());
        this.myRemoveButton.addActionListener(new RemoveAction());
        if (this.myEditingModuleLibraries) {
            this.myRenameLibraryButton.setVisible(false);
        } else if (this.myRenameLibraryButton.isVisible()) {
            this.myRenameLibraryButton.addActionListener(new RenameLibraryAction());
        }
        this.myAttachClassesButton.addActionListener(new AttachClassesAction());
        this.myAttachJarDirectoriesButton.addActionListener(new AttachJarDirectoriesAction());
        this.myAttachSourcesButton.addActionListener(new AttachSourcesAction());
        this.myAttachJavadocsButton.addActionListener(new AttachJavadocAction());
        this.myAttachUrlJavadocsButton.addActionListener(new AttachUrlJavadocAction());
        this.myAttachAnnotationsButton.addActionListener(new AttachAnnotationsAction());
        treeSelectionListener.updateButtons();
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void selectLibrary(Library library, boolean expand) {
        LibraryElement element = new LibraryElement(library, this, false);
        this.myTreeBuilder.updateAndSelect(element);
    }

    public <T> void addFileChooserContext(DataKey<T> key, T value) {
        this.myFileChooserUserData.put(key, value);
    }

    public LibraryEditor getLibraryEditor(Library library) {
        if (this.myTableModifiableModel instanceof LibrariesModifiableModel) {
            return ((LibrariesModifiableModel)this.myTableModifiableModel).getLibraryEditor(library);
        }
        LibraryEditor libraryEditor = this.myLibraryToEditorMap.get(library);
        if (libraryEditor == null) {
            libraryEditor = new LibraryEditor(library, this);
            this.myLibraryToEditorMap.put(library, libraryEditor);
        }
        return libraryEditor;
    }

    private void removeLibrary(Library library) {
        LibraryEditor libraryEditor = this.myLibraryToEditorMap.remove(library);
        if (libraryEditor != null) {
            Disposer.dispose((Disposable)libraryEditor);
        }
        this.myTableModifiableModel.removeLibrary(library);
        if (this.myProject != null) {
            ModuleStructureConfigurable.getInstance(this.myProject).fireItemsChangeListener(library);
        }
    }

    public void commitChanges() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (LibraryEditor libraryEditor : LibraryTableEditor.this.myLibraryToEditorMap.values()) {
                    libraryEditor.commit();
                    Disposer.dispose((Disposable)libraryEditor);
                }
                LibraryTableEditor.this.myTableModifiableModel.commit();
            }
        });
        this.myTableModifiableModel = this.myLibraryTableProvider.getModifiableModel();
        this.myLibraryToEditorMap.clear();
    }

    public void cancelChanges() {
        for (LibraryEditor libraryEditor : new ArrayList<LibraryEditor>(this.myLibraryToEditorMap.values())) {
            Disposer.dispose((Disposable)libraryEditor);
        }
        this.myLibraryToEditorMap.clear();
    }

    public boolean hasChanges() {
        if (this.myTableModifiableModel.isChanged()) {
            return true;
        }
        for (Library library : this.myLibraryToEditorMap.keySet()) {
            LibraryEditor libraryEditor = this.myLibraryToEditorMap.get(library);
            if (!libraryEditor.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public void addLibraryEditorListener(@NotNull LibraryEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTableEditor.addLibraryEditorListener must not be null");
        }
        this.myLibraryEditorListeners.add(listener);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTableEditor.libraryRenamed must not be null");
        }
        for (LibraryEditorListener listener : this.myLibraryEditorListeners) {
            listener.libraryRenamed(library, oldName, newName);
        }
    }

    public Library[] getLibraries() {
        return this.myTableModifiableModel.getLibraries();
    }

    @Nullable
    private Object getSelectedElement() {
        TreePath selectionPath = this.myTreeBuilder.getTree().getSelectionPath();
        return LibraryTableEditor.getPathElement(selectionPath);
    }

    private Object[] getSelectedElements() {
        if (this.myTreeBuilder == null || this.myTreeBuilder.isDisposed()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        TreePath[] selectionPaths = this.myTreeBuilder.getTree().getSelectionPaths();
        if (selectionPaths == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        for (TreePath selectionPath : selectionPaths) {
            Object pathElement = LibraryTableEditor.getPathElement(selectionPath);
            if (pathElement == null) continue;
            elements.add(pathElement);
        }
        return ArrayUtil.toObjectArray(elements);
    }

    @Nullable
    private static Object getPathElement(TreePath selectionPath) {
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        if (lastPathComponent == null) {
            return null;
        }
        Object userObject = lastPathComponent.getUserObject();
        if (!(userObject instanceof NodeDescriptor)) {
            return null;
        }
        Object element = ((NodeDescriptor)userObject).getElement();
        if (!(element instanceof LibraryTableTreeContentElement)) {
            return null;
        }
        return element;
    }

    @Nullable
    private Library getSelectedLibrary() {
        if (this.myTreeBuilder != null && this.myTreeBuilder.getTreeStructure() instanceof LibraryTreeStructure) {
            return ((LibraryTreeStructure)this.myTreeBuilder.getTreeStructure()).getLibrary();
        }
        return LibraryTableEditor.convertElementToLibrary(this.getSelectedElement());
    }

    private Library[] getSelectedLibraries() {
        Object[] selectedElements;
        ArrayList<Library> libs = new ArrayList<Library>();
        for (Object selectedElement : selectedElements = this.getSelectedElements()) {
            Library library = LibraryTableEditor.convertElementToLibrary(selectedElement);
            if (library == null) continue;
            libs.add(library);
        }
        return libs.toArray(new Library[libs.size()]);
    }

    @Nullable
    private static Library convertElementToLibrary(Object selectedElement) {
        LibraryElement libraryElement = null;
        if (selectedElement instanceof LibraryElement) {
            libraryElement = (LibraryElement)selectedElement;
        } else if (selectedElement instanceof ItemElement) {
            selectedElement = ((ItemElement)selectedElement).getParent();
        }
        if (selectedElement instanceof ClassesElement) {
            libraryElement = ((ClassesElement)selectedElement).getParent();
        } else if (selectedElement instanceof SourcesElement) {
            libraryElement = ((SourcesElement)selectedElement).getParent();
        } else if (selectedElement instanceof JavadocElement) {
            libraryElement = ((JavadocElement)selectedElement).getParent();
        }
        return libraryElement != null ? libraryElement.getLibrary() : null;
    }

    public void renameLibrary(Library library, String newName) {
        if (library == null) {
            return;
        }
        LibraryEditor libraryEditor = this.getLibraryEditor(library);
        libraryEditor.setName(newName);
        this.librariesChanged(false);
    }

    @Nullable
    public Library[] openDialog(Component parent, final Collection<Library> selection, final boolean expandSelectedItems) {
        MyDialogWrapper dialogWrapper = new MyDialogWrapper(parent);
        if (selection != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Library library : selection) {
                        LibraryTableEditor.this.selectLibrary(library, expandSelectedItems);
                    }
                }
            }, ModalityState.stateForComponent((Component)dialogWrapper.getContentPane()));
        }
        dialogWrapper.show();
        return dialogWrapper.isOK() ? dialogWrapper.getSelectedLibraries() : null;
    }

    public ActionListener createAddLibraryAction(boolean select) {
        return new AddLibraryAction(select);
    }

    public void dispose() {
        this.myTreeBuilder = null;
    }

    private VirtualFile[] attachFiles(final Library library, VirtualFile[] files, final OrderRootType rootType, final boolean isJarDirectories) {
        final VirtualFile[] filesToAttach = this.filterAlreadyAdded(library, files, rootType);
        if (filesToAttach.length > 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    LibraryEditor libraryEditor = LibraryTableEditor.this.getLibraryEditor(library);
                    for (VirtualFile file : filesToAttach) {
                        if (isJarDirectories) {
                            libraryEditor.addJarDirectory(file, false);
                            continue;
                        }
                        libraryEditor.addRoot(file, rootType);
                    }
                    if (LibraryTableEditor.this.myEditingModuleLibraries) {
                        LibraryTableEditor.this.commitChanges();
                    }
                }
            });
            this.myTreeBuilder.updateFromRoot();
        }
        return filesToAttach;
    }

    private VirtualFile[] filterAlreadyAdded(Library lib, VirtualFile[] files, OrderRootType rootType) {
        if (files == null || files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        HashSet<VirtualFile> chosenFilesSet = new HashSet<VirtualFile>(Arrays.asList(files));
        HashSet<VirtualFile> alreadyAdded = new HashSet<VirtualFile>();
        if (lib == null) {
            Library[] libraries;
            for (Library library : libraries = this.myTableModifiableModel.getLibraries()) {
                VirtualFile[] libraryFiles = this.getLibraryEditor(library).getFiles(rootType);
                alreadyAdded.addAll(Arrays.asList(libraryFiles));
            }
        } else {
            VirtualFile[] libraryFiles = this.getLibraryEditor(lib).getFiles(rootType);
            alreadyAdded.addAll(Arrays.asList(libraryFiles));
        }
        chosenFilesSet.removeAll(alreadyAdded);
        return VfsUtil.toVirtualFileArray(chosenFilesSet);
    }

    protected void librariesChanged(boolean putFocusIntoTree) {
        this.myTreeBuilder.updateFromRoot();
        if (putFocusIntoTree) {
            this.myTree.requestFocus();
        }
        this.fireLibrariesChanged();
    }

    private void fireLibrariesChanged() {
        Runnable[] runnables;
        for (Runnable listener : runnables = this.myListeners.toArray(new Runnable[this.myListeners.size()])) {
            listener.run();
        }
    }

    public void addListener(Runnable listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Runnable listener) {
        this.myListeners.remove(listener);
    }

    boolean libraryAlreadyExists(String libraryName) {
        Iterator it = this.myTableModifiableModel.getLibraryIterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            LibraryEditor editor = this.getLibraryEditor(lib);
            String libName = editor != null ? editor.getName() : lib.getName();
            if (!libraryName.equals(libName)) continue;
            return true;
        }
        return false;
    }

    static Icon getIconForUrl(String url, boolean isValid, boolean isJarDirectory) {
        VirtualFile presentableFile;
        Icon icon = isValid ? ((presentableFile = LibraryTableEditor.isJarFileRoot(url) ? LocalFileSystem.getInstance().findFileByPath(LibraryTableEditor.getPresentablePath(url)) : VirtualFileManager.getInstance().findFileByUrl(url)) != null && presentableFile.isValid() ? (presentableFile.getFileSystem() instanceof HttpFileSystem ? Icons.WEB_ICON : (presentableFile.isDirectory() ? (isJarDirectory ? JAR_DIRECTORY_ICON : Icons.DIRECTORY_CLOSED_ICON) : IconUtilEx.getIcon((Object)presentableFile, (int)0, null))) : INVALID_ITEM_ICON) : INVALID_ITEM_ICON;
        return icon;
    }

    static String getPresentablePath(String url) {
        String presentablePath = VirtualFileManager.extractPath((String)url);
        if (LibraryTableEditor.isJarFileRoot(url)) {
            presentablePath = presentablePath.substring(0, presentablePath.length() - "!/".length());
        }
        return presentablePath;
    }

    private static boolean isJarFileRoot(String url) {
        return VirtualFileManager.extractPath((String)url).endsWith("!/");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 6, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), 0, 6, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        this.myAddLibraryButton = jButton9 = new JButton();
        this.$$$loadButtonText$$$(jButton9, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.add.button"));
        jPanel3.add((Component)jButton9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttachClassesButton = jButton8 = new JButton();
        this.$$$loadButtonText$$$(jButton8, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.attach.classes.button"));
        jPanel3.add((Component)jButton8, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAttachSourcesButton = jButton7 = new JButton();
        this.$$$loadButtonText$$$(jButton7, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.attach.sources.button"));
        jPanel3.add((Component)jButton7, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttachJavadocsButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.javadoc.attach.button"));
        jPanel3.add((Component)jButton6, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messages/ProjectBundle").getString("library.detach.action"));
        jPanel3.add((Component)jButton5, new GridConstraints(8, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttachUrlJavadocsButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.javadoc.url.button"));
        jPanel3.add((Component)jButton4, new GridConstraints(7, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRenameLibraryButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.rename.button"));
        jPanel3.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttachJarDirectoriesButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ProjectBundle").getString("module.libraries.attach.jar.directories.button"));
        jPanel3.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAttachAnnotationsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ProjectBundle").getString("attach.annotations.button"));
        jPanel3.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTreePanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        public MyTreeSpeedSearch(Tree tree) {
            super((JTree)tree);
        }

        @Override
        public boolean isMatchingElement(Object element, String pattern) {
            Object userObject = ((DefaultMutableTreeNode)((TreePath)element).getLastPathComponent()).getUserObject();
            if (userObject instanceof ItemElementDescriptor || userObject instanceof LibraryElementDescriptor) {
                String str = this.getElementText(element);
                if (str == null) {
                    return false;
                }
                if (!MyTreeSpeedSearch.hasCapitals(pattern)) {
                    str = str.toLowerCase();
                }
                if (pattern.contains(File.separator)) {
                    return this.compare(str, pattern);
                }
                StringTokenizer tokenizer = new StringTokenizer(str, File.separator);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!this.compare(token, pattern)) continue;
                    return true;
                }
                return false;
            }
            return super.isMatchingElement(element, pattern);
        }

        private static boolean hasCapitals(String str) {
            for (int idx = 0; idx < str.length(); ++idx) {
                if (!Character.isUpperCase(str.charAt(idx))) continue;
                return true;
            }
            return false;
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateButtons();
        }

        public void updateButtons() {
            Object[] selectedElements = LibraryTableEditor.this.getSelectedElements();
            Class<? extends Object> elementsClass = this.getElementsClass(selectedElements);
            LibraryTableEditor.this.myRemoveButton.setEnabled(elementsClass != null && !elementsClass.isAssignableFrom(ClassesElement.class) && !elementsClass.equals(SourcesElement.class) && !elementsClass.isAssignableFrom(JavadocElement.class) && !elementsClass.isAssignableFrom(AnnotationElement.class) && (LibraryTableEditor.this.myLibraryTableProvider.isLibraryTableEditable() || !elementsClass.isAssignableFrom(LibraryElement.class)));
            LibraryTableEditor.this.myRenameLibraryButton.setEnabled(selectedElements.length == 1 && elementsClass != null && elementsClass.equals(LibraryElement.class));
            if (elementsClass != null && elementsClass.isAssignableFrom(ItemElement.class)) {
                LibraryTableEditor.this.myRemoveButton.setText(ProjectBundle.message((String)"library.detach.action", (Object[])new Object[0]));
            } else {
                LibraryTableEditor.this.myRemoveButton.setText(ProjectBundle.message((String)"library.detach.action", (Object[])new Object[0]));
            }
            boolean attachActionsEnabled = selectedElements.length == 1 || LibraryTableEditor.this.getSelectedLibrary() != null;
            LibraryTableEditor.this.myAttachClassesButton.setEnabled(attachActionsEnabled);
            LibraryTableEditor.this.myAttachJavadocsButton.setEnabled(attachActionsEnabled);
            LibraryTableEditor.this.myAttachUrlJavadocsButton.setEnabled(attachActionsEnabled);
            LibraryTableEditor.this.myAttachSourcesButton.setEnabled(attachActionsEnabled);
            LibraryTableEditor.this.myAttachAnnotationsButton.setEnabled(attachActionsEnabled);
            LibraryTableEditor.this.myAttachJarDirectoriesButton.setEnabled(attachActionsEnabled);
        }

        @Nullable
        private Class<? extends Object> getElementsClass(Object[] elements) {
            if (elements.length == 0) {
                return null;
            }
            Class<?> cls = null;
            for (Object element : elements) {
                if (cls == null) {
                    cls = element.getClass();
                    continue;
                }
                if (cls.equals(element.getClass())) continue;
                return null;
            }
            return cls;
        }
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private JTextField myNameField;
        private Library[] mySelectedLibraries;

        public MyDialogWrapper(Component parent) {
            super(parent, true);
            this.setTitle(LibraryTableEditor.this.myLibraryTableProvider.getLibraryTablePresentation().getLibraryTableEditorTitle());
            this.init();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)LibraryTableEditor.this);
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor.MyDialogWrapper";
        }

        public JComponent getPreferredFocusedComponent() {
            if (this.myNameField != null) {
                return this.myNameField;
            }
            return LibraryTableEditor.this.myTree;
        }

        protected void doOKAction() {
            this.mySelectedLibraries = LibraryTableEditor.this.getSelectedLibraries();
            if (this.myNameField != null) {
                Library library = LibraryTableEditor.this.getSelectedLibrary();
                String currentName = LibraryTableEditor.this.getLibraryEditor(library).getName();
                String newName = this.myNameField.getText().trim();
                if (newName.length() == 0) {
                    newName = null;
                }
                if (!Comparing.equal((String)newName, (String)currentName)) {
                    if (!LibraryTableEditor.this.myEditingModuleLibraries) {
                        if (newName == null) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.not.specified.error", (Object[])new Object[]{newName}), (String)ProjectBundle.message((String)"library.name.not.specified.title", (Object[])new Object[0]));
                            return;
                        }
                        if (LibraryTableEditor.this.libraryAlreadyExists(newName)) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{newName}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                            return;
                        }
                    }
                    LibraryTableEditor.this.renameLibrary(library, newName);
                }
            }
            LibraryTableEditor.this.commitChanges();
            super.doOKAction();
        }

        protected JComponent createNorthPanel() {
            if (LibraryTableEditor.this.myTreeBuilder.getTreeStructure() instanceof LibraryTreeStructure) {
                Library library = LibraryTableEditor.this.getSelectedLibrary();
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                LibraryEditor libraryEditor = LibraryTableEditor.this.getLibraryEditor(library);
                String currentName = libraryEditor.getName();
                this.myNameField = new JTextField(currentName);
                panel.add((Component)this.myNameField, "Center");
                JLabel label = new JLabel("Name: ");
                panel.add((Component)label, "West");
                label.setLabelFor(this.myNameField);
                label.setDisplayedMnemonic('N');
                this.myNameField.selectAll();
                return panel;
            }
            return super.createNorthPanel();
        }

        protected JComponent createCenterPanel() {
            return LibraryTableEditor.this.getComponent();
        }

        public Library[] getSelectedLibraries() {
            return this.mySelectedLibraries;
        }
    }

    private class RenameLibraryAction
    implements ActionListener {
        private RenameLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Library selectedLibrary = LibraryTableEditor.this.getSelectedLibrary();
            if (selectedLibrary == null) {
                return;
            }
            final String currentName = selectedLibrary.getName();
            String newName = Messages.showInputDialog((Component)LibraryTableEditor.this.myTree, (String)ProjectBundle.message((String)"library.rename.prompt", (Object[])new Object[0]), (String)ProjectBundle.message((String)"library.rename.title", (Object[])new Object[]{LibraryTableEditor.this.getLibraryEditor(selectedLibrary).getName()}), (Icon)Messages.getQuestionIcon(), (String)LibraryTableEditor.this.getLibraryEditor(selectedLibrary).getName(), (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return true;
                }

                public boolean canClose(String libraryName) {
                    if (!currentName.equals(libraryName) && LibraryTableEditor.this.libraryAlreadyExists(libraryName)) {
                        Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{libraryName}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                        return false;
                    }
                    return true;
                }
            });
            LibraryTableEditor.this.renameLibrary(selectedLibrary, newName);
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final Object[] selectedElements = LibraryTableEditor.this.getSelectedElements();
            if (selectedElements.length == 0) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (Object selectedElement : selectedElements) {
                        if (selectedElement instanceof LibraryElement) {
                            LibraryTableEditor.this.removeLibrary(((LibraryElement)selectedElement).getLibrary());
                            continue;
                        }
                        if (!(selectedElement instanceof ItemElement)) continue;
                        ItemElement itemElement = (ItemElement)selectedElement;
                        Library library = itemElement.getLibrary();
                        LibraryTableEditor.this.getLibraryEditor(library).removeRoot(itemElement.getUrl(), itemElement.getRootType());
                    }
                    if (LibraryTableEditor.this.myEditingModuleLibraries) {
                        LibraryTableEditor.this.commitChanges();
                    }
                }
            });
            LibraryTableEditor.this.librariesChanged(true);
        }
    }

    private class AttachUrlJavadocAction
    implements ActionListener {
        private AttachUrlJavadocAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile vFile;
            Library library = LibraryTableEditor.this.getSelectedLibrary();
            if (library != null && (vFile = Util.showSpecifyJavadocUrlDialog(LibraryTableEditor.this.myPanel)) != null) {
                LibraryTableEditor.this.attachFiles(library, new VirtualFile[]{vFile}, JavadocOrderRootType.getInstance(), false);
            }
            LibraryTableEditor.this.myTree.requestFocus();
        }
    }

    private class AttachJavadocAction
    extends AttachItemAction {
        private AttachJavadocAction() {
        }

        @Override
        protected String getTitle() {
            return ProjectBundle.message((String)"library.attach.javadoc.action", (Object[])new Object[0]);
        }

        @Override
        protected String getDescription() {
            return ProjectBundle.message((String)"library.attach.javadoc.description", (Object[])new Object[0]);
        }

        @Override
        protected OrderRootType getRootType() {
            return JavadocOrderRootType.getInstance();
        }
    }

    private class AttachAnnotationsAction
    extends AttachItemAction {
        private AttachAnnotationsAction() {
        }

        @Override
        protected String getTitle() {
            return ProjectBundle.message((String)"library.attach.external.annotations.action", (Object[])new Object[0]);
        }

        @Override
        protected String getDescription() {
            return ProjectBundle.message((String)"library.attach.external.annotations.description", (Object[])new Object[0]);
        }

        @Override
        protected OrderRootType getRootType() {
            return AnnotationOrderRootType.getInstance();
        }

        @Override
        protected FileChooserDescriptor createDescriptor() {
            return new FileChooserDescriptor(false, true, false, false, false, false);
        }
    }

    private class AttachSourcesAction
    extends AttachItemAction {
        private AttachSourcesAction() {
        }

        @Override
        protected String getTitle() {
            return ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]);
        }

        @Override
        protected String getDescription() {
            return ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]);
        }

        @Override
        protected OrderRootType getRootType() {
            return OrderRootType.SOURCES;
        }

        @Override
        protected VirtualFile[] scanForActualRoots(VirtualFile[] rootCandidates) {
            return PathUIUtils.scanAndSelectDetectedJavaSourceRoots(LibraryTableEditor.this.myPanel, rootCandidates);
        }
    }

    private class AttachJarDirectoriesAction
    extends AttachItemAction {
        private AttachJarDirectoriesAction() {
        }

        @Override
        protected FileChooserDescriptor createDescriptor() {
            return new FileChooserDescriptor(false, true, false, false, false, true);
        }

        @Override
        protected boolean addAsJarDirectories() {
            return true;
        }

        @Override
        protected String getTitle() {
            Library selectedLibrary = LibraryTableEditor.this.getSelectedLibrary();
            if (selectedLibrary != null) {
                return ProjectBundle.message((String)"library.attach.jar.directory.to.library.action", (Object[])new Object[]{LibraryTableEditor.this.getLibraryEditor(selectedLibrary).getName()});
            }
            return ProjectBundle.message((String)"library.attach.jar.directory.action", (Object[])new Object[0]);
        }

        @Override
        protected String getDescription() {
            return ProjectBundle.message((String)"library.attach.jar.directory.description", (Object[])new Object[0]);
        }

        @Override
        protected OrderRootType getRootType() {
            return OrderRootType.CLASSES;
        }
    }

    private class AttachClassesAction
    extends AttachItemAction {
        private AttachClassesAction() {
        }

        @Override
        protected FileChooserDescriptor createDescriptor() {
            return new FileChooserDescriptor(false, true, true, false, false, true);
        }

        @Override
        protected String getTitle() {
            Library selectedLibrary = LibraryTableEditor.this.getSelectedLibrary();
            if (selectedLibrary != null) {
                return ProjectBundle.message((String)"library.attach.classes.to.library.action", (Object[])new Object[]{LibraryTableEditor.this.getLibraryEditor(selectedLibrary).getName()});
            }
            return ProjectBundle.message((String)"library.attach.classes.action", (Object[])new Object[0]);
        }

        @Override
        protected String getDescription() {
            return ProjectBundle.message((String)"library.attach.classes.description", (Object[])new Object[0]);
        }

        @Override
        protected OrderRootType getRootType() {
            return OrderRootType.CLASSES;
        }
    }

    private abstract class AttachItemAction
    implements ActionListener {
        private final FileChooserDescriptor myDescriptor = this.createDescriptor();
        private VirtualFile myLastChosen = null;

        protected abstract String getTitle();

        protected abstract String getDescription();

        protected abstract OrderRootType getRootType();

        protected AttachItemAction() {
        }

        protected FileChooserDescriptor createDescriptor() {
            return new FileChooserDescriptor(false, true, true, false, true, true);
        }

        protected VirtualFile[] scanForActualRoots(VirtualFile[] rootCandidates) {
            return rootCandidates;
        }

        protected boolean addAsJarDirectories() {
            return false;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            Library library = LibraryTableEditor.this.getSelectedLibrary();
            if (library != null) {
                this.myDescriptor.setTitle(this.getTitle());
                this.myDescriptor.setDescription(this.getDescription());
                for (Map.Entry entry : LibraryTableEditor.this.myFileChooserUserData.entrySet()) {
                    this.myDescriptor.putUserData((DataKey)entry.getKey(), entry.getValue());
                }
                VirtualFile toSelect = this.getFileToSelect(library);
                VirtualFile[] attachedFiles = LibraryTableEditor.this.attachFiles(library, this.scanForActualRoots(FileChooser.chooseFiles((Component)LibraryTableEditor.this.myPanel, (FileChooserDescriptor)this.myDescriptor, (VirtualFile)toSelect)), this.getRootType(), this.addAsJarDirectories());
                if (attachedFiles.length > 0) {
                    this.myLastChosen = attachedFiles[0];
                }
            }
            LibraryTableEditor.this.fireLibrariesChanged();
            LibraryTableEditor.this.myTree.requestFocus();
        }

        @Nullable
        private VirtualFile getFileToSelect(Library library) {
            Project project;
            VirtualFile toSelect = this.myLastChosen;
            if (toSelect == null) {
                for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
                    VirtualFile[] existingRoots = library.getFiles((OrderRootType)orderRootType);
                    if (existingRoots.length <= 0) continue;
                    VirtualFile existingRoot = existingRoots[0];
                    if (existingRoot.getFileSystem() instanceof JarFileSystem) {
                        existingRoot = JarFileSystem.getInstance().getVirtualFileForJar(existingRoot);
                    }
                    if (existingRoot == null) break;
                    if (existingRoot.isDirectory()) {
                        toSelect = existingRoot;
                        break;
                    }
                    toSelect = existingRoot.getParent();
                    break;
                }
            }
            if (toSelect == null && Comparing.strEqual((String)LibraryTableEditor.this.myLibraryTableProvider.getTableLevel(), (String)"project") && (project = LibraryTableEditor.this.myProject) != null) {
                toSelect = project.getBaseDir();
            }
            return toSelect;
        }
    }

    private class AddLibraryAction
    implements ActionListener {
        private boolean myNeedSelection;

        public AddLibraryAction() {
            this(false);
        }

        public AddLibraryAction(boolean select) {
            this.myNeedSelection = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String initial = LibraryTableEditor.suggestNewLibraryName(LibraryTableEditor.this.myTableModifiableModel);
            String prompt = ProjectBundle.message((String)"library.name.prompt", (Object[])new Object[0]);
            String title = LibraryTableEditor.this.myAddLibraryButton.getText().replaceAll(String.valueOf('\u001b'), "");
            Icon icon = Messages.getQuestionIcon();
            String libraryName = Messages.showInputDialog((Project)LibraryTableEditor.this.myProject, (String)prompt, (String)title, (Icon)icon, (String)initial, (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return true;
                }

                public boolean canClose(String inputString) {
                    if (inputString.length() == 0) {
                        Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.not.specified.error", (Object[])new Object[0]), (String)ProjectBundle.message((String)"library.name.not.specified.title", (Object[])new Object[0]));
                        return false;
                    }
                    if (LibraryTableEditor.libraryAlreadyExists(LibraryTableEditor.this.myTableModifiableModel, inputString)) {
                        Messages.showErrorDialog((String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{inputString}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                        return false;
                    }
                    return true;
                }
            });
            if (libraryName == null) {
                return;
            }
            Library library = LibraryTableEditor.this.myTableModifiableModel.createLibrary(libraryName);
            LibraryTableEditor.this.selectLibrary(library, true);
            if (LibraryTableEditor.this.myProject != null) {
                BaseLibrariesConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(LibraryTableEditor.this.myProject).getConfigurableFor(library);
                final LibraryEditor libraryEditor = LibraryTableEditor.this.getLibraryEditor(library);
                if (libraryEditor.hasChanges()) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            libraryEditor.commit();
                        }
                    });
                }
                MasterDetailsComponent.MyNode libraryNode = MasterDetailsComponent.findNodeByObject((TreeNode)((TreeNode)rootConfigurable.getTree().getModel().getRoot()), (Object)library);
                if (this.myNeedSelection) {
                    rootConfigurable.selectNodeInTree((DefaultMutableTreeNode)libraryNode);
                    if (!LibraryTableEditor.this.myEditingModuleLibraries) {
                        this.appendLibraryToModules(ModuleStructureConfigurable.getInstance(LibraryTableEditor.this.myProject), library);
                    }
                }
            }
            LibraryTableEditor.this.librariesChanged(true);
        }

        private void appendLibraryToModules(ModuleStructureConfigurable rootConfigurable, Library libraryToSelect) {
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.addAll(Arrays.asList(rootConfigurable.getModules()));
            ChooseModulesDialog dlg = new ChooseModulesDialog(LibraryTableEditor.this.myProject, (List<? extends Module>)modules, ProjectBundle.message((String)"choose.modules.dialog.title", (Object[])new Object[0]), ProjectBundle.message((String)"choose.modules.dialog.description", (Object[])new Object[]{libraryToSelect.getName()}));
            dlg.show();
            if (dlg.isOK()) {
                List choosenModules = dlg.getChosenElements();
                for (Module module : choosenModules) {
                    rootConfigurable.addLibraryOrderEntry(module, libraryToSelect);
                }
            }
        }
    }
}

