/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nullable;

public class LibraryFileChooser
extends FileChooserDialogImpl {
    private JTextField myNameField;
    private final boolean myInputName;
    private final LibraryTableEditor myParentEditor;
    private boolean myNameChangedByUser = false;

    public LibraryFileChooser(FileChooserDescriptor chooserDescriptor, Component parent, boolean inputName, LibraryTableEditor parentEditor) {
        super(chooserDescriptor, parent);
        this.myInputName = inputName;
        this.myParentEditor = parentEditor;
    }

    public String getName() {
        if (this.myNameField != null) {
            String name = this.myNameField.getText().trim();
            return name.length() > 0 ? name : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setName(String name) {
        if (this.myNameField != null) {
            boolean savedValue = this.myNameChangedByUser;
            try {
                this.myNameField.setText(name);
            }
            finally {
                this.myNameChangedByUser = savedValue;
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myInputName ? this.myNameField : super.getPreferredFocusedComponent();
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        if (!this.myInputName) {
            return centerPanel;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)centerPanel, "Center");
        FieldPanel fieldPanel = FieldPanel.create((String)ProjectBundle.message((String)"library.name.prompt", (Object[])new Object[0]), null);
        fieldPanel.getFieldLabel().setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myNameField = fieldPanel.getTextField();
        this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LibraryFileChooser.this.myNameChangedByUser = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LibraryFileChooser.this.myNameChangedByUser = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LibraryFileChooser.this.myNameChangedByUser = true;
            }
        });
        panel.add((Component)fieldPanel, "North");
        this.myFileSystemTree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LibraryFileChooser.this.myNameField == null || LibraryFileChooser.this.myNameChangedByUser) {
                    return;
                }
                VirtualFile[] selectedFiles = LibraryFileChooser.this.getSelectedFiles();
                LibraryFileChooser.this.setName(selectedFiles.length == 1 ? selectedFiles[0].getNameWithoutExtension() : "");
            }
        });
        return panel;
    }

    @Override
    protected void doOKAction() {
        if (!this.validateData()) {
            return;
        }
        super.doOKAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean validateData() {
        block12: {
            block6: {
                block11: {
                    block9: {
                        block10: {
                            block7: {
                                block8: {
                                    componentToFocus /* !! */  = null;
                                    try {
                                        chosenFiles = this.getSelectedFiles();
                                        if (chosenFiles == null || chosenFiles.length <= 0) ** GOTO lbl35
                                        if (!this.myInputName) break block6;
                                        name = this.getName();
                                        if (name != null) break block7;
                                        Messages.showErrorDialog((Component)this.myNameField, (String)ProjectBundle.message((String)"library.name.not.specified.error", (Object[])new Object[0]), (String)ProjectBundle.message((String)"library.name.not.specified.title", (Object[])new Object[0]));
                                        componentToFocus /* !! */  = this.myNameField;
                                        var4_6 = false;
                                        if (componentToFocus /* !! */  == null) break block8;
                                        _componentToFocus /* !! */  = componentToFocus /* !! */ ;
                                    }
                                    catch (Throwable var6_12) {
                                        if (componentToFocus /* !! */  != null) {
                                            _componentToFocus = componentToFocus /* !! */ ;
                                            SwingUtilities.invokeLater(new Runnable(_componentToFocus){
                                                final /* synthetic */ JComponent val$_componentToFocus;
                                                {
                                                    this.val$_componentToFocus = jComponent;
                                                }

                                                @Override
                                                public void run() {
                                                    this.val$_componentToFocus.requestFocus();
                                                }
                                            });
                                        }
                                        throw var6_12;
                                    }
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                                return var4_6;
                            }
                            if (!this.myParentEditor.libraryAlreadyExists(name)) break block9;
                            Messages.showErrorDialog((Component)this.myNameField, (String)ProjectBundle.message((String)"library.name.already.exists.error", (Object[])new Object[]{name}), (String)ProjectBundle.message((String)"library.name.already.exists.title", (Object[])new Object[0]));
                            componentToFocus /* !! */  = this.myNameField;
                            var4_7 = false;
                            if (componentToFocus /* !! */  == null) break block10;
                            _componentToFocus /* !! */  = componentToFocus /* !! */ ;
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        return var4_7;
                    }
                    break block6;
lbl35:
                    // 1 sources

                    Messages.showErrorDialog((String)ProjectBundle.message((String)"library.files.not.selected.error", (Object[])new Object[0]), (String)ProjectBundle.message((String)"library.files.not.selected.title", (Object[])new Object[0]));
                    componentToFocus /* !! */  = this.myFileSystemTree.getTree();
                    var3_4 = false;
                    if (componentToFocus /* !! */  == null) break block11;
                    _componentToFocus = componentToFocus /* !! */ ;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                return var3_4;
            }
            var3_5 = true;
            if (componentToFocus /* !! */  == null) break block12;
            _componentToFocus = componentToFocus /* !! */ ;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return var3_5;
    }

    public Pair<String, VirtualFile[]> chooseNameAndFiles(@Nullable VirtualFile toSelect) {
        VirtualFile[] chosenFiles = this.choose(toSelect, null);
        return new Pair((Object)this.getName(), (Object)chosenFiles);
    }

    public Pair<String, VirtualFile[]> chooseNameAndFiles() {
        return this.chooseNameAndFiles(null);
    }
}

