/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import java.awt.Color;
import java.io.File;

class ItemElementDescriptor
extends NodeDescriptor<ItemElement> {
    private final ItemElement myElement;

    public ItemElementDescriptor(NodeDescriptor parentDescriptor, ItemElement element) {
        super(null, parentDescriptor);
        this.myElement = element;
        String url = element.getUrl();
        this.myName = LibraryTableEditor.getPresentablePath(url).replace('/', File.separatorChar);
        this.myOpenIcon = this.myClosedIcon = LibraryTableEditor.getIconForUrl(url, element.isValid(), element.isJarDirectory());
    }

    public boolean update() {
        Color color = this.myElement.isValid() ? Color.BLACK : Color.RED;
        boolean changes = !color.equals(this.myColor);
        this.myColor = color;
        return changes;
    }

    public ItemElement getElement() {
        return this.myElement;
    }
}

