/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactEditorFindUsagesActionBase
extends FindUsagesInProjectStructureActionBase {
    private Tree myTree;
    private ArtifactsStructureConfigurableContext myArtifactContext;

    public ArtifactEditorFindUsagesActionBase(Tree tree, Project project, ArtifactsStructureConfigurableContext artifactContext) {
        super((JComponent)tree, project);
        this.myTree = tree;
        this.myArtifactContext = artifactContext;
    }

    @Override
    protected boolean isEnabled() {
        ArtifactsTreeNode node = this.getSelectedNode();
        return node != null && node.getElementPresentation().getSourceObject() != null;
    }

    @Override
    protected ProjectStructureElement getSelectedElement() {
        ArtifactsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        Object sourceObject = node.getElementPresentation().getSourceObject();
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.getContext().getProject()).getContext();
        if (sourceObject instanceof Module) {
            return new ModuleProjectStructureElement(context, (Module)sourceObject);
        }
        if (sourceObject instanceof Library) {
            return new LibraryProjectStructureElement(context, (Library)sourceObject);
        }
        if (sourceObject instanceof Artifact) {
            return this.myArtifactContext.getOrCreateArtifactElement((Artifact)sourceObject);
        }
        return null;
    }

    @Nullable
    protected abstract ArtifactsTreeNode getSelectedNode();

    @Override
    protected RelativePoint getPointToShowResults() {
        int selectedRow = this.myTree.getSelectionRows()[0];
        Rectangle rowBounds = this.myTree.getRowBounds(selectedRow);
        Point location = rowBounds.getLocation();
        location.y += rowBounds.height;
        return new RelativePoint((Component)this.myTree, location);
    }
}

