/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurableContextImpl
implements ArtifactsStructureConfigurableContext {
    private ModifiableArtifactModel myModifiableModel;
    private final ManifestFilesInfo myManifestFilesInfo = new ManifestFilesInfo();
    private ArtifactAdapter myModifiableModelListener;
    private StructureConfigurableContext myContext;
    private Project myProject;
    private Map<Artifact, CompositePackagingElement<?>> myModifiableRoots = new HashMap();
    private Map<Artifact, ArtifactEditorImpl> myArtifactEditors = new HashMap<Artifact, ArtifactEditorImpl>();
    private Map<ArtifactPointer, ArtifactEditorSettings> myEditorSettings = new HashMap<ArtifactPointer, ArtifactEditorSettings>();
    private Map<Artifact, ArtifactProjectStructureElement> myArtifactElements = new HashMap<Artifact, ArtifactProjectStructureElement>();
    private final ArtifactEditorSettings myDefaultSettings;

    public ArtifactsStructureConfigurableContextImpl(StructureConfigurableContext context, Project project, ArtifactEditorSettings defaultSettings, ArtifactAdapter modifiableModelListener) {
        this.myDefaultSettings = defaultSettings;
        this.myModifiableModelListener = modifiableModelListener;
        this.myContext = context;
        this.myProject = project;
        context.getDaemonAnalyzer().addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void usagesCollected(@NotNull ProjectStructureElement containingElement) {
                if (containingElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl$1.usagesCollected must not be null");
                }
            }

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl$1.problemsChanged must not be null");
                }
                if (element instanceof ArtifactProjectStructureElement) {
                    Artifact originalArtifact = ((ArtifactProjectStructureElement)element).getOriginalArtifact();
                    ArtifactEditorImpl artifactEditor = (ArtifactEditorImpl)ArtifactsStructureConfigurableContextImpl.this.myArtifactEditors.get(originalArtifact);
                    if (artifactEditor != null) {
                        ArtifactsStructureConfigurableContextImpl.this.updateProblems(originalArtifact, artifactEditor);
                    }
                }
            }

            @Override
            public void allProblemsChanged() {
                for (Map.Entry entry : ArtifactsStructureConfigurableContextImpl.this.myArtifactEditors.entrySet()) {
                    ArtifactsStructureConfigurableContextImpl.this.updateProblems((Artifact)entry.getKey(), (ArtifactEditorImpl)entry.getValue());
                }
            }
        });
    }

    private void updateProblems(Artifact originalArtifact, ArtifactEditorImpl artifactEditor) {
        ProjectStructureProblemsHolderImpl holder = this.myContext.getDaemonAnalyzer().getProblemsHolder(this.getOrCreateArtifactElement(originalArtifact));
        artifactEditor.getValidationManager().updateProblems(holder);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getProject must not return null");
        }
        return project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ArtifactModel getArtifactModel() {
        ModifiableArtifactModel modifiableArtifactModel;
        if (this.myModifiableModel != null) {
            modifiableArtifactModel = this.myModifiableModel;
            if (modifiableArtifactModel == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getArtifactModel must not return null");
            return modifiableArtifactModel;
        }
        modifiableArtifactModel = ArtifactManager.getInstance((Project)this.myProject);
        if (modifiableArtifactModel != null) return modifiableArtifactModel;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getArtifactModel must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        Artifact artifact2;
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOriginalArtifact must not be null");
        }
        if (this.myModifiableModel != null) {
            artifact2 = this.myModifiableModel.getOriginalArtifact(artifact);
            if (artifact2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOriginalArtifact must not return null");
            return artifact2;
        }
        artifact2 = artifact;
        if (artifact2 != null) return artifact2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOriginalArtifact must not return null");
    }

    @Override
    public ModifiableModuleModel getModifiableModuleModel() {
        return this.myContext.getModulesConfigurator().getModuleModel();
    }

    @Override
    public void queueValidation(Artifact artifact) {
        this.myContext.getDaemonAnalyzer().queueUpdate(this.getOrCreateArtifactElement(artifact), true, false);
    }

    @Override
    public CompositePackagingElement<?> getRootElement(@NotNull Artifact artifact) {
        Artifact modifiableArtifact;
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getRootElement must not be null");
        }
        artifact = this.getOriginalArtifact(artifact);
        if (this.myModifiableModel != null && (modifiableArtifact = this.myModifiableModel.getModifiableCopy(artifact)) != null) {
            this.myModifiableRoots.put(artifact, modifiableArtifact.getRootElement());
        }
        return this.getOrCreateModifiableRootElement(artifact);
    }

    private CompositePackagingElement<?> getOrCreateModifiableRootElement(Artifact originalArtifact) {
        CompositePackagingElement<?> root = this.myModifiableRoots.get(originalArtifact);
        if (root == null) {
            root = ArtifactUtil.copyFromRoot(originalArtifact.getRootElement(), this.myProject);
            this.myModifiableRoots.put(originalArtifact, root);
        }
        return root;
    }

    @Override
    public void editLayout(@NotNull Artifact artifact, final Runnable action) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.editLayout must not be null");
        }
        final Artifact originalArtifact = this.getOriginalArtifact(artifact);
        new WriteAction(){

            protected void run(Result result) {
                ModifiableArtifact modifiableArtifact = ArtifactsStructureConfigurableContextImpl.this.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(originalArtifact);
                if (modifiableArtifact.getRootElement() == originalArtifact.getRootElement()) {
                    modifiableArtifact.setRootElement(ArtifactsStructureConfigurableContextImpl.this.getOrCreateModifiableRootElement(originalArtifact));
                }
                action.run();
            }
        }.execute();
        this.myContext.getDaemonAnalyzer().queueUpdate(this.getOrCreateArtifactElement(originalArtifact));
    }

    @Nullable
    public ArtifactEditorImpl getArtifactEditor(Artifact artifact) {
        return this.myArtifactEditors.get(this.getOriginalArtifact(artifact));
    }

    @Override
    public ArtifactEditorImpl getOrCreateEditor(Artifact artifact) {
        ArtifactEditorImpl artifactEditor = this.myArtifactEditors.get(artifact = this.getOriginalArtifact(artifact));
        if (artifactEditor == null) {
            ArtifactEditorSettings settings = this.myEditorSettings.get(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact, this.getArtifactModel()));
            artifactEditor = new ArtifactEditorImpl(this, artifact, settings != null ? settings : this.myDefaultSettings);
            this.myArtifactEditors.put(artifact, artifactEditor);
        }
        return artifactEditor;
    }

    @Nullable
    public ModifiableArtifactModel getActualModifiableModel() {
        return this.myModifiableModel;
    }

    @Override
    @NotNull
    public ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        if (this.myModifiableModel == null) {
            this.myModifiableModel = ArtifactManager.getInstance((Project)this.myProject).createModifiableModel();
            this.myModifiableModel.addListener((ArtifactListener)this.myModifiableModelListener);
        }
        ModifiableArtifactModel modifiableArtifactModel = this.myModifiableModel;
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOrCreateModifiableArtifactModel must not return null");
        }
        return modifiableArtifactModel;
    }

    @Override
    public ArtifactEditorSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesConfigurator modulesConfigurator = this.myContext.getModulesConfigurator();
        if (modulesConfigurator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getModulesProvider must not return null");
        }
        return modulesConfigurator;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        ProjectFacetsConfigurator projectFacetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        if (projectFacetsConfigurator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getFacetsProvider must not return null");
        }
        return projectFacetsConfigurator;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.findLibrary must not be null");
        }
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.findLibrary must not be null");
        }
        Library library = DefaultPackagingElementResolvingContext.findLibrary(this.myProject, level, libraryName);
        return library != null ? this.myContext.getLibraryModel(library) : this.myContext.getLibrary(libraryName, level);
    }

    @Override
    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType) {
        return this.myManifestFilesInfo.getManifestFile(element, artifactType, this);
    }

    public ManifestFilesInfo getManifestFilesInfo() {
        return this.myManifestFilesInfo;
    }

    public void resetModifiableModel() {
        this.disposeUIResources();
        this.myModifiableModel = null;
        this.myModifiableRoots.clear();
        this.myManifestFilesInfo.clear();
    }

    public void disposeUIResources() {
        for (ArtifactEditorImpl editor : this.myArtifactEditors.values()) {
            Disposer.dispose((Disposable)editor);
        }
        this.myArtifactEditors.clear();
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.myArtifactElements.clear();
    }

    public Collection<? extends ArtifactEditorImpl> getArtifactEditors() {
        return Collections.unmodifiableCollection(this.myArtifactEditors.values());
    }

    public void saveEditorSettings() {
        this.myEditorSettings.clear();
        for (ArtifactEditorImpl artifactEditor : this.myArtifactEditors.values()) {
            ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifactEditor.getArtifact(), this.getArtifactModel());
            this.myEditorSettings.put(pointer, artifactEditor.createSettings());
        }
    }

    @Override
    @NotNull
    public ArtifactProjectStructureElement getOrCreateArtifactElement(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOrCreateArtifactElement must not be null");
        }
        ArtifactProjectStructureElement element = this.myArtifactElements.get(this.getOriginalArtifact(artifact));
        if (element == null) {
            element = new ArtifactProjectStructureElement(this.myContext, this, artifact);
            this.myArtifactElements.put(artifact, element);
        }
        ArtifactProjectStructureElement artifactProjectStructureElement = element;
        if (artifactProjectStructureElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurableContextImpl.getOrCreateArtifactElement must not return null");
        }
        return artifactProjectStructureElement;
    }

    @Override
    public ModifiableRootModel getOrCreateModifiableRootModel(Module module) {
        ModuleEditor editor = this.myContext.getModulesConfigurator().getEditor(module);
        return editor.getModifiableRootModelProxy();
    }
}

