/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.OrderPanel;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LibraryDependantsPanel
extends OrderPanel<ModifiableRootModel> {
    private final Library myLibrary;

    public LibraryDependantsPanel(Library library) {
        super(ModifiableRootModel.class, true);
        this.myLibrary = library;
        this.getEntryTable().setDefaultRenderer(ModifiableRootModel.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof ModifiableRootModel) {
                    ModifiableRootModel model = (ModifiableRootModel)value;
                    Module module = model.getModule();
                    this.setText(module.getName());
                    this.setIcon(module.getModuleType().getNodeIcon(false));
                }
                return cellRendererComponent;
            }
        });
        this.getEntryTable().setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanTableCellRenderer());
        this.setBorder(BorderFactory.createTitledBorder("Used In"));
    }

    public boolean isCheckable(ModifiableRootModel entry) {
        return true;
    }

    public boolean isChecked(ModifiableRootModel model) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = model.getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.equal((Object)(libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary(), (Object)this.myLibrary)) continue;
            return true;
        }
        return false;
    }

    public void setChecked(ModifiableRootModel model, boolean checked) {
        if (checked) {
            model.addLibraryEntry(this.myLibrary);
        } else {
            OrderEntry[] entries;
            for (OrderEntry entry : entries = model.getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                if (!(entry instanceof LibraryOrderEntry) || !Comparing.equal((Object)(libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary(), (Object)this.myLibrary)) continue;
                model.removeOrderEntry((OrderEntry)libraryOrderEntry);
                break;
            }
        }
    }
}

