/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.NewFolderAction;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleExcludedStateAction;
import com.intellij.openapi.roots.ui.configuration.actions.ToggleSourcesStateAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ContentEntryTreeEditor {
    private final Project myProject;
    private final boolean myCanMarkSources;
    private final boolean myCanMarkTestSources;
    protected Tree myTree;
    private FileSystemTreeImpl myFileSystemTree;
    private final JPanel myTreePanel;
    private final DefaultMutableTreeNode EMPTY_TREE_ROOT = new DefaultMutableTreeNode(ProjectBundle.message((String)"module.paths.empty.node", (Object[])new Object[0]));
    protected DefaultActionGroup myEditingActionsGroup;
    @Nullable
    private ContentEntryEditor myContentEntryEditor;
    private final MyContentEntryEditorListener myContentEntryEditorListener = new MyContentEntryEditorListener();
    private final FileChooserDescriptor myDescriptor;

    public ContentEntryTreeEditor(Project project, boolean canMarkSources, boolean canMarkTestSources) {
        this.myProject = project;
        this.myCanMarkSources = canMarkSources;
        this.myCanMarkTestSources = canMarkTestSources;
        this.myTree = new Tree();
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        this.myEditingActionsGroup = new DefaultActionGroup();
        TreeToolTipHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTreePanel = new MyPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
        this.myTreePanel.add((Component)new ToolbarPanel((JComponent)scrollPane, (ActionGroup)this.myEditingActionsGroup), "Center");
        this.myTreePanel.setVisible(false);
        this.myDescriptor = new FileChooserDescriptor(false, true, false, false, false, true);
        this.myDescriptor.setShowFileSystemRoots(false);
    }

    protected void createEditingActions() {
        if (this.myCanMarkSources) {
            ToggleSourcesStateAction markSourcesAction = new ToggleSourcesStateAction((JTree)this.myTree, this, false);
            markSourcesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(83, 8)), (JComponent)this.myTree);
            this.myEditingActionsGroup.add((AnAction)markSourcesAction);
        }
        if (this.myCanMarkTestSources) {
            this.setupTestsAction();
        }
        this.setupExcludedAction();
    }

    protected TreeCellRenderer getContentEntryCellRenderer() {
        return new ContentEntryTreeCellRenderer(this);
    }

    public void setContentEntryEditor(ContentEntryEditor contentEntryEditor) {
        if (this.myContentEntryEditor != null && this.myContentEntryEditor.equals(contentEntryEditor)) {
            return;
        }
        if (this.myFileSystemTree != null) {
            Disposer.dispose((Disposable)this.myFileSystemTree);
            this.myFileSystemTree = null;
        }
        if (this.myContentEntryEditor != null) {
            this.myContentEntryEditor.removeContentEntryEditorListener(this.myContentEntryEditorListener);
            this.myContentEntryEditor = null;
        }
        if (contentEntryEditor == null) {
            ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.EMPTY_TREE_ROOT);
            this.myTreePanel.setVisible(false);
            if (this.myFileSystemTree != null) {
                Disposer.dispose((Disposable)this.myFileSystemTree);
            }
            return;
        }
        this.myTreePanel.setVisible(true);
        this.myContentEntryEditor = contentEntryEditor;
        this.myContentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        final VirtualFile file = contentEntryEditor.getContentEntry().getFile();
        this.myDescriptor.setRoot(file);
        if (file != null) {
            this.myDescriptor.setTitle(file.getPresentableUrl());
        } else {
            String url = contentEntryEditor.getContentEntry().getUrl();
            this.myDescriptor.setTitle(VirtualFileManager.extractPath((String)url).replace('/', File.separatorChar));
        }
        Runnable init = new Runnable(){

            @Override
            public void run() {
                ContentEntryTreeEditor.this.myFileSystemTree.updateTree();
                if (file != null) {
                    ContentEntryTreeEditor.this.select(file);
                }
            }
        };
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myDescriptor, this.myTree, this.getContentEntryCellRenderer(), init){

            @Override
            protected AbstractTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, FileChooserDescriptor descriptor, Runnable onInitialized) {
                return new MyFileTreeBuilder(tree, treeModel, treeStructure, comparator, descriptor, onInitialized);
            }
        };
        this.myFileSystemTree.showHiddens(true);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myFileSystemTree);
        MyNewFolderAction newFolderAction = new MyNewFolderAction();
        DefaultActionGroup mousePopupGroup = new DefaultActionGroup();
        mousePopupGroup.add((AnAction)this.myEditingActionsGroup);
        mousePopupGroup.addSeparator();
        mousePopupGroup.add((AnAction)newFolderAction);
        this.myFileSystemTree.registerMouseListener((ActionGroup)mousePopupGroup);
    }

    @Nullable
    public ContentEntryEditor getContentEntryEditor() {
        return this.myContentEntryEditor;
    }

    public JComponent createComponent() {
        this.createEditingActions();
        return this.myTreePanel;
    }

    public void select(VirtualFile file) {
        if (this.myFileSystemTree != null) {
            this.myFileSystemTree.select(file, null);
        }
    }

    public void requestFocus() {
        this.myTree.requestFocus();
    }

    public void update() {
        if (this.myFileSystemTree != null) {
            this.myFileSystemTree.updateTree();
            DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
            int visibleRowCount = this.myTree.getVisibleRowCount();
            for (int row = 0; row < visibleRowCount; ++row) {
                TreeNode node;
                TreePath pathForRow = this.myTree.getPathForRow(row);
                if (pathForRow == null || (node = (TreeNode)pathForRow.getLastPathComponent()) == null) continue;
                model.nodeChanged(node);
            }
        }
    }

    protected void setupTestsAction() {
        ToggleSourcesStateAction markTestsAction = new ToggleSourcesStateAction((JTree)this.myTree, this, true);
        markTestsAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(84, 8)), (JComponent)this.myTree);
        this.myEditingActionsGroup.add((AnAction)markTestsAction);
    }

    protected void setupExcludedAction() {
        ToggleExcludedStateAction toggleExcludedAction = new ToggleExcludedStateAction((JTree)this.myTree, this);
        this.myEditingActionsGroup.add((AnAction)toggleExcludedAction);
        toggleExcludedAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(69, 8)), (JComponent)this.myTree);
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        private MyPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return ContentEntryTreeEditor.this.myFileSystemTree;
            }
            return null;
        }
    }

    private static class MyFileTreeBuilder
    extends FileTreeBuilder {
        public MyFileTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, FileChooserDescriptor descriptor, @Nullable Runnable onInitialized) {
            super(tree, treeModel, treeStructure, comparator, descriptor, onInitialized);
        }

        @Override
        protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
            return false;
        }
    }

    private static class MyNewFolderAction
    extends NewFolderAction
    implements CustomComponentAction {
        private MyNewFolderAction() {
            super(ActionsBundle.message((String)"action.FileChooser.NewFolder.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.FileChooser.NewFolder.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/newFolder.png"));
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return IconWithTextAction.createCustomComponentImpl(this, presentation);
        }
    }

    private class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void sourceFolderAdded(ContentEntryEditor editor, SourceFolder folder) {
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void sourceFolderRemoved(ContentEntryEditor editor, VirtualFile file, boolean isTestSource) {
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderExcluded(ContentEntryEditor editor, VirtualFile file) {
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void folderIncluded(ContentEntryEditor editor, VirtualFile file) {
            ContentEntryTreeEditor.this.update();
        }

        @Override
        public void packagePrefixSet(ContentEntryEditor editor, SourceFolder folder) {
            ContentEntryTreeEditor.this.update();
        }
    }
}

