/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

@State(name="libraryTable", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/libraries/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=LibraryStateSplitter.class)})
public class ProjectLibraryTable
extends LibraryTableBase {
    private static final LibraryTablePresentation PROJECT_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return ProjectBundle.message((String)"project.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return ProjectBundle.message((String)"libraries.node.text.project", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return ProjectBundle.message((String)"library.configure.project.title", (Object[])new Object[0]);
        }
    };

    ProjectLibraryTable() {
    }

    public static LibraryTable getInstance(Project project) {
        return (LibraryTable)ServiceManager.getService((Project)project, ProjectLibraryTable.class);
    }

    public String getTableLevel() {
        return "project";
    }

    public LibraryTablePresentation getPresentation() {
        return PROJECT_LIBRARY_TABLE_PRESENTATION;
    }

    public boolean isEditable() {
        return true;
    }

    public static class LibraryStateSplitter
    implements StateSplitter {
        public List<Pair<Element, String>> splitState(Element e) {
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            List list = e.getChildren();
            for (Object o : list) {
                Element library = (Element)o;
                String name = generator.generateUniqueName(FileUtil.sanitizeFileName((String)library.getAttributeValue("name"))) + ".xml";
                result.add((Pair<Element, String>)new Pair((Object)library, (Object)name));
            }
            return result;
        }

        public void mergeStatesInto(Element target, Element[] elements) {
            for (Element e : elements) {
                target.addContent(e);
            }
        }
    }
}

