/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBus;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 1);

    public static void pushLanguageLevel(Project project) {
        PushedFilePropertiesUpdater.getInstance(project).pushAll(new JavaLanguageLevelPusher());
    }

    @Override
    public void initExtra(Project project, MessageBus bus, FilePropertyPusher.Engine languageLevelUpdater) {
    }

    @Override
    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key key = LanguageLevel.KEY;
        if (key == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/JavaLanguageLevelPusher.getFileDataKey must not return null");
        }
        return key;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return true;
    }

    @Override
    public LanguageLevel getDefaultValue() {
        return LanguageLevel.HIGHEST;
    }

    @Override
    public LanguageLevel getImmediateValue(Project project, VirtualFile file) {
        return null;
    }

    @Override
    public LanguageLevel getImmediateValue(Module module) {
        return LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    @Override
    public boolean acceptsFile(VirtualFile file) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAttribute(VirtualFile fileOrDir, LanguageLevel level) throws IOException {
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLevelOrdinal = iStream.readInt();
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        oStream.writeInt(level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !StdFileTypes.JAVA.equals(child.getFileType())) continue;
            FileBasedIndex.getInstance().requestReindex(child);
        }
    }

    @Override
    public void afterRootsChanged(Project project) {
    }
}

