/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ContentFolderBaseImpl
extends RootModelComponentBase
implements ContentFolder,
Comparable<ContentFolderBaseImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.SimpleContentFolderBaseImpl");
    private final VirtualFilePointer myFilePointer;
    protected final ContentEntryImpl myContentEntry;
    @NonNls
    public static final String URL_ATTRIBUTE = "url";

    ContentFolderBaseImpl(@NotNull VirtualFile file, @NotNull ContentEntryImpl contentEntry) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(file, (Disposable)this, contentEntry.getRootModel().myVirtualFilePointerListener);
    }

    ContentFolderBaseImpl(@NotNull String url, @NotNull ContentEntryImpl contentEntry) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, contentEntry.getRootModel().myVirtualFilePointerListener);
    }

    protected ContentFolderBaseImpl(@NotNull ContentFolderBaseImpl that, @NotNull ContentEntryImpl contentEntry) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        this(that.myFilePointer, contentEntry);
    }

    ContentFolderBaseImpl(@NotNull Element element, @NotNull ContentEntryImpl contentEntry) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        this(ContentFolderBaseImpl.getUrlFrom(element), contentEntry);
    }

    protected ContentFolderBaseImpl(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
        if (filePointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentFolderBaseImpl.<init> must not be null");
        }
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().duplicate(filePointer, (Disposable)this, contentEntry.getRootModel().myVirtualFilePointerListener);
    }

    private static String getUrlFrom(Element element) throws InvalidDataException {
        String url = element.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    public VirtualFile getFile() {
        VirtualFile file = this.myFilePointer.getFile();
        return file == null || !file.isDirectory() ? null : file;
    }

    @NotNull
    public ContentEntry getContentEntry() {
        ContentEntryImpl contentEntryImpl = this.myContentEntry;
        if (contentEntryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ContentFolderBaseImpl.getContentEntry must not return null");
        }
        return contentEntryImpl;
    }

    protected void writeFolder(Element element, String elementName) {
        LOG.assertTrue(element.getName().equals(elementName));
        element.setAttribute(URL_ATTRIBUTE, this.myFilePointer.getUrl());
    }

    @NotNull
    public String getUrl() {
        String string = this.myFilePointer.getUrl();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ContentFolderBaseImpl.getUrl must not return null");
        }
        return string;
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        return this.getUrl().compareTo(folder.getUrl());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContentFolderBaseImpl)) {
            return false;
        }
        return this.compareTo((ContentFolderBaseImpl)obj) == 0;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public String toString() {
        return this.myFilePointer == null ? null : this.getUrl();
    }
}

