/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.util.SystemProperties;
import org.jdom.Element;

@State(name="ProjectJdkTable", roamingType=RoamingType.DISABLED, storages={@Storage(id="other", file="$APP_CONFIG$/jdk.table.xml")})
public class JavaAwareProjectJdkTableImpl
extends ProjectJdkTableImpl {
    private final JavaSdk myJavaSdk;
    private Sdk myInternalJdk;

    public static JavaAwareProjectJdkTableImpl getInstanceEx() {
        return (JavaAwareProjectJdkTableImpl)((Object)ServiceManager.getService(ProjectJdkTable.class));
    }

    public JavaAwareProjectJdkTableImpl(JavaSdk javaSdk) {
        this.myJavaSdk = javaSdk;
    }

    public Sdk getInternalJdk() {
        if (this.myInternalJdk == null) {
            String jdkHome = SystemProperties.getJavaHome();
            String versionName = ProjectBundle.message((String)"sdk.java.name.template", (Object[])new Object[]{SystemProperties.getJavaVersion()});
            this.myInternalJdk = this.myJavaSdk.createJdk(versionName, jdkHome);
        }
        return this.myInternalJdk;
    }

    @Override
    public void removeJdk(Sdk jdk) {
        super.removeJdk(jdk);
        if (jdk.equals(this.myInternalJdk)) {
            this.myInternalJdk = null;
        }
    }

    @Override
    public SdkType getDefaultSdkType() {
        return this.myJavaSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(Element element) {
        this.myInternalJdk = null;
        try {
            super.loadState(element);
        }
        finally {
            this.getInternalJdk();
        }
    }

    @Override
    protected String getSdkTypeName(String type) {
        return type != null ? type : JavaSdk.getInstance().getName();
    }
}

