/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;

public class GenericDynamicContextProvider
implements DynamicContextProvider {
    @Override
    public int getOffset(PsiElement element, int offset, String elementText) {
        PsiElement[] children;
        for (PsiElement child : children = element.getChildren()) {
            if (!this.isDynamic(child)) continue;
            int i = child.getStartOffsetInParent();
            if (i == offset) {
                PsiElement next = child.getNextSibling();
                if (next == null || !next.getText().startsWith("/")) {
                    return -1;
                }
                offset = next.getStartOffsetInParent();
                continue;
            }
            int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
            if (pos == -1 || pos > i) {
                return -1;
            }
            return offset;
        }
        return offset;
    }

    protected boolean isDynamic(PsiElement child) {
        return child instanceof OuterLanguageElement;
    }
}

