/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurablesGroup
implements ConfigurableGroup {
    private Project myProject;
    private boolean myIncludeProjectStructure;
    private static final String PROJECT_STRUCTURE_CLASS_FQ_NAME = "com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable";

    public ProjectConfigurablesGroup(Project project) {
        this(project, true);
    }

    public ProjectConfigurablesGroup(Project project, boolean includeProjectStructure) {
        this.myProject = project;
        this.myIncludeProjectStructure = includeProjectStructure;
    }

    public String getDisplayName() {
        if (this.isDefault()) {
            return OptionsBundle.message((String)"template.project.settings.display.name", (Object[])new Object[0]);
        }
        return OptionsBundle.message((String)"project.settings.display.name", (Object[])new Object[]{this.myProject.getName()});
    }

    public String getShortName() {
        return this.isDefault() ? OptionsBundle.message((String)"template.project.settings.short.name", (Object[])new Object[0]) : OptionsBundle.message((String)"project.settings.short.name", (Object[])new Object[0]);
    }

    private boolean isDefault() {
        return this.myProject.isDefault();
    }

    public Configurable[] getConfigurables() {
        return ProjectConfigurablesGroup.getConfigurables(this.myProject, new ConfigurableFilter(){

            @Override
            public boolean isIncluded(Configurable configurable) {
                if (ProjectConfigurablesGroup.this.isDefault() && configurable instanceof NonDefaultProjectConfigurable) {
                    return false;
                }
                if (configurable instanceof Configurable.Assistant) {
                    return false;
                }
                if (configurable instanceof OptionalConfigurable && !((OptionalConfigurable)configurable).needDisplay()) {
                    return false;
                }
                return ProjectConfigurablesGroup.this.myIncludeProjectStructure || !ProjectConfigurablesGroup.PROJECT_STRUCTURE_CLASS_FQ_NAME.equals(configurable.getClass().getName());
            }
        });
    }

    private static Configurable[] getConfigurables(Project project, ConfigurableFilter filter) {
        Configurable[] extensions = (Configurable[])project.getExtensions(Configurable.PROJECT_CONFIGURABLES);
        Configurable[] components = (Configurable[])project.getComponents(Configurable.class);
        List<Configurable> result = ProjectConfigurablesGroup.buildConfigurablesList(extensions, components, filter);
        return result.toArray(new Configurable[result.size()]);
    }

    @Nullable
    public static Configurable getProjectStructureConfigurable(Project project) {
        Configurable[] configurables = ProjectConfigurablesGroup.getConfigurables(project, new ConfigurableFilter(){

            @Override
            public boolean isIncluded(Configurable configurable) {
                return ProjectConfigurablesGroup.PROJECT_STRUCTURE_CLASS_FQ_NAME.equals(configurable.getClass().getName());
            }
        });
        return configurables.length == 1 ? configurables[0] : null;
    }

    static List<Configurable> buildConfigurablesList(Configurable[] extensions, Configurable[] components, ConfigurableFilter filter) {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        result.addAll(Arrays.asList(extensions));
        result.addAll(Arrays.asList(components));
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Configurable each = (Configurable)iterator.next();
            if (filter.isIncluded(each)) continue;
            iterator.remove();
        }
        return result;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof ProjectConfigurablesGroup && ((ProjectConfigurablesGroup)object).myProject == this.myProject;
    }
}

