/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.http.LocalFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JumpFromRemoteFileToLocalAction
extends AnAction {
    private HttpVirtualFile myFile;
    private final Project myProject;

    public JumpFromRemoteFileToLocalAction(HttpVirtualFile file, Project project) {
        super("Find Local File", "", IconLoader.findIcon((String)"/general/autoscrollToSource.png"));
        this.myFile = file;
        this.myProject = project;
    }

    public void update(AnActionEvent e) {
        RemoteFileState state = this.myFile.getFileInfo().getState();
        e.getPresentation().setEnabled(state == RemoteFileState.DOWNLOADED);
    }

    public void actionPerformed(AnActionEvent e) {
        String fileName;
        String url = this.myFile.getUrl();
        Collection<VirtualFile> files = JumpFromRemoteFileToLocalAction.findLocalFiles(this.myProject, url, fileName = this.myFile.getName());
        if (files.isEmpty()) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Cannot find local file for '" + url + "'"), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (files.size() == 1) {
            JumpFromRemoteFileToLocalAction.navigateToFile(this.myProject, (VirtualFile)ContainerUtil.getFirstItem(files, null));
        } else {
            final JList<VirtualFile> list = new JList<VirtualFile>(files.toArray(new VirtualFile[files.size()]));
            list.setCellRenderer((ListCellRenderer<VirtualFile>)new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    CellAppearanceUtils.forVirtualFile((VirtualFile)((VirtualFile)value)).customize((SimpleColoredComponent)this);
                }
            });
            new PopupChooserBuilder(list).setTitle("Select Target File").setMovable(true).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    for (Object value : list.getSelectedValues()) {
                        JumpFromRemoteFileToLocalAction.navigateToFile(JumpFromRemoteFileToLocalAction.this.myProject, (VirtualFile)value);
                    }
                }
            }).createPopup().showUnderneathOf(e.getInputEvent().getComponent());
        }
    }

    public static Collection<VirtualFile> findLocalFiles(Project project, String url, String fileName) {
        for (LocalFileFinder finder : (LocalFileFinder[])LocalFileFinder.EP_NAME.getExtensions()) {
            VirtualFile file = finder.findLocalFile(url, project);
            if (file == null) continue;
            return Collections.singletonList(file);
        }
        return FilenameIndex.getVirtualFilesByName(project, fileName, GlobalSearchScope.allScope((Project)project));
    }

    private static void navigateToFile(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/JumpFromRemoteFileToLocalAction.navigateToFile must not be null");
        }
        new OpenFileDescriptor(project, file).navigate(true);
    }
}

