/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpFileEditor
implements TextEditor {
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final RemoteFilePanel myPanel;
    private Editor myMockTextEditor;
    private final Project myProject;

    public HttpFileEditor(Project project, HttpVirtualFile virtualFile) {
        this.myProject = project;
        this.myPanel = new RemoteFilePanel(project, virtualFile);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel.getMainPanel();
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getComponent must not return null");
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getPreferredFocusedComponent();
        }
        return this.myPanel.getMainPanel();
    }

    @NotNull
    public String getName() {
        if ("Http" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getName must not return null");
        }
        return "Http";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Editor getEditor() {
        Editor editor;
        TextEditor fileEditor = this.myPanel.getFileEditor();
        if (fileEditor != null) {
            editor = fileEditor.getEditor();
            if (editor == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getEditor must not return null");
            return editor;
        }
        if (this.myMockTextEditor == null) {
            this.myMockTextEditor = EditorFactory.getInstance().createViewer((Document)new DocumentImpl(""), this.myProject);
        }
        if ((editor = this.myMockTextEditor) != null) return editor;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getEditor must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        FileEditorState fileEditorState;
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getState must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            fileEditorState = textEditor.getState(level);
            if (fileEditorState == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getState must not return null");
            return fileEditorState;
        }
        fileEditorState = new TextEditorState();
        if (fileEditorState != null) return fileEditorState;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getState must not return null");
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.setState must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            textEditor.setState(state);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPanel.selectNotify();
    }

    public void deselectNotify() {
        this.myPanel.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.addPropertyChangeListener must not be null");
        }
        this.myPanel.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.removePropertyChangeListener must not be null");
        }
        this.myPanel.removePropertyChangeListener(listener);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getBackgroundHighlighter();
        }
        return null;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.canNavigateTo must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.canNavigateTo(navigatable);
        }
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.navigateTo must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            textEditor.navigateTo(navigatable);
        }
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.getUserData must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return (T)textEditor.getUserData(key);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/http/HttpFileEditor.putUserData must not be null");
        }
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            textEditor.putUserData(key, value);
        } else {
            this.myUserDataHolder.putUserData(key, value);
        }
    }

    public FileEditorLocation getCurrentLocation() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getCurrentLocation();
        }
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getStructureViewBuilder();
        }
        return null;
    }

    public void dispose() {
        if (this.myMockTextEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myMockTextEditor);
        }
        this.myPanel.dispose();
    }
}

