/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindow {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWindow");
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create((String)"editorWindow");
    protected JPanel myPanel;
    private EditorTabbedContainer myTabbedPane;
    private final EditorsSplitters myOwner;
    private static final Icon MODIFIED_ICON = IconLoader.getIcon((String)"/general/modified.png");
    private static final Icon GAP_ICON = new EmptyIcon(MODIFIED_ICON.getIconWidth(), MODIFIED_ICON.getIconHeight());
    private boolean myIsDisposed = false;
    private static final Icon PIN_ICON = IconLoader.getIcon((String)"/nodes/tabPin.png");
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create((String)"initial editor index");

    protected EditorWindow(EditorsSplitters owner) {
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myTabbedPane = null;
        int tabPlacement = UISettings.getInstance().EDITOR_TAB_PLACEMENT;
        if (tabPlacement != 0) {
            this.createTabs(tabPlacement);
        }
        if (UISettings.getInstance().SCROLL_TAB_LAYOUT_IN_EDITOR) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.getWindows().add(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void createTabs(int tabPlacement) {
        LOG.assertTrue(this.myTabbedPane == null);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject(), tabPlacement);
        this.myPanel.add(this.myTabbedPane.getComponent(), "Center");
    }

    private Set<EditorWindow> getWindows() {
        return this.myOwner.myWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        try {
            this.disposeTabs();
            this.getWindows().remove(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void disposeTabs() {
        if (this.myTabbedPane != null) {
            Disposer.dispose((Disposable)this.myTabbedPane);
            this.myTabbedPane = null;
        }
        this.myPanel.removeAll();
        this.myPanel.revalidate();
    }

    public void closeFile(VirtualFile file) {
        this.closeFile(file, true);
    }

    public void closeFile(VirtualFile file, boolean unsplit) {
        this.closeFile(file, unsplit, true);
    }

    public void closeFile(final VirtualFile file, final boolean unsplit, final boolean transferFocus) {
        final FileEditorManagerImpl editorManager = this.getManager();
        editorManager.runChange(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<EditorWithProviderComposite> editors = editorManager.getEditorComposites(file);
                    if (editors.isEmpty()) {
                        return;
                    }
                    final EditorWithProviderComposite editor = EditorWindow.this.findFileComposite(file);
                    FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                    beforePublisher.beforeFileClosed((FileEditorManager)editorManager, file);
                    if (EditorWindow.this.myTabbedPane != null) {
                        int componentIndex = EditorWindow.this.findComponentIndex(editor.getComponent());
                        if (componentIndex >= 0) {
                            int indexToSelect = EditorWindow.this.calcIndexToSelect(file, componentIndex);
                            EditorWindow.this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus).doWhenDone(new Runnable(){

                                @Override
                                public void run() {
                                    editorManager.disposeComposite(editor);
                                }
                            });
                        }
                    } else {
                        EditorWindow.this.myPanel.removeAll();
                        editorManager.disposeComposite(editor);
                    }
                    if (unsplit && EditorWindow.this.getTabCount() == 0) {
                        EditorWindow.this.unsplit(true);
                    }
                    EditorWindow.this.myPanel.revalidate();
                    if (EditorWindow.this.myTabbedPane == null) {
                        EditorWindow.this.myPanel.repaint();
                    }
                }
                finally {
                    FileEditorManagerListener afterPublisher = (FileEditorManagerListener)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                    afterPublisher.fileClosed((FileEditorManager)editorManager, file);
                }
            }
        });
    }

    private int calcIndexToSelect(VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex = this.myTabbedPane.getSelectedIndex();
        if (currentlySelectedIndex != fileIndex) {
            return currentlySelectedIndex;
        }
        if (UISettings.getInstance().ACTIVATE_MRU_EDITOR_ON_CLOSE) {
            VirtualFile[] histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFiles();
            for (int idx = histFiles.length - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles[idx];
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    public FileEditorManagerImpl getManager() {
        return this.myOwner.getManager();
    }

    public int getTabCount() {
        if (this.myTabbedPane != null) {
            return this.myTabbedPane.getTabCount();
        }
        return this.myPanel.getComponentCount();
    }

    public void setForegroundAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setForegroundAt(index, color);
        }
    }

    public void setWaveColor(int index, @Nullable Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setWaveColor(index, color);
        }
    }

    private void setIconAt(int index, Icon icon) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setIconAt(index, icon);
        }
    }

    private void setTitleAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTitleAt(index, text);
        }
    }

    private void setBackgroundColorAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setBackgroundColorAt(index, color);
        }
    }

    private void setToolTipTextAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setToolTipTextAt(index, text);
        }
    }

    public void setTabLayoutPolicy(int policy) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTabLayoutPolicy(policy);
        }
    }

    public void setTabsPlacement(int tabPlacement) {
        if (tabPlacement != 0) {
            if (this.myTabbedPane == null) {
                EditorWithProviderComposite editor = this.getSelectedEditor();
                this.myPanel.removeAll();
                this.createTabs(tabPlacement);
                this.setEditor(editor, true);
            } else {
                this.myTabbedPane.setTabPlacement(tabPlacement);
            }
        } else if (this.myTabbedPane != null) {
            VirtualFile[] files;
            boolean focusEditor = ToolWindowManager.getInstance((Project)this.getManager().getProject()).isEditorComponentActive();
            VirtualFile currentFile = this.getSelectedFile();
            for (VirtualFile file : files = this.getFiles()) {
                this.closeFile(file, false);
            }
            this.disposeTabs();
            if (currentFile != null) {
                this.getManager().openFileImpl2(this, currentFile, focusEditor && this.myOwner.getCurrentWindow() == this, null);
            } else {
                this.myPanel.repaint();
            }
        }
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    public void updateFileBackgroundColor(VirtualFile file) {
        int index = this.findEditorIndex(this.findFileComposite(file));
        if (index != -1) {
            Color color = EditorTabbedContainer.calcTabColor(this.getManager().getProject(), file);
            this.setBackgroundColorAt(index, color);
        }
    }

    private void checkConsistency() {
        LOG.assertTrue(this.getWindows().contains(this), (Object)"EditorWindow not in collection");
    }

    public EditorWithProviderComposite getSelectedEditor() {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)this.myTabbedPane.getSelectedComponent();
        } else if (this.myPanel.getComponentCount() != 0) {
            Component component = this.myPanel.getComponent(0);
            comp = component instanceof TComp ? (TComp)component : null;
        } else {
            return null;
        }
        if (comp != null) {
            return comp.myEditor;
        }
        return null;
    }

    public EditorWithProviderComposite[] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res = new EditorWithProviderComposite[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res[i] = this.getEditorAt(i);
        }
        return res;
    }

    public VirtualFile[] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res = new VirtualFile[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res[i] = this.getEditorAt(i).getFile();
        }
        return res;
    }

    public void setSelectedEditor(EditorComposite editor, boolean focusEditor) {
        int index;
        if (this.myTabbedPane == null) {
            return;
        }
        if (editor != null && (index = this.findFileIndex(editor.getFile())) != -1) {
            this.myTabbedPane.setSelectedIndex(index, focusEditor);
        }
    }

    public void setEditor(EditorWithProviderComposite editor, boolean focusEditor) {
        if (editor != null) {
            if (this.myTabbedPane == null) {
                this.myPanel.removeAll();
                this.myPanel.add((Component)new TCompForTablessMode(this, editor), "Center");
                this.myPanel.revalidate();
                return;
            }
            int index = this.findEditorIndex(editor);
            if (index != -1) {
                this.setSelectedEditor(editor, focusEditor);
            } else {
                Integer initialIndex = (Integer)editor.getFile().getUserData(INITIAL_INDEX_KEY);
                int indexToInsert = initialIndex == null ? this.myTabbedPane.getSelectedIndex() + 1 : initialIndex;
                VirtualFile file = editor.getFile();
                Icon template = IconLoader.getIcon((String)"/fileTypes/text.png");
                this.myTabbedPane.insertTab(file, (Icon)new EmptyIcon(template.getIconWidth(), template.getIconHeight()), new TComp(editor), null, indexToInsert);
                this.trimToSize(UISettings.getInstance().EDITOR_TAB_LIMIT, file, false);
                this.setSelectedEditor(editor, focusEditor);
                this.myOwner.updateFileIcon(file);
                this.myOwner.updateFileColor(file);
            }
            this.myOwner.setCurrentWindow(this, false);
        }
        this.myPanel.revalidate();
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    public void split(int orientation) {
        this.checkConsistency();
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (this.splitAvailable()) {
            JPanel panel = this.myPanel;
            int tabCount = this.getTabCount();
            if (tabCount != 0) {
                EditorWithProviderComposite firstEC = this.getEditorAt(0);
                this.myPanel = new JPanel(new BorderLayout());
                Splitter splitter = new Splitter(orientation == 0, 0.5f, 0.1f, 0.9f);
                EditorWindow res = new EditorWindow(this.myOwner);
                if (this.myTabbedPane != null) {
                    EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
                    panel.remove(this.myTabbedPane.getComponent());
                    panel.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    this.myPanel.add(this.myTabbedPane.getComponent(), "Center");
                    splitter.setSecondComponent((JComponent)res.myPanel);
                    VirtualFile file = selectedEditor.getFile();
                    fileEditorManager.openFileImpl3(res, file, false, null, true);
                    res.setFilePinned(file, this.isFilePinned(file));
                    res.setSelectedEditor(selectedEditor, true);
                    selectedEditor.getComponent().requestFocus();
                    panel.revalidate();
                } else {
                    panel.removeAll();
                    panel.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    splitter.setSecondComponent((JComponent)res.myPanel);
                    panel.revalidate();
                    VirtualFile file = firstEC.getFile();
                    fileEditorManager.openFileImpl3(this, file, true, null, true);
                    fileEditorManager.openFileImpl3(res, file, false, null, true);
                }
            }
        }
    }

    public EditorWindow[] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, (Component)splitter)) continue;
                res.add(win);
            }
        }
        return res.toArray(new EditorWindow[res.size()]);
    }

    public void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    protected void updateFileIcon(VirtualFile file) {
        int index = this.findEditorIndex(this.findFileComposite(file));
        LOG.assertTrue(index != -1);
        this.setIconAt(index, this.getFileIcon(file));
    }

    protected void updateFileName(VirtualFile file) {
        int index = this.findEditorIndex(this.findFileComposite(file));
        if (index != -1) {
            this.setTitleAt(index, EditorTabbedContainer.calcTabTitle(this.getManager().getProject(), file));
            this.setToolTipTextAt(index, this.getManager().getFileTooltipText(file));
        }
    }

    private Icon getFileIcon(@NotNull VirtualFile file) {
        Icon modifiedIcon;
        Icon pinIcon;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorWindow.getFileIcon must not be null");
        }
        if (!file.isValid()) {
            Icon fakeIcon = FileTypes.UNKNOWN.getIcon();
            assert (fakeIcon != null) : "Can't find the icon for unknown file type";
            return fakeIcon;
        }
        Icon baseIcon = IconUtil.getIcon((VirtualFile)file, (int)2, (Project)this.getManager().getProject());
        int count = 1;
        EditorWithProviderComposite composite = this.findFileComposite(file);
        if (composite != null && composite.isPinned()) {
            ++count;
            pinIcon = PIN_ICON;
        } else {
            pinIcon = null;
        }
        if (UISettings.getInstance().MARK_MODIFIED_TABS_WITH_ASTERISK) {
            modifiedIcon = composite != null && ((EditorComposite)composite).isModified() ? MODIFIED_ICON : GAP_ICON;
            ++count;
        } else {
            modifiedIcon = null;
        }
        if (count == 1) {
            return baseIcon;
        }
        int i = 0;
        LayeredIcon result = new LayeredIcon(count);
        result.setIcon(baseIcon, i++);
        if (pinIcon != null) {
            result.setIcon(pinIcon, i++);
        }
        if (modifiedIcon != null) {
            result.setIcon(modifiedIcon, i++);
        }
        return result;
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected = eachSibling.getSelectedEditor();
            if (editorToSelect != null) continue;
            editorToSelect = selected;
        }
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        if (this.myTabbedPane != null) {
            parent.add(this.myTabbedPane.getComponent(), "Center");
        } else if (this.myPanel.getComponentCount() > 0) {
            parent.add(this.myPanel.getComponent(0), "Center");
        }
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(EditorWithProviderComposite siblingEditor) {
        if (this.myTabbedPane != null && this.getTabCount() < UISettings.getInstance().EDITOR_TAB_LIMIT && this.findFileComposite(siblingEditor.getFile()) == null) {
            this.setEditor(siblingEditor, true);
        } else if (this.myTabbedPane == null && this.getTabCount() == 0) {
            this.setEditor(siblingEditor, true);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    public void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    public EditorWithProviderComposite findFileComposite(VirtualFile file) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getFile().equals(file)) continue;
            return editor;
        }
        return null;
    }

    public int findComponentIndex(Component component) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getComponent().equals(component)) continue;
            return i;
        }
        return -1;
    }

    public int findEditorIndex(EditorComposite editorToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.equals(editorToFind)) continue;
            return i;
        }
        return -1;
    }

    public int findFileIndex(VirtualFile fileToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            VirtualFile file = this.getFileAt(i);
            if (!file.equals(fileToFind)) continue;
            return i;
        }
        return -1;
    }

    private EditorWithProviderComposite getEditorAt(int i) {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)this.myTabbedPane.getComponentAt(i);
        } else {
            LOG.assertTrue(i <= 1);
            comp = (TComp)this.myPanel.getComponent(i);
        }
        return comp.myEditor;
    }

    public boolean isFileOpen(VirtualFile file) {
        return this.findFileComposite(file) != null;
    }

    public boolean isFilePinned(VirtualFile file) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFileOpen(file)) {
            throw new IllegalArgumentException("file is not open: " + file.getPath());
        }
        EditorWithProviderComposite editorComposite = this.findFileComposite(file);
        return editorComposite.isPinned();
    }

    public void setFilePinned(VirtualFile file, boolean pinned) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFileOpen(file)) {
            throw new IllegalArgumentException("file is not open: " + file.getPath());
        }
        EditorWithProviderComposite editorComposite = this.findFileComposite(file);
        editorComposite.setPinned(pinned);
        this.updateFileIcon(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trimToSize(int limit, VirtualFile fileToIgnore, boolean transferFocus) {
        if (this.myTabbedPane == null) {
            return;
        }
        boolean closeNonModifiedFilesFirst = UISettings.getInstance().CLOSE_NON_MODIFIED_FILES_FIRST;
        EditorWithProviderComposite selectedComposite = this.getSelectedEditor();
        try {
            this.doTrimSize(limit, fileToIgnore, closeNonModifiedFilesFirst, transferFocus);
        }
        finally {
            this.setSelectedEditor(selectedComposite, false);
        }
    }

    private void doTrimSize(int limit, VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        block0: while (this.myTabbedPane.getTabCount() > limit && this.myTabbedPane.getTabCount() > 0) {
            VirtualFile[] histFiles;
            VirtualFile[] allFiles;
            boolean allTabsArePinned = true;
            for (int i = this.myTabbedPane.getTabCount() - 1; i >= 0; --i) {
                VirtualFile file = this.getFileAt(i);
                if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
                allTabsArePinned = false;
                break;
            }
            if (allTabsArePinned) {
                return;
            }
            if (closeNonModifiedFilesFirst) {
                allFiles = this.getFiles();
                histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFiles();
                for (int i = 0; i != allFiles.length; ++i) {
                    VirtualFile file = allFiles[i];
                    if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
                    boolean found = false;
                    for (int j = 0; j != histFiles.length; ++j) {
                        if (histFiles[j] != file) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.defaultCloseFile(file, transferFocus);
                    continue block0;
                }
                for (VirtualFile file : histFiles) {
                    EditorWithProviderComposite composite;
                    if (!this.fileCanBeClosed(file, fileToIgnore) || (composite = this.findFileComposite(file)) == null || composite.getInitialFileTimeStamp() != file.getTimeStamp()) continue;
                    this.defaultCloseFile(file, transferFocus);
                    continue block0;
                }
                VirtualFile selectedFile = this.getSelectedFile();
                for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                    VirtualFile file = this.getFileAt(i);
                    EditorWithProviderComposite composite = this.getEditorAt(i);
                    if (!this.fileCanBeClosed(file, fileToIgnore) || selectedFile.equals(file) || composite.getInitialFileTimeStamp() != file.getTimeStamp()) continue;
                    this.defaultCloseFile(file, transferFocus);
                    continue block0;
                }
            }
            allFiles = this.getFiles();
            histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFiles();
            for (int i = 0; i != allFiles.length; ++i) {
                VirtualFile file = allFiles[i];
                if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
                boolean found = false;
                for (int j = 0; j != histFiles.length; ++j) {
                    if (histFiles[j] != file) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.defaultCloseFile(file, transferFocus);
                continue block0;
            }
            for (VirtualFile file : histFiles) {
                if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
                this.defaultCloseFile(file, transferFocus);
                continue block0;
            }
            VirtualFile selectedFile = this.getSelectedFile();
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                VirtualFile file = this.getFileAt(i);
                if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
                if (!selectedFile.equals(file)) {
                    this.defaultCloseFile(file, transferFocus);
                    continue block0;
                }
                if (i != this.myTabbedPane.getTabCount() - 1) continue;
                this.defaultCloseFile(file, transferFocus);
                continue block0;
            }
        }
    }

    private void defaultCloseFile(VirtualFile file, boolean transferFocus) {
        this.closeFile(file, true, transferFocus);
    }

    private boolean fileCanBeClosed(VirtualFile file, VirtualFile fileToIgnore) {
        return this.isFileOpen(file) && !file.equals(fileToIgnore) && !this.isFilePinned(file);
    }

    protected VirtualFile getFileAt(int i) {
        return this.getEditorAt(i).getFile();
    }

    protected static class TCompForTablessMode
    extends TComp {
        private final EditorWindow myWindow;

        TCompForTablessMode(EditorWindow window, EditorWithProviderComposite editor) {
            super(editor);
            this.myWindow = window;
        }

        @Override
        public Object getData(String dataId) {
            if (DATA_KEY.is(dataId)) {
                return this.myWindow;
            }
            return super.getData(dataId);
        }
    }

    protected static class TComp
    extends JPanel
    implements DataProvider {
        final EditorWithProviderComposite myEditor;

        TComp(EditorWithProviderComposite editor) {
            super(new BorderLayout());
            this.myEditor = editor;
            this.add((Component)editor.getComponent(), "Center");
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile = this.myEditor.getFile();
                return virtualFile.isValid() ? virtualFile : null;
            }
            if (PlatformDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }
    }
}

