/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorTabbedContainer
implements Disposable {
    private final EditorWindow myWindow;
    private final Project myProject;
    private final JBTabs myTabs;
    @NonNls
    public static final String HELP_ID = "ideaInterface.editor";

    EditorTabbedContainer(EditorWindow window, Project project, int tabPlacement) {
        this.myWindow = window;
        this.myProject = project;
        ActionManager actionManager = ActionManager.getInstance();
        this.myTabs = new JBTabsImpl(project, actionManager, IdeFocusManager.getInstance((Project)project), (Disposable)this);
        this.myTabs.setDataProvider((DataProvider)new MyDataProvider()).setPopupGroup((Getter)new Getter<ActionGroup>(){

            public ActionGroup get() {
                return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorTabPopupMenu");
            }
        }, "EditorPopup", false).setNavigationActionsEnabled(false).addTabMouseListener((MouseListener)new TabMouseListener()).getPresentation().setTabDraggingEnabled(true).setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(1, 6, 1, 6));
                if (uiDecoration == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$2.getDecoration must not return null");
                }
                return uiDecoration;
            }
        }).setTabLabelActionsMouseDeadzone(TimedDeadzone.NULL).setGhostsAlwaysVisible(true).setTabLabelActionsAutoHide(false).setActiveTabFillIn(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()).setPaintFocus(false).getJBTabs().addListener((TabsListener)new TabsListener.Adapter(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                FileEditor newEditor;
                FileEditor oldEditor;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)EditorTabbedContainer.this.myProject);
                FileEditor fileEditor = oldEditor = oldSelection != null ? editorManager.getSelectedEditor((VirtualFile)oldSelection.getObject()) : null;
                if (oldEditor != null) {
                    oldEditor.deselectNotify();
                }
                if ((newEditor = editorManager.getSelectedEditor((VirtualFile)newSelection.getObject())) != null) {
                    newEditor.selectNotify();
                }
            }
        });
        this.setTabPlacement(UISettings.getInstance().EDITOR_TAB_PLACEMENT);
        this.updateTabBorder();
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener(new ToolWindowManagerAdapter(){

            @Override
            public void stateChanged() {
                EditorTabbedContainer.this.updateTabBorder();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$4.toolWindowRegistered must not be null");
                }
                EditorTabbedContainer.this.updateTabBorder();
            }
        });
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    public ActionCallback setSelectedIndex(int indexToSelect) {
        return this.setSelectedIndex(indexToSelect, true);
    }

    public ActionCallback setSelectedIndex(int indexToSelect, boolean focusEditor) {
        return this.myTabs.select(this.myTabs.getTabAt(indexToSelect), focusEditor);
    }

    private void updateTabBorder() {
        if (!this.myProject.isOpen()) {
            return;
        }
        this.myTabs.getComponent().setBorder(new EmptyBorder(1, 0, 0, 0));
        List<String> rightIds = ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).getIdsOn(ToolWindowAnchor.RIGHT);
        this.myTabs.getPresentation().setPaintBorder(-1, -1, rightIds.size() > 0 ? 1 : 0, -1).setTabSidePaintBorder(5);
    }

    public Component getComponent() {
        return this.myTabs.getComponent();
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect, boolean transferFocus) {
        TabInfo toSelect = indexToSelect >= 0 && indexToSelect < this.myTabs.getTabCount() ? this.myTabs.getTabAt(indexToSelect) : null;
        ActionCallback callback = this.myTabs.removeTab(this.myTabs.getTabAt(componentIndex), toSelect, transferFocus);
        return this.myProject.isOpen() ? callback : new ActionCallback.Done();
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect) {
        return this.removeTabAt(componentIndex, indexToSelect, true);
    }

    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    public void setForegroundAt(int index, Color color) {
        this.myTabs.getTabAt(index).setDefaultForeground(color);
    }

    public void setWaveColor(int index, @Nullable Color color) {
        TabInfo tab = this.myTabs.getTabAt(index);
        tab.setDefaultStyle(color == null ? 0 : 8);
        tab.setDefaultWaveColor(color);
    }

    public void setIconAt(int index, Icon icon) {
        this.myTabs.getTabAt(index).setIcon(icon);
    }

    public void setTitleAt(int index, String text) {
        this.myTabs.getTabAt(index).setText(text);
    }

    public void setToolTipTextAt(int index, String text) {
        this.myTabs.getTabAt(index).setTooltipText(text);
    }

    public void setBackgroundColorAt(int index, Color color) {
        this.myTabs.getTabAt(index).setTabColor(color);
    }

    public void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    public void setTabPlacement(int tabPlacement) {
        switch (tabPlacement) {
            case 1: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tab placement code=" + tabPlacement);
            }
        }
    }

    @Nullable
    public Object getSelectedComponent() {
        TabInfo info = this.myTabs.getTargetInfo();
        return info != null ? info.getComponent() : null;
    }

    public void insertTab(VirtualFile file, Icon icon, JComponent comp, String tooltip, int indexToInsert) {
        TabInfo tab = this.myTabs.findInfo((Object)file);
        if (tab != null) {
            return;
        }
        tab = new TabInfo(comp).setText(EditorTabbedContainer.calcTabTitle(this.myProject, file)).setIcon(icon).setTooltipText(tooltip).setObject((Object)file).setTabColor(EditorTabbedContainer.calcTabColor(this.myProject, file));
        tab.setTestableUi((Queryable)new MyQueryable(tab));
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTab(comp, tab));
        tab.setTabLabelActions((ActionGroup)tabActions, "EditorTab");
        this.myTabs.addTab(tab, indexToInsert);
    }

    public static String calcTabTitle(Project project, VirtualFile file) {
        for (EditorTabTitleProvider provider : (EditorTabTitleProvider[])Extensions.getExtensions(EditorTabTitleProvider.EP_NAME)) {
            String result = provider.getEditorTabTitle(project, file);
            if (result == null) continue;
            return result;
        }
        return file.getPresentableName();
    }

    public static Color calcTabColor(Project project, VirtualFile file) {
        for (EditorTabColorProvider provider : (EditorTabColorProvider[])Extensions.getExtensions(EditorTabColorProvider.EP_NAME)) {
            Color result = provider.getEditorTabColor(project, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Component getComponentAt(int i) {
        TabInfo tab = this.myTabs.getTabAt(i);
        return tab.getComponent();
    }

    public void dispose() {
    }

    private class TabMouseListener
    extends MouseAdapter {
        private TabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TabInfo info;
            if (UIUtil.isCloseClick((MouseEvent)e, (int)501) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null) {
                IdeEventQueue.getInstance().blockNextEvents(e);
                EditorTabbedContainer.this.myWindow.closeFile((VirtualFile)info.getObject());
                return;
            }
            if (UIUtil.isActionClick((MouseEvent)e) && e.getClickCount() % 2 == 0) {
                ActionManager mgr = ActionManager.getInstance();
                mgr.tryToExecute(mgr.getAction("HideAllWindows"), (InputEvent)e, null, "unknown", true);
            } else if (UIUtil.isActionClick((MouseEvent)e) && (e.isMetaDown() || !SystemInfo.isMac && e.isControlDown()) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null && info.getObject() != null) {
                VirtualFile vFile = (VirtualFile)info.getObject();
                ShowFilePathAction.show(vFile, e);
            }
        }
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PROJECT.is(dataId)) {
                return EditorTabbedContainer.this.myProject;
            }
            if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile selectedFile = EditorTabbedContainer.this.myWindow.getSelectedFile();
                return selectedFile != null && selectedFile.isValid() ? selectedFile : null;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return EditorTabbedContainer.HELP_ID;
            }
            return null;
        }
    }

    private class CloseTab
    extends AnAction
    implements DumbAware {
        ShadowAction myShadow;
        private final TabInfo myTabInfo;
        private final Icon myIcon = IconLoader.getIcon((String)"/actions/close.png");
        private final Icon myHoveredIcon = IconLoader.getIcon((String)"/actions/closeHovered.png");

        public CloseTab(JComponent c, TabInfo info) {
            this.myTabInfo = info;
            this.myShadow = new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("CloseEditor"), c);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(this.myIcon);
            e.getPresentation().setHoveredIcon(this.myHoveredIcon);
            e.getPresentation().setVisible(UISettings.getInstance().SHOW_CLOSE_BUTTON);
        }

        public void actionPerformed(AnActionEvent e) {
            FileEditorManagerEx mgr = FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject);
            VirtualFile file = (VirtualFile)this.myTabInfo.getObject();
            EditorWindow window = "EditorTab".equals(e.getPlace()) ? EditorTabbedContainer.this.myWindow : mgr.getCurrentWindow();
            if (window != null && window.findFileComposite(file) != null) {
                mgr.closeFile(file, window);
            }
        }
    }

    private class MyQueryable
    implements Queryable {
        private TabInfo myTab;

        public MyQueryable(TabInfo tab) {
            this.myTab = tab;
        }

        public void putInfo(Map<String, String> info) {
            info.put("editorTab", this.myTab.getText());
        }
    }
}

