/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocalFsFinder
implements FileLookup.Finder,
FileLookup {
    @Override
    public FileLookup.LookupFile find(@NotNull String path) {
        File file;
        File[] roots;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileChooser/ex/LocalFsFinder.find must not be null");
        }
        VirtualFile byUrl = VirtualFileManager.getInstance().findFileByUrl(path);
        if (byUrl != null) {
            return this.getLookupFile(path, byUrl);
        }
        String toFind = this.normalize(path);
        if (toFind.length() == 0 && (roots = File.listRoots()).length > 0) {
            toFind = roots[0].getAbsolutePath();
        }
        return (file = new File(toFind)).isAbsolute() ? this.getLookupFile(path, LocalFileSystem.getInstance().findFileByIoFile(file)) : null;
    }

    private FileLookup.LookupFile getLookupFile(String path, VirtualFile vFile) {
        return vFile != null ? new VfsFile(this, vFile) : new IoFile(new File(path));
    }

    @Override
    public String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileChooser/ex/LocalFsFinder.normalize must not be null");
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(System.getProperty("user.home"), path).getAbsolutePath();
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    public static class IoFile
    extends VfsFile {
        private final File myIoFile;

        public IoFile(File ioFile) {
            super(null, null);
            this.myIoFile = ioFile;
        }

        @Override
        public String getName() {
            return this.myIoFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.myIoFile != null ? this.myIoFile.isDirectory() : false;
        }

        @Override
        public FileLookup.LookupFile getParent() {
            return this.myIoFile != null && this.myIoFile.getParentFile() != null ? new IoFile(this.myIoFile.getParentFile()) : null;
        }

        @Override
        public String getAbsolutePath() {
            return this.myIoFile.getAbsolutePath();
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(final FileLookup.LookupFilter filter) {
            ArrayList<FileLookup.LookupFile> result = new ArrayList<FileLookup.LookupFile>();
            File[] files = this.myIoFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return filter.isAccepted(new IoFile(pathname));
                }
            });
            if (files == null) {
                return result;
            }
            for (File each : files) {
                result.add(new IoFile(each));
            }
            Collections.sort(result, new Comparator<FileLookup.LookupFile>(){

                @Override
                public int compare(FileLookup.LookupFile o1, FileLookup.LookupFile o2) {
                    return FileUtil.comparePaths((String)o1.getName(), (String)o2.getName());
                }
            });
            return result;
        }

        @Override
        public boolean exists() {
            return this.myIoFile.exists();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IoFile ioFile = (IoFile)o;
            return !(this.myIoFile != null ? !this.myIoFile.equals(ioFile.myIoFile) : ioFile.myIoFile != null);
        }

        @Override
        public int hashCode() {
            return this.myIoFile != null ? this.myIoFile.hashCode() : 0;
        }
    }

    public static class VfsFile
    implements FileLookup.LookupFile {
        private final VirtualFile myFile;
        private final LocalFsFinder myFinder;
        private String myMacro;

        public VfsFile(LocalFsFinder finder, VirtualFile file) {
            this.myFinder = finder;
            this.myFile = file;
        }

        @Override
        public String getName() {
            if (this.myFile.getParent() == null && this.myFile.getName().length() == 0) {
                return "/";
            }
            return this.myFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.myFile != null ? this.myFile.isDirectory() : false;
        }

        @Override
        public void setMacro(String macro) {
            this.myMacro = macro;
        }

        @Override
        public String getMacro() {
            return this.myMacro;
        }

        @Override
        public FileLookup.LookupFile getParent() {
            return this.myFile != null && this.myFile.getParent() != null ? new VfsFile(this.myFinder, this.myFile.getParent()) : null;
        }

        @Override
        public String getAbsolutePath() {
            if (this.myFile.getParent() == null && this.myFile.getName().length() == 0) {
                return "/";
            }
            return this.myFile.getPresentableUrl();
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter) {
            VirtualFile[] kids;
            ArrayList<FileLookup.LookupFile> result = new ArrayList<FileLookup.LookupFile>();
            if (this.myFile == null) {
                return result;
            }
            for (VirtualFile each : kids = this.myFile.getChildren()) {
                FileLookup.LookupFile eachFile = this.myFinder.getLookupFile(each.getPath(), each);
                if (eachFile == null || !filter.isAccepted(eachFile)) continue;
                result.add(eachFile);
            }
            Collections.sort(result, new Comparator<FileLookup.LookupFile>(){

                @Override
                public int compare(FileLookup.LookupFile o1, FileLookup.LookupFile o2) {
                    return FileUtil.comparePaths((String)o1.getName(), (String)o2.getName());
                }
            });
            return result;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Override
        public boolean exists() {
            return this.myFile.exists();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VfsFile vfsFile = (VfsFile)o;
            return !(this.myFile != null ? !this.myFile.equals(vfsFile.myFile) : vfsFile.myFile != null);
        }

        public int hashCode() {
            return this.myFile != null ? this.myFile.hashCode() : 0;
        }
    }

    public static class FileChooserFilter
    implements FileLookup.LookupFilter {
        private final FileChooserDescriptor myDescriptor;
        private final boolean myShowHidden;

        public FileChooserFilter(FileChooserDescriptor descriptor, boolean showHidden) {
            this.myDescriptor = descriptor;
            this.myShowHidden = showHidden;
        }

        @Override
        public boolean isAccepted(FileLookup.LookupFile file) {
            VirtualFile vFile = ((VfsFile)file).getFile();
            if (vFile == null) {
                return false;
            }
            return this.myDescriptor.isFileVisible(vFile, this.myShowHidden);
        }
    }
}

