/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EmptyIndentsModel;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.textarea.TextAreaDocument;
import com.intellij.openapi.editor.textarea.TextComponentCaretModel;
import com.intellij.openapi.editor.textarea.TextComponentDocument;
import com.intellij.openapi.editor.textarea.TextComponentScrollingModel;
import com.intellij.openapi.editor.textarea.TextComponentSelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentEditor
extends UserDataHolderBase
implements Editor {
    private final Project myProject;
    private final JTextComponent myTextComponent;
    private final TextComponentDocument myDocument;
    private final TextComponentCaretModel myCaretModel;
    private final TextComponentSelectionModel mySelectionModel;
    private final TextComponentScrollingModel myScrollingModel;
    private EditorSettings mySettings;

    public TextComponentEditor(Project project, JTextComponent textComponent) {
        this.myProject = project;
        this.myTextComponent = textComponent;
        this.myDocument = textComponent instanceof JTextArea ? new TextAreaDocument((JTextArea)textComponent) : new TextComponentDocument(textComponent);
        this.myCaretModel = new TextComponentCaretModel(textComponent, this);
        this.mySelectionModel = new TextComponentSelectionModel(textComponent, this);
        this.myScrollingModel = new TextComponentScrollingModel(textComponent);
    }

    @NotNull
    public Document getDocument() {
        TextComponentDocument textComponentDocument = this.myDocument;
        if (textComponentDocument == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getDocument must not return null");
        }
        return textComponentDocument;
    }

    public boolean isViewer() {
        return !this.myTextComponent.isEditable();
    }

    @NotNull
    public JComponent getComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getComponent must not return null");
        }
        return jTextComponent;
    }

    @NotNull
    public JComponent getContentComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getContentComponent must not return null");
        }
        return jTextComponent;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        TextComponentSelectionModel textComponentSelectionModel = this.mySelectionModel;
        if (textComponentSelectionModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getSelectionModel must not return null");
        }
        return textComponentSelectionModel;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        TextComponentScrollingModel textComponentScrollingModel = this.myScrollingModel;
        if (textComponentScrollingModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getScrollingModel must not return null");
        }
        return textComponentScrollingModel;
    }

    @NotNull
    public CaretModel getCaretModel() {
        TextComponentCaretModel textComponentCaretModel = this.myCaretModel;
        if (textComponentCaretModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getCaretModel must not return null");
        }
        return textComponentCaretModel;
    }

    @NotNull
    public EditorSettings getSettings() {
        if (this.mySettings == null) {
            this.mySettings = new SettingsImpl(null);
        }
        EditorSettings editorSettings = this.mySettings;
        if (editorSettings == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.getSettings must not return null");
        }
        return editorSettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLineHeight() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.logicalPositionToXY must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.logicalPositionToOffset must not be null");
        }
        return this.myDocument.getLineStartOffset(pos.line) + pos.column;
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.logicalToVisualPosition must not be null");
        }
        VisualPosition visualPosition = new VisualPosition(logicalPos.line, logicalPos.column);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.logicalToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.visualPositionToXY must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.visualToLogicalPosition must not be null");
        }
        LogicalPosition logicalPosition = new LogicalPosition(visiblePos.line, visiblePos.column);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.visualToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        LogicalPosition logicalPosition = new LogicalPosition(line, offset - lineStartOffset);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.offsetToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        VisualPosition visualPosition = new VisualPosition(line, offset - lineStartOffset);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/textarea/TextComponentEditor.offsetToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.xyToLogicalPosition must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.xyToVisualPosition must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.addEditorMouseListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.removeEditorMouseListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.addEditorMouseMotionListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.removeEditorMouseMotionListener must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDisposed() {
        return false;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isInsertMode() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isColumnMode() {
        return false;
    }

    public boolean isOneLineMode() {
        return !(this.myTextComponent instanceof JTextArea);
    }

    @NotNull
    public EditorGutter getGutter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/textarea/TextComponentEditor.getMouseEventArea must not be null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    public IndentsModel getIndentsModel() {
        return new EmptyIndentsModel();
    }
}

