/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class TextComponentCaretModel
implements CaretModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;

    public TextComponentCaretModel(JTextComponent textComponent, TextComponentEditor editor) {
        this.myTextComponent = textComponent;
        this.myEditor = editor;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveToLogicalPosition(LogicalPosition pos) {
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos));
    }

    public void moveToVisualPosition(VisualPosition pos) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveToOffset(int offset) {
        this.myTextComponent.setCaretPosition(Math.min(offset, this.myTextComponent.getText().length()));
    }

    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        int caretPos = this.myTextComponent.getCaretPosition();
        if (this.myTextComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this.myTextComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        return new LogicalPosition(line, caretPos - lineStart);
    }

    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        return new VisualPosition(pos.line, pos.column);
    }

    public int getOffset() {
        return this.myTextComponent.getCaretPosition();
    }

    public void addCaretListener(CaretListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(CaretListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public TextAttributes getTextAttributes() {
        return null;
    }
}

