/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.PersistentLineMarker;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeHighlighterImpl
implements RangeHighlighterEx {
    private final MarkupModel myModel;
    private final int myLayer;
    private final HighlighterTargetArea myTargetArea;
    private TextAttributes myTextAttributes;
    private LineMarkerRenderer myLineMarkerRenderer;
    private Color myErrorStripeColor;
    private Color myLineSeparatorColor;
    private SeparatorPlacement mySeparatorPlacement;
    private boolean isAfterEndOfLine;
    private final RangeMarkerEx myRangeMarker;
    private GutterIconRenderer myGutterIconRenderer;
    private boolean myErrorStripeMarkIsThin;
    private Object myErrorStripeTooltip;
    private MarkupEditorFilter myFilter;
    private CustomHighlighterRenderer myCustomRenderer;

    RangeHighlighterImpl(@NotNull MarkupModel model, int start, int end, int layer, @NotNull HighlighterTargetArea target, TextAttributes textAttributes, boolean persistent) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeHighlighterImpl.<init> must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeHighlighterImpl.<init> must not be null");
        }
        this.myFilter = MarkupEditorFilter.EMPTY;
        this.myRangeMarker = persistent ? new PersistentLineMarker((DocumentEx)model.getDocument(), start) : (RangeMarkerEx)model.getDocument().createRangeMarker(start, end);
        this.myTextAttributes = textAttributes;
        this.myTargetArea = target;
        this.myLayer = layer;
        this.myModel = model;
        if (textAttributes != null) {
            this.myErrorStripeColor = textAttributes.getErrorStripeColor();
        }
    }

    public TextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    public void setTextAttributes(TextAttributes textAttributes) {
        TextAttributes old = this.myTextAttributes;
        this.myTextAttributes = textAttributes;
        if (!Comparing.equal((Object)old, (Object)textAttributes)) {
            this.fireChanged();
        }
    }

    public int getLayer() {
        return this.myLayer;
    }

    public HighlighterTargetArea getTargetArea() {
        return this.myTargetArea;
    }

    public int getAffectedAreaStartOffset() {
        int startOffset = this.getStartOffset();
        if (this.myTargetArea == HighlighterTargetArea.EXACT_RANGE) {
            return startOffset;
        }
        if (startOffset == this.getDocument().getTextLength()) {
            return startOffset;
        }
        return this.getDocument().getLineStartOffset(this.getDocument().getLineNumber(startOffset));
    }

    public int getAffectedAreaEndOffset() {
        int endOffset = this.getEndOffset();
        if (this.myTargetArea == HighlighterTargetArea.EXACT_RANGE) {
            return endOffset;
        }
        int textLength = this.getDocument().getTextLength();
        if (endOffset == textLength) {
            return endOffset;
        }
        return Math.min(textLength, this.getDocument().getLineEndOffset(this.getDocument().getLineNumber(endOffset)) + 1);
    }

    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.myLineMarkerRenderer;
    }

    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        this.myLineMarkerRenderer = renderer;
        this.fireChanged();
    }

    public CustomHighlighterRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        this.myCustomRenderer = renderer;
    }

    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        GutterIconRenderer old = this.myGutterIconRenderer;
        this.myGutterIconRenderer = renderer;
        if (!Comparing.equal((Object)old, (Object)renderer)) {
            this.fireChanged();
        }
    }

    public Color getErrorStripeMarkColor() {
        return this.myErrorStripeColor;
    }

    public void setErrorStripeMarkColor(Color color) {
        Color old = this.myErrorStripeColor;
        this.myErrorStripeColor = color;
        if (!Comparing.equal((Object)old, (Object)color)) {
            this.fireChanged();
        }
    }

    public Object getErrorStripeTooltip() {
        return this.myErrorStripeTooltip;
    }

    public void setErrorStripeTooltip(Object tooltipObject) {
        Object old = this.myErrorStripeTooltip;
        this.myErrorStripeTooltip = tooltipObject;
        if (!Comparing.equal((Object)old, (Object)tooltipObject)) {
            this.fireChanged();
        }
    }

    public boolean isThinErrorStripeMark() {
        return this.myErrorStripeMarkIsThin;
    }

    public void setThinErrorStripeMark(boolean value) {
        boolean old = this.myErrorStripeMarkIsThin;
        this.myErrorStripeMarkIsThin = value;
        if (old != value) {
            this.fireChanged();
        }
    }

    public Color getLineSeparatorColor() {
        return this.myLineSeparatorColor;
    }

    public void setLineSeparatorColor(Color color) {
        Color old = this.myLineSeparatorColor;
        this.myLineSeparatorColor = color;
        if (!Comparing.equal((Object)old, (Object)color)) {
            this.fireChanged();
        }
    }

    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.mySeparatorPlacement;
    }

    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        SeparatorPlacement old = this.mySeparatorPlacement;
        this.mySeparatorPlacement = placement;
        if (!Comparing.equal((Object)old, (Object)placement)) {
            this.fireChanged();
        }
    }

    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeHighlighterImpl.setEditorFilter must not be null");
        }
        this.myFilter = filter;
        this.fireChanged();
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.myFilter;
        if (markupEditorFilter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/RangeHighlighterImpl.getEditorFilter must not return null");
        }
        return markupEditorFilter;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.isAfterEndOfLine;
    }

    @Override
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        boolean old = this.isAfterEndOfLine;
        this.isAfterEndOfLine = afterEndOfLine;
        if (old != afterEndOfLine) {
            this.fireChanged();
        }
    }

    private void fireChanged() {
        if (this.myModel instanceof MarkupModelImpl) {
            ((MarkupModelImpl)this.myModel).fireSegmentHighlighterChanged(this);
        }
    }

    public int getStartOffset() {
        return this.myRangeMarker.getStartOffset();
    }

    public long getId() {
        return this.myRangeMarker.getId();
    }

    public int getEndOffset() {
        return this.myRangeMarker.getEndOffset();
    }

    public boolean isValid() {
        return this.myRangeMarker.isValid();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myRangeMarker.getDocument();
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/RangeHighlighterImpl.getDocument must not return null");
        }
        return document;
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myRangeMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myRangeMarker.setGreedyToRight(greedy);
    }

    public boolean isGreedyToRight() {
        return this.myRangeMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myRangeMarker.isGreedyToLeft();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeHighlighterImpl.getUserData must not be null");
        }
        return (T)this.myRangeMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/RangeHighlighterImpl.putUserData must not be null");
        }
        this.myRangeMarker.putUserData(key, value);
    }

    public String toString() {
        return this.myRangeMarker.toString();
    }
}

