/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.ArrayList;
import java.util.List;

public class IndentsModelImpl
implements IndentsModel {
    private EditorImpl myEditor;
    private List<IndentGuideDescriptor> myIndents = new ArrayList<IndentGuideDescriptor>();

    public IndentsModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public IndentGuideDescriptor getCaretIndentGuide() {
        LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
        int column = pos.column;
        int line = pos.line;
        if (column > 0) {
            for (IndentGuideDescriptor indent : this.myIndents) {
                if (column != indent.indentLevel || line < indent.startLine || line >= indent.endLine) continue;
                return indent;
            }
        }
        return null;
    }

    public void assumeIndents(List<IndentGuideDescriptor> descriptors) {
        this.myIndents = descriptors;
    }
}

