/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.WeakHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DocumentMarkupModelManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentMarkupModelManager");
    private final WeakHashMap<DocumentImpl, String> myDocumentSet = new WeakHashMap();
    private final Project myProject;
    private boolean myIsDisposed = false;

    public static DocumentMarkupModelManager getInstance(Project project) {
        return (DocumentMarkupModelManager)project.getComponent(DocumentMarkupModelManager.class);
    }

    public DocumentMarkupModelManager(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.cleanup();
    }

    public void registerDocument(DocumentImpl doc) {
        LOG.assertTrue(!this.myIsDisposed);
        this.myDocumentSet.put((Object)doc, (Object)"");
    }

    @NotNull
    public String getComponentName() {
        if ("DocumentMarkupModelManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentMarkupModelManager.getComponentName must not return null");
        }
        return "DocumentMarkupModelManager";
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.cleanup();
    }

    private void cleanup() {
        if (!this.myIsDisposed) {
            this.myIsDisposed = true;
            Set docs = this.myDocumentSet.keySet();
            for (DocumentImpl doc : docs) {
                doc.removeMarkupModel(this.myProject);
            }
        }
    }
}

