/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeIterator;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class BorderEffect {
    private final Graphics myGraphics;
    private final int myStartOffset;
    private final int myEndOffset;
    private final TextRange myRange;
    private final EditorImpl myEditor;
    private static final Equality<TextAttributes> SAME_COLOR_BOXES = new Equality<TextAttributes>(){

        public boolean equals(TextAttributes attributes1, TextAttributes attributes2) {
            Color effectColor = attributes1.getEffectColor();
            EffectType effectType = attributes1.getEffectType();
            return effectColor != null && effectColor.equals(attributes2.getEffectColor()) && EffectType.BOXED == effectType && effectType == attributes2.getEffectType();
        }
    };
    private static final Condition<TextAttributes> BOX_FILTER = new Condition<TextAttributes>(){

        public boolean value(TextAttributes attributes) {
            return attributes.getEffectColor() != null && attributes.getEffectType() == EffectType.BOXED;
        }
    };

    public BorderEffect(EditorImpl editor, Graphics graphics) {
        this.myEditor = editor;
        this.myGraphics = graphics;
        Rectangle clipBounds = this.myGraphics.getClipBounds();
        this.myStartOffset = BorderEffect.yToLineStartOffset(editor, clipBounds.y);
        this.myEndOffset = BorderEffect.yToLineStartOffset(editor, clipBounds.y + clipBounds.height + editor.getLineHeight());
        this.myRange = new TextRange(this.myStartOffset, this.myEndOffset);
    }

    private static int yToLineStartOffset(EditorImpl editor, int y) {
        Point point = new Point(0, y);
        LogicalPosition logicalStart = editor.xyToLogicalPosition(point);
        return editor.logicalPositionToOffset(logicalStart);
    }

    public void paintHighlighters(RangeHighlighter[] highlighterList) {
        for (RangeHighlighter aHighlighterList : highlighterList) {
            TextAttributes textAttributes;
            RangeHighlighterImpl rangeHighlighter = (RangeHighlighterImpl)aHighlighterList;
            if (!rangeHighlighter.isValid() || !BorderEffect.isBorder(textAttributes = rangeHighlighter.getTextAttributes()) || !this.intersectsRange(rangeHighlighter)) continue;
            this.paintBorder(rangeHighlighter);
        }
    }

    private static boolean isBorder(TextAttributes textAttributes) {
        return textAttributes != null && textAttributes.getEffectColor() != null && EffectType.BOXED == textAttributes.getEffectType();
    }

    private void paintBorder(RangeHighlighterImpl rangeHighlighter) {
        this.paintBorder(rangeHighlighter.getTextAttributes().getEffectColor(), rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset());
    }

    private void paintBorder(Color color, int startOffset, int endOffset) {
        BorderEffect.paintBorder(this.myGraphics, this.myEditor, startOffset, endOffset, color);
    }

    private boolean intersectsRange(RangeHighlighterImpl rangeHighlighter) {
        return this.myRange.contains(rangeHighlighter.getAffectedAreaStartOffset()) || this.myRange.contains(rangeHighlighter.getAffectedAreaEndOffset());
    }

    public void paintHighlighters(EditorHighlighter highlighter) {
        int startOffset = this.startOfLineByOffset(this.myStartOffset);
        if (0 > startOffset || startOffset >= this.myEditor.getDocument().getTextLength()) {
            return;
        }
        RangeIterator iterator = new RangeIterator(new FoldingOrNewLineGaps(this.myEditor), SAME_COLOR_BOXES, highlighter.createIterator(startOffset), BOX_FILTER);
        iterator.init(this.myRange);
        while (!iterator.atEnd()) {
            iterator.advance();
            BorderEffect.paintBorder(this.myGraphics, this.myEditor, iterator.getStart(), iterator.getEnd(), iterator.getTextAttributes().getEffectColor());
        }
    }

    private int startOfLineByOffset(int offset) {
        int line = this.myEditor.offsetToLogicalPosition((int)offset).line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return -1;
        }
        return this.myEditor.getDocument().getLineStartOffset(line);
    }

    private static void paintBorder(Graphics g, EditorImpl editor, int startOffset, int endOffset, Color color) {
        Color savedColor = g.getColor();
        g.setColor(color);
        BorderEffect.paintBorder(g, editor, startOffset, endOffset);
        g.setColor(savedColor);
    }

    private static void paintBorder(Graphics g, EditorImpl editor, int startOffset, int endOffset) {
        Point startPoint = BorderEffect.offsetToXY(editor, startOffset);
        Point endPoint = BorderEffect.offsetToXY(editor, endOffset);
        int height = endPoint.y - startPoint.y;
        int startX = startPoint.x;
        int startY = startPoint.y;
        int endX = endPoint.x;
        if (height == 0) {
            int width = endX == startX ? 1 : endX - startX - 1;
            g.drawRect(startX, startY, width, editor.getLineHeight() - 1);
            return;
        }
        BorderGraphics border = new BorderGraphics(g, startX, startY);
        border.horizontalTo(editor.getMaxWidthInRange(startOffset, endOffset) - 1);
        border.verticalRel(height - 1);
        border.horizontalTo(endX);
        border.verticalRel(editor.getLineHeight());
        border.horizontalTo(0);
        border.verticalRel(-height + 1);
        border.horizontalTo(startX);
        border.verticalTo(startY);
    }

    private static Point offsetToXY(EditorImpl editor, int offset) {
        return editor.logicalPositionToXY(editor.offsetToLogicalPosition(offset));
    }

    public static void paintFoldedEffect(Graphics g, int foldingXStart, int y, int foldingXEnd, int lineHeight, Color effectColor, EffectType effectType) {
        if (effectColor == null || effectType != EffectType.BOXED) {
            return;
        }
        g.setColor(effectColor);
        g.drawRect(foldingXStart, y, foldingXEnd - foldingXStart, lineHeight - 1);
    }

    public static class BorderGraphics {
        private final Graphics myGraphics;
        private int myX;
        private int myY;

        public BorderGraphics(Graphics graphics, int startX, int stIntY) {
            this.myGraphics = graphics;
            this.myX = startX;
            this.myY = stIntY;
        }

        public void horizontalTo(int x) {
            this.lineTo(x, this.myY);
        }

        public void horizontalRel(int width) {
            this.lineTo(this.myX + width, this.myY);
        }

        private void lineTo(int x, int y) {
            UIUtil.drawLine((Graphics)this.myGraphics, (int)this.myX, (int)this.myY, (int)x, (int)y);
            this.myX = x;
            this.myY = y;
        }

        public void verticalRel(int height) {
            this.lineTo(this.myX, this.myY + height);
        }

        public void verticalTo(int y) {
            this.lineTo(this.myX, y);
        }
    }

    private static class FoldingOrNewLineGaps
    implements RangeIterator.Gaps {
        private final RangeIterator.FoldingGaps myFoldingGaps;
        private final CharSequence myChars;

        public FoldingOrNewLineGaps(CharSequence chars, RangeIterator.FoldingGaps foldingGaps) {
            this.myChars = chars;
            this.myFoldingGaps = foldingGaps;
        }

        public FoldingOrNewLineGaps(EditorImpl editor) {
            this(editor.getDocument().getCharsSequence(), new RangeIterator.FoldingGaps(editor.getFoldingModel()));
        }

        @Override
        public boolean isGapAt(int offset) {
            return this.myChars.charAt(offset) == '\n' || this.myFoldingGaps.isGapAt(offset);
        }
    }
}

