/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;

public class ToggleColumnModeAction
extends ToggleAction
implements DumbAware {
    public void setSelected(AnActionEvent e, boolean state) {
        EditorEx editor = ToggleColumnModeAction.getEditor(e);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (state) {
            boolean hasSelection = selectionModel.hasSelection();
            int selStart = selectionModel.getSelectionStart();
            int selEnd = selectionModel.getSelectionEnd();
            CaretModel caretModel = editor.getCaretModel();
            LogicalPosition blockStart = selStart == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selStart);
            LogicalPosition blockEnd = selEnd == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selEnd);
            editor.setColumnMode(true);
            if (hasSelection) {
                selectionModel.setBlockSelection(blockStart, blockEnd);
            } else {
                selectionModel.removeSelection();
            }
        } else {
            boolean hasSelection = selectionModel.hasBlockSelection();
            LogicalPosition blockStart = selectionModel.getBlockStart();
            LogicalPosition blockEnd = selectionModel.getBlockEnd();
            int selStart = hasSelection && blockStart != null ? editor.logicalPositionToOffset(blockStart) : 0;
            int selEnd = hasSelection && blockEnd != null ? editor.logicalPositionToOffset(blockEnd) : 0;
            editor.setColumnMode(false);
            if (hasSelection) {
                selectionModel.setSelection(selStart, selEnd);
            } else {
                selectionModel.removeSelection();
            }
        }
    }

    public boolean isSelected(AnActionEvent e) {
        EditorEx ex = ToggleColumnModeAction.getEditor(e);
        return ex != null && ex.isColumnMode();
    }

    private static EditorEx getEditor(AnActionEvent e) {
        return (EditorEx)PlatformDataKeys.EDITOR.getData(e.getDataContext());
    }

    public void update(AnActionEvent e) {
        if (ToggleColumnModeAction.getEditor(e) == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
            super.update(e);
        }
    }
}

