/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;

class MoveCaretLeftOrRightHandler
extends EditorActionHandler {
    private final Direction myDirection;

    MoveCaretLeftOrRightHandler(Direction direction) {
        this.myDirection = direction;
    }

    public void execute(Editor editor, DataContext dataContext) {
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (selectionModel.hasSelection()) {
            if (editor.getIndentsModel().getCaretIndentGuide() != null) {
                selectionModel.removeSelection();
            } else {
                int end;
                int rightGuard;
                int start = selectionModel.getSelectionStart();
                int leftGuard = start + (this.myDirection == Direction.LEFT ? 1 : 0);
                if (TextRange.from((int)leftGuard, (int)((rightGuard = (end = selectionModel.getSelectionEnd()) - (this.myDirection == Direction.RIGHT ? 1 : 0)) - leftGuard + 1)).contains(caretModel.getOffset())) {
                    selectionModel.removeSelection();
                    caretModel.moveToOffset(this.myDirection == Direction.RIGHT ? end : start);
                    scrollingModel.scrollToCaret(ScrollType.RELATIVE);
                    return;
                }
            }
        }
        caretModel.moveCaretRelatively(this.myDirection == Direction.RIGHT ? 1 : -1, 0, false, false, true);
    }

    static enum Direction {
        LEFT,
        RIGHT;

    }
}

