/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.DiffRequestFactoryImpl");

    public MergeRequest createMergeRequest(String leftText, String rightText, String originalContent, @NotNull VirtualFile file, Project project, @Nullable ActionButtonPresentation actionButtonPresentation) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl.createMergeRequest must not be null");
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        return new MergeRequestImpl(leftText, this.createMergeVersion(file, document, originalContent), rightText, project, actionButtonPresentation);
    }

    public MergeRequest create3WayDiffRequest(String leftText, String rightText, String originalContent, Project project, @Nullable ActionButtonPresentation actionButtonPresentation) {
        return new MergeRequestImpl(leftText, originalContent, rightText, project, actionButtonPresentation);
    }

    private MergeVersion createMergeVersion(VirtualFile file, Document document, String centerText) {
        if (document != null) {
            return new MergeVersion.MergeDocumentVersion(document, centerText);
        }
        return new MyMergeVersion(centerText, file);
    }

    private class MyMergeVersion
    implements MergeVersion {
        private final String myCenterText;
        private final VirtualFile myFile;

        public MyMergeVersion(String centerText, VirtualFile file) {
            this.myCenterText = centerText;
            this.myFile = file;
        }

        @Override
        public FileType getContentType() {
            return FileTypeManager.getInstance().getFileTypeByFile(this.myFile);
        }

        @Override
        public String getTextBeforeMerge() {
            return this.myCenterText;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.myCenterText.getBytes(this.myFile.getCharset().name());
        }

        @Override
        public VirtualFile getFile() {
            return this.myFile;
        }

        @Override
        public Document createWorkingDocument(Project project) {
            return EditorFactory.getInstance().createDocument((CharSequence)this.myCenterText);
        }

        @Override
        public void applyText(final String text, final Project project) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            MyMergeVersion.this.storeChangedContent(text);
                        }
                    }, DiffBundle.message((String)"merge.dialog.writing.to.file.command.name", (Object[])new Object[0]), null);
                }
            });
        }

        private void storeChangedContent(String text) {
            Document content = FileDocumentManager.getInstance().getDocument(this.myFile);
            content.replaceString(0, content.getTextLength(), (CharSequence)text);
        }
    }
}

