/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.LineRenderer;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeType {
    private static final int LAYER = 5999;
    private static final ChangeType INSERT = new ChangeType(TextDiffType.INSERT);
    private static final ChangeType DELETED = new ChangeType(TextDiffType.DELETED);
    private static final ChangeType CHANGE = new ChangeType(TextDiffType.CHANGED);
    static final ChangeType CONFLICT = new ChangeType(TextDiffType.CONFLICT);
    private final TextDiffType myDiffType;

    private ChangeType(TextDiffType diffType) {
        this.myDiffType = diffType;
    }

    public RangeHighlighter addMarker(ChangeSide changeSide, MarkupHolder markup) {
        String text = changeSide.getText();
        if (text != null && text.length() > 0) {
            return ChangeType.addBlock(text, changeSide, markup, this.myDiffType);
        }
        return ChangeType.addLine(markup, changeSide.getStartLine(), this.myDiffType, SeparatorPlacement.TOP);
    }

    public TextDiffType getTypeKey() {
        return this.myDiffType;
    }

    public TextDiffType getTextDiffType() {
        return this.getTypeKey();
    }

    private static RangeHighlighter addBlock(String text, ChangeSide changeSide, MarkupHolder markup, TextDiffType diffType) {
        int length = text.length();
        int start = changeSide.getStart();
        int end = start + length;
        RangeHighlighter highlighter = markup.addRangeHighlighter(start, end, 5999, diffType, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        highlighter.setLineMarkerRenderer(LineRenderer.top());
        highlighter.setLineSeparatorColor(Color.GRAY);
        if (text.charAt(length - 1) == '\n') {
            --end;
        }
        highlighter = markup.addRangeHighlighter(start, end, 5999, TextDiffType.NONE, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setLineSeparatorPlacement(SeparatorPlacement.BOTTOM);
        highlighter.setLineSeparatorColor(Color.GRAY);
        highlighter.setLineMarkerRenderer(LineRenderer.bottom());
        return highlighter;
    }

    private static RangeHighlighter addLine(MarkupHolder markup, int line, TextDiffType type, SeparatorPlacement placement) {
        RangeHighlighter highlighter = markup.addLineHighlighter(line, 5999, type);
        if (highlighter == null) {
            return null;
        }
        highlighter.setLineSeparatorPlacement(placement);
        return highlighter;
    }

    public static ChangeType fromDiffFragment(DiffFragment fragment) {
        if (fragment.getText1() == null) {
            return INSERT;
        }
        if (fragment.getText2() == null) {
            return DELETED;
        }
        return CHANGE;
    }

    public static ChangeType fromRanges(@NotNull TextRange left, @NotNull TextRange right) {
        if (left == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/ChangeType.fromRanges must not be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/ChangeType.fromRanges must not be null");
        }
        if (left.getLength() == 0) {
            return INSERT;
        }
        if (right.getLength() == 0) {
            return DELETED;
        }
        return CHANGE;
    }

    public static void apply(RangeMarker original, RangeMarker target) {
        Document document = target.getDocument();
        if (DocumentUtil.isEmpty(original)) {
            int offset = target.getStartOffset();
            document.deleteString(offset, target.getEndOffset());
        }
        String text = DocumentUtil.getText(original);
        int startOffset = target.getStartOffset();
        if (DocumentUtil.isEmpty(target)) {
            document.insertString(startOffset, (CharSequence)text);
        } else {
            document.replaceString(startOffset, target.getEndOffset(), (CharSequence)text);
        }
    }

    public String toString() {
        return this.myDiffType.getDisplayName();
    }

    public static abstract class ChangeSide {
        public int getStart() {
            return this.getRange().getStartOffset();
        }

        public int getStartLine() {
            return DocumentUtil.getStartLine(this.getRange());
        }

        public String getText() {
            return DocumentUtil.getText(this.getRange());
        }

        public int getEndLine() {
            return DocumentUtil.getEndLine(this.getRange());
        }

        public abstract DiffRangeMarker getRange();

        public abstract Change.HighlighterHolder getHighlighterHolder();

        public boolean contains(int offset) {
            return this.getStart() <= offset && offset < this.getEnd();
        }

        public int getEnd() {
            return this.getRange().getEndOffset();
        }
    }

    public static interface MarkupHolder {
        @Nullable
        public RangeHighlighter addLineHighlighter(int var1, int var2, TextDiffType var3);

        @Nullable
        public RangeHighlighter addRangeHighlighter(int var1, int var2, int var3, TextDiffType var4, HighlighterTargetArea var5);
    }
}

