/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

public class DiffOptionsForm
implements SearchableConfigurable {
    private JComponent myPanel;
    private JCheckBox myEnableFolders;
    private JCheckBox myEnableFiles;
    private TextFieldWithBrowseButton myFoldersTool;
    private TextFieldWithBrowseButton myFilesTool;
    private final ToolPath[] myTools = new ToolPath[2];

    public DiffOptionsForm() {
        this.$$$setupUI$$$();
        this.myTools[0] = new ToolPath(this.myEnableFolders, this.myFoldersTool, DiffManagerImpl.FOLDERS_TOOL, DiffManagerImpl.ENABLE_FOLDERS);
        this.myTools[1] = new ToolPath(this.myEnableFiles, this.myFilesTool, DiffManagerImpl.FILES_TOOL, DiffManagerImpl.ENABLE_FILES);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        for (ToolPath tool : this.myTools) {
            if (!tool.isModifier()) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        for (ToolPath tool : this.myTools) {
            tool.apply();
        }
    }

    public void reset() {
        for (ToolPath tool : this.myTools) {
            tool.reset();
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "External Diff Tools";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "diff";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel = new JPanel();
        this.myPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 5, 5), -1, 2, false, false));
        this.myEnableFolders = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.tool.for.directories.checkbox"));
        jCheckBox2.setMargin(new Insets(4, 2, 0, 2));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableFiles = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.tool.for.files.checkbox"));
        jCheckBox.setMargin(new Insets(4, 2, 0, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(16, -1), null, new Dimension(16, -1)));
        this.myFoldersTool = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(16, -1), null, new Dimension(16, -1)));
        this.myFilesTool = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ToolPath {
        private final JCheckBox myCheckBox;
        private final TextFieldWithBrowseButton myTextField;
        private final StringProperty myPathProperty;
        private final BooleanProperty myEnabledProperty;

        public ToolPath(JCheckBox checkBox, TextFieldWithBrowseButton textField, StringProperty pathProperty, BooleanProperty enabledProperty) {
            this.myCheckBox = checkBox;
            this.myTextField = textField;
            this.myPathProperty = pathProperty;
            this.myEnabledProperty = enabledProperty;
            ButtonModel model = this.myCheckBox.getModel();
            model.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolPath.this.updateEnabledEffect();
                }
            });
            this.myTextField.addBrowseFolderListener(DiffBundle.message((String)"select.external.diff.program.dialog.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), TextComponentAccessor.TEXT_FIELD_SELECTED_TEXT);
        }

        private void updateEnabledEffect() {
            UIUtil.setEnabled((Component)this.myTextField, (boolean)this.isEnabled(), (boolean)true);
        }

        public boolean isModifier() {
            AbstractProperty.AbstractPropertyContainer properties = ToolPath.getProperties();
            return !this.myTextField.getText().equals(this.myPathProperty.get(properties)) || this.isEnabled() != this.myEnabledProperty.value(properties);
        }

        private boolean isEnabled() {
            return this.myCheckBox.getModel().isSelected();
        }

        private static AbstractProperty.AbstractPropertyContainer getProperties() {
            return DiffManagerImpl.getInstanceEx().getProperties();
        }

        public void apply() {
            this.myPathProperty.set(ToolPath.getProperties(), (Object)this.myTextField.getText());
            this.myEnabledProperty.primSet(ToolPath.getProperties(), this.isEnabled());
        }

        public void reset() {
            this.myTextField.setText((String)this.myPathProperty.get(ToolPath.getProperties()));
            this.myCheckBox.getModel().setSelected(this.myEnabledProperty.value(ToolPath.getProperties()));
            this.updateEnabledEffect();
        }
    }
}

