/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.CompoundExternalizationSession;
import com.intellij.util.io.fs.IFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompoundSaveSession {
    private final Map<StateStorage, StateStorage.SaveSession> mySaveSessions = new HashMap<StateStorage, StateStorage.SaveSession>();

    public CompoundSaveSession(CompoundExternalizationSession compoundExternalizationSession) {
        Collection<StateStorage> stateStorages = compoundExternalizationSession.getStateStorages();
        for (StateStorage stateStorage : stateStorages) {
            this.mySaveSessions.put(stateStorage, stateStorage.startSave(compoundExternalizationSession.getExternalizationSession(stateStorage)));
        }
    }

    public List<IFile> getAllStorageFilesToSave() throws StateStorage.StateStorageException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (StateStorage stateStorage : this.mySaveSessions.keySet()) {
            StateStorage.SaveSession saveSession = this.mySaveSessions.get(stateStorage);
            result.addAll(saveSession.getStorageFilesToSave());
        }
        return result;
    }

    public void save() throws StateStorage.StateStorageException {
        for (StateStorage.SaveSession saveSession : this.mySaveSessions.values()) {
            saveSession.save();
        }
    }

    public void finishSave() {
        RuntimeException re = null;
        for (StateStorage stateStorage : this.mySaveSessions.keySet()) {
            StateStorage.SaveSession saveSession = this.mySaveSessions.get(stateStorage);
            try {
                stateStorage.finishSave(saveSession);
            }
            catch (RuntimeException t) {
                re = t;
            }
        }
        if (re != null) {
            throw re;
        }
    }

    public StateStorage.SaveSession getSaveSession(StateStorage storage) {
        return this.mySaveSessions.get(storage);
    }

    public List<IFile> getAllStorageFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (StateStorage.SaveSession saveSession : this.mySaveSessions.values()) {
            result.addAll(saveSession.getAllStorageFiles());
        }
        return result;
    }
}

